/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.stats;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.WebModuleStats;
import com.sun.enterprise.web.MonitorStatsCapable;
import com.sun.enterprise.web.monitor.PwcWebModuleStats;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;
import org.apache.catalina.Manager;

public class WebModuleStatsImpl
implements WebModuleStats {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    protected Manager sessionManager;
    protected GenericStatsImpl baseStatsImpl;
    private PwcWebModuleStats pwcWebStats;
    private long initTime;
    protected MutableCountStatistic jspCount;
    protected MutableCountStatistic jspReloadCount;
    protected MutableCountStatistic jspErrorCount;
    protected MutableCountStatistic sessionsTotal;
    protected MutableCountStatistic activeSessionsCurrent;
    protected MutableCountStatistic activeSessionsHigh;
    protected MutableCountStatistic rejectedSessionsTotal;
    protected MutableCountStatistic expiredSessionsTotal;
    protected MutableCountStatistic processingTimeMillis;

    public WebModuleStatsImpl() {
        this(WebModuleStats.class);
    }

    protected WebModuleStatsImpl(Class inter) {
        this.baseStatsImpl = new GenericStatsImpl(inter, (Object)this);
        this.initializeStatistics();
    }

    public void setSessionManager(Manager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("Null session manager");
        }
        this.sessionManager = manager;
    }

    public void setPwcWebModuleStats(PwcWebModuleStats pwcWebStats) {
        if (pwcWebStats == null) {
            throw new IllegalArgumentException("Null PwcWebModuleStats");
        }
        this.pwcWebStats = pwcWebStats;
    }

    public CountStatistic getJspCount() {
        if (this.pwcWebStats == null) {
            throw new IllegalArgumentException("Null PwcWebModuleStats");
        }
        this.jspCount.setCount((long)this.pwcWebStats.getJspCount());
        return (CountStatistic)this.jspCount.unmodifiableView();
    }

    public CountStatistic getJspReloadCount() {
        if (this.pwcWebStats == null) {
            throw new IllegalArgumentException("Null PwcWebModuleStats");
        }
        this.jspReloadCount.setCount((long)this.pwcWebStats.getJspReloadCount());
        return (CountStatistic)this.jspReloadCount.unmodifiableView();
    }

    public CountStatistic getJspErrorCount() {
        if (this.pwcWebStats == null) {
            throw new IllegalArgumentException("Null PwcWebModuleStats");
        }
        this.jspErrorCount.setCount((long)this.pwcWebStats.getJspErrorCount());
        return (CountStatistic)this.jspErrorCount.unmodifiableView();
    }

    public CountStatistic getSessionsTotal() {
        if (this.pwcWebStats == null) {
            throw new IllegalArgumentException("Null PwcWebModuleStats");
        }
        this.sessionsTotal.setCount((long)this.pwcWebStats.getSessionsTotal());
        return (CountStatistic)this.sessionsTotal.unmodifiableView();
    }

    public CountStatistic getActiveSessionsCurrent() {
        if (this.pwcWebStats == null) {
            throw new IllegalArgumentException("Null PwcWebModuleStats");
        }
        this.activeSessionsCurrent.setCount((long)this.pwcWebStats.getActiveSessionsCurrent());
        return (CountStatistic)this.activeSessionsCurrent.unmodifiableView();
    }

    public CountStatistic getActiveSessionsHigh() {
        if (this.pwcWebStats == null) {
            throw new IllegalArgumentException("Null PwcWebModuleStats");
        }
        this.activeSessionsHigh.setCount((long)this.pwcWebStats.getActiveSessionsHigh());
        return (CountStatistic)this.activeSessionsHigh.unmodifiableView();
    }

    public CountStatistic getRejectedSessionsTotal() {
        if (this.pwcWebStats == null) {
            throw new IllegalArgumentException("Null PwcWebModuleStats");
        }
        this.rejectedSessionsTotal.setCount((long)this.pwcWebStats.getRejectedSessionsTotal());
        return (CountStatistic)this.rejectedSessionsTotal.unmodifiableView();
    }

    public CountStatistic getExpiredSessionsTotal() {
        if (this.pwcWebStats == null) {
            throw new IllegalArgumentException("Null PwcWebModuleStats");
        }
        this.expiredSessionsTotal.setCount((long)this.pwcWebStats.getExpiredSessionsTotal());
        return (CountStatistic)this.expiredSessionsTotal.unmodifiableView();
    }

    public CountStatistic getServletProcessingTimes() {
        if (this.pwcWebStats == null) {
            throw new IllegalArgumentException("Null PwcWebModuleStats");
        }
        this.processingTimeMillis.setCount(this.pwcWebStats.getServletProcessingTimesMillis());
        return (CountStatistic)this.processingTimeMillis.unmodifiableView();
    }

    public StringStatistic getSessions() {
        StringBuffer sb = null;
        if (this.pwcWebStats == null) {
            throw new IllegalArgumentException("Null PwcWebModuleStats");
        }
        String sessionIds = this.pwcWebStats.getSessionIds();
        if (sessionIds != null) {
            sb = new StringBuffer();
            StringTokenizer tokenizer = new StringTokenizer(sessionIds, " ");
            boolean first = true;
            while (tokenizer.hasMoreTokens()) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                String sessionId = tokenizer.nextToken();
                sb.append(sessionId);
                HashMap map = this.pwcWebStats.getSession(sessionId);
                if (map == null) continue;
                sb.append(":");
                sb.append(map);
            }
        }
        return new StringStatisticImpl(sb != null ? sb.toString() : null, "Sessions", "String", "List of currently active sessions", this.initTime, System.currentTimeMillis());
    }

    public void reset() {
        if (this.sessionManager instanceof MonitorStatsCapable) {
            ((MonitorStatsCapable)((Object)this.sessionManager)).resetMonitorStats();
        }
        if (this.pwcWebStats != null) {
            this.pwcWebStats.reset();
        }
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String name) {
        return this.baseStatsImpl.getStatistic(name);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        this.jspCount = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("JspCount"));
        this.jspReloadCount = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("JspReloadCount"));
        this.jspErrorCount = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("JspErrorCount"));
        this.sessionsTotal = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("SessionsTotal"));
        this.activeSessionsCurrent = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("ActiveSessionsCurrent"));
        this.activeSessionsHigh = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("ActiveSessionsHigh"));
        this.rejectedSessionsTotal = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("RejectedSessionsTotal"));
        this.expiredSessionsTotal = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("ExpiredSessionsTotal"));
        this.processingTimeMillis = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("ServletProcessingTimes"));
        this.initTime = System.currentTimeMillis();
    }
}

