/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.security.jauth.ServerAuthConfig;
import com.sun.enterprise.webservice.ImplementorCacheDelegateImpl;
import com.sun.enterprise.webservice.ServletSystemHandlerDelegate;
import com.sun.enterprise.webservice.WSSCallbackHandler;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.enterprise.webservice.monitoring.JAXRPCEndpointImpl;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import com.sun.logging.LogDomains;
import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.runtime.ImplementorCache;
import com.sun.xml.rpc.spi.runtime.ImplementorCacheDelegate;
import com.sun.xml.rpc.spi.runtime.RuntimeEndpointInfo;
import com.sun.xml.rpc.spi.runtime.ServletDelegate;
import com.sun.xml.rpc.spi.runtime.ServletSecondDelegate;
import com.sun.xml.rpc.spi.runtime.SystemHandlerDelegate;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletWebServiceDelegate
extends ServletSecondDelegate {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private WebServiceEndpoint endpoint_;
    private ServletConfig servletConfig_;
    private ServletDelegate rpcDelegate_;
    private JaxRpcObjectFactory rpcFactory_;
    private WebServiceEngineImpl wsEngine_;
    private JAXRPCEndpointImpl endpointImpl_;

    public ServletWebServiceDelegate(ServletDelegate firstDelegate) {
        this.rpcDelegate_ = firstDelegate;
        this.rpcFactory_ = JaxRpcObjectFactory.newInstance();
        this.wsEngine_ = WebServiceEngineImpl.getInstance();
    }

    public void postInit(ServletConfig servletConfig) throws ServletException {
        this.servletConfig_ = servletConfig;
        String servletName = "unknown";
        try {
            ServletSystemHandlerDelegate securityHandlerDelegate;
            InvocationManager invManager = Switch.getSwitch().getInvocationManager();
            ComponentInvocation inv = invManager.getCurrentInvocation();
            Object containerContext = inv.getContainerContext();
            WebBundleDescriptor webBundle = (WebBundleDescriptor)Switch.getSwitch().getDescriptorFor(containerContext);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            servletName = servletConfig.getServletName();
            WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(servletName);
            if (webComponent != null) {
                WebServicesDescriptor webServices = webBundle.getWebServices();
                Collection<WebServiceEndpoint> endpoints = webServices.getEndpointsImplementedBy(webComponent);
                this.endpoint_ = endpoints.iterator().next();
                this.registerEndpoint(classLoader);
                securityHandlerDelegate = null;
                if (!this.endpoint_.hasAuthMethod()) {
                    try {
                        ServerAuthConfig config = ServerAuthConfig.getConfig("SOAP", this.endpoint_.getMessageSecurityBinding(), WSSCallbackHandler.getInstance());
                        if (config != null) {
                            securityHandlerDelegate = new ServletSystemHandlerDelegate(config);
                            this.rpcDelegate_.setSystemHandlerDelegate((SystemHandlerDelegate)securityHandlerDelegate);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Servlet Webservice security configuration Failure", e);
                    }
                }
            } else {
                throw new ServletException(servletName + " not found");
            }
            this.endpointImpl_ = (JAXRPCEndpointImpl)this.wsEngine_.createHandler(securityHandlerDelegate, this.endpoint_);
            this.rpcDelegate_.setSystemHandlerDelegate((SystemHandlerDelegate)this.endpointImpl_);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Servlet web service endpoint '" + servletName + "' failure", t);
            ServletException se = new ServletException();
            se.initCause(t);
            throw se;
        }
    }

    public void destroy() {
        this.wsEngine_.removeHandler(this.endpoint_);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        WsUtil wsUtil = new WsUtil();
        try {
            wsUtil.handleGet(request, response, this.endpoint_);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Servlet web service endpoint '" + this.endpoint_.getEndpointName() + "' HTTP GET error", e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.rpcDelegate_.doPost(request, response);
    }

    public void warnMissingContextInformation() {
    }

    public ImplementorCache createImplementorCache(ServletConfig sc) {
        ImplementorCache ic = this.rpcFactory_.createImplementorCache(sc);
        ImplementorCacheDelegateImpl delegate = new ImplementorCacheDelegateImpl(sc);
        ic.setDelegate((ImplementorCacheDelegate)delegate);
        return ic;
    }

    private void registerEndpoint(ClassLoader loader) throws Exception {
        RuntimeEndpointInfo endpointInfo = this.rpcFactory_.createRuntimeEndpointInfo();
        Class<?> serviceEndpointInterfaceClass = loader.loadClass(this.endpoint_.getServiceEndpointInterface());
        Class<?> implementationClass = loader.loadClass(this.endpoint_.getServletImplClass());
        String tieClassName = this.endpoint_.getTieClassName();
        if (tieClassName != null) {
            Class<?> tieClass = loader.loadClass(tieClassName);
            endpointInfo.setTieClass(tieClass);
        }
        endpointInfo.setRemoteInterface(serviceEndpointInterfaceClass);
        endpointInfo.setImplementationClass(implementationClass);
        endpointInfo.setName(this.endpoint_.getEndpointName());
        WebService webService = this.endpoint_.getWebService();
        endpointInfo.setDeployed(true);
        endpointInfo.setPortName(this.endpoint_.getWsdlPort());
        endpointInfo.setServiceName(this.endpoint_.getServiceName());
        String uri = this.endpoint_.getEndpointAddressUri();
        uri = uri.startsWith("/") ? uri : "/" + uri;
        endpointInfo.setUrlPattern(uri);
        this.rpcDelegate_.registerEndpointUrlPattern(endpointInfo);
    }
}

