/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice.monitoring;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.webservice.monitoring.AuthenticationListener;
import com.sun.enterprise.webservice.monitoring.Endpoint;
import com.sun.enterprise.webservice.monitoring.EndpointImpl;
import com.sun.enterprise.webservice.monitoring.EndpointLifecycleListener;
import com.sun.enterprise.webservice.monitoring.EndpointType;
import com.sun.enterprise.webservice.monitoring.GlobalMessageListener;
import com.sun.enterprise.webservice.monitoring.JAXRPCEndpointImpl;
import com.sun.enterprise.webservice.monitoring.JAXWSEndpointImpl;
import com.sun.enterprise.webservice.monitoring.LogAuthenticationListener;
import com.sun.enterprise.webservice.monitoring.NamespaceContextImpl;
import com.sun.enterprise.webservice.monitoring.TransportInfo;
import com.sun.enterprise.webservice.monitoring.WebServiceEngine;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineFactory;
import com.sun.logging.LogDomains;
import com.sun.xml.rpc.spi.runtime.SOAPMessageContext;
import com.sun.xml.ws.spi.runtime.SystemHandlerDelegate;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceEngineImpl
implements WebServiceEngine {
    protected Map<String, Endpoint> endpoints = new HashMap<String, Endpoint>();
    protected List<EndpointLifecycleListener> lifecycleListeners = new ArrayList<EndpointLifecycleListener>();
    protected List<AuthenticationListener> authListeners = new ArrayList<AuthenticationListener>();
    protected GlobalMessageListener globalMessageListener = null;
    static WebServiceEngineFactory factory = WebServiceEngineFactory.getInstance();
    static ThreadLocal servletThreadLocal = new ThreadLocal();
    public static Logger sLogger = LogDomains.getLogger("javax.enterprise.system.core");

    protected WebServiceEngineImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebServiceEngineImpl getInstance() {
        if (factory.getEngine() == null) {
            WebServiceEngineFactory webServiceEngineFactory = factory;
            synchronized (webServiceEngineFactory) {
                if (factory.getEngine() == null) {
                    factory.setEngine(new WebServiceEngineImpl());
                    factory.getEngine().addAuthListener(new LogAuthenticationListener());
                }
            }
        }
        return (WebServiceEngineImpl)factory.getEngine();
    }

    private EndpointImpl createHandler(WebServiceEndpoint endpointDesc) {
        EndpointImpl newEndpoint = this.createEndpointInfo(endpointDesc);
        if (newEndpoint == null) {
            return null;
        }
        String key = this.pathFromURL(newEndpoint.getEndpointSelector());
        this.endpoints.put(key, newEndpoint);
        for (EndpointLifecycleListener listener : this.lifecycleListeners) {
            listener.endpointAdded(newEndpoint);
        }
        return newEndpoint;
    }

    public EndpointImpl createHandler(com.sun.xml.rpc.spi.runtime.SystemHandlerDelegate parent, WebServiceEndpoint endpointDesc) {
        EndpointImpl newEndpoint = this.createHandler(endpointDesc);
        ((JAXRPCEndpointImpl)newEndpoint).setParent(parent);
        return newEndpoint;
    }

    public EndpointImpl createHandler(SystemHandlerDelegate parent, WebServiceEndpoint endpointDesc) {
        EndpointImpl newEndpoint = this.createHandler(endpointDesc);
        ((JAXWSEndpointImpl)newEndpoint).setParent(parent);
        return newEndpoint;
    }

    @Override
    public Endpoint getEndpoint(String url) {
        return this.endpoints.get(this.pathFromURL(url));
    }

    @Override
    public Iterator<Endpoint> getEndpoints() {
        return this.endpoints.values().iterator();
    }

    public void removeHandler(WebServiceEndpoint endpointDesc) {
        EndpointImpl endpoint = (EndpointImpl)endpointDesc.getExtraAttribute("MONITORING_ENDPOINT");
        if (endpoint == null) {
            return;
        }
        this.endpoints.remove(this.pathFromURL(endpoint.getEndpointSelector()));
        for (EndpointLifecycleListener listener : this.lifecycleListeners) {
            listener.endpointRemoved(endpoint);
        }
        endpoint.setDescriptor(null);
    }

    @Override
    public void addLifecycleListener(EndpointLifecycleListener listener) {
        this.lifecycleListeners.add(listener);
    }

    @Override
    public void removeLifecycleListener(EndpointLifecycleListener listener) {
        this.lifecycleListeners.remove(listener);
    }

    @Override
    public void addAuthListener(AuthenticationListener listener) {
        this.authListeners.add(listener);
    }

    @Override
    public void removeAuthListener(AuthenticationListener listener) {
        this.authListeners.remove(listener);
    }

    public Collection<AuthenticationListener> getAuthListeners() {
        return this.authListeners;
    }

    @Override
    public GlobalMessageListener getGlobalMessageListener() {
        return this.globalMessageListener;
    }

    @Override
    public void setGlobalMessageListener(GlobalMessageListener listener) {
        this.globalMessageListener = listener;
    }

    public boolean hasGlobalMessageListener() {
        return this.globalMessageListener != null;
    }

    private EndpointImpl createEndpointInfo(WebServiceEndpoint endpoint) {
        try {
            ModuleType moduleType;
            String decodedFileName = URLDecoder.decode(endpoint.getWebService().getGeneratedWsdlFilePath());
            File wsdlFile = new File(decodedFileName);
            if (!wsdlFile.exists()) {
                return null;
            }
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            InputSource inputSource = new InputSource(new BufferedInputStream(new FileInputStream(wsdlFile)));
            Document wsdlDoc = dFactory.newDocumentBuilder().parse(new BufferedInputStream(new FileInputStream(wsdlFile)));
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            NamespaceContextImpl context = new NamespaceContextImpl(wsdlDoc);
            xPath.setNamespaceContext(context);
            String xpathExpression = "/:definitions/:service/:port[@name='" + endpoint.getWsdlPort().getLocalPart() + "']/" + endpoint.getSoapAddressPrefix() + ":address/@location";
            String endpointURL = xPath.evaluate(xpathExpression, inputSource);
            if (endpointURL == null) {
                System.out.println("Cannot get endpoint URL from " + endpoint.getWsdlPort());
            }
            EndpointType endpointType = (moduleType = endpoint.getWebService().getWebServicesDescriptor().getModuleType()).equals(ModuleType.EJB) ? EndpointType.EJB_ENDPOINT : EndpointType.SERVLET_ENDPOINT;
            EndpointImpl newEndpoint = endpoint.getWebService().getMappingFileUri() == null ? new JAXWSEndpointImpl(endpointURL, endpointType) : new JAXRPCEndpointImpl(endpointURL, endpointType);
            newEndpoint.setDescriptor(endpoint);
            return newEndpoint;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String preProcessRequest(Endpoint endpoint) {
        if (this.globalMessageListener == null) {
            return null;
        }
        return this.globalMessageListener.preProcessRequest(endpoint);
    }

    public void processRequest(String messageID, SOAPMessageContext context, TransportInfo info) {
        if (this.globalMessageListener == null) {
            return;
        }
        this.globalMessageListener.processRequest(messageID, context, info);
    }

    public void processResponse(String messageID, SOAPMessageContext context) {
        if (this.globalMessageListener == null) {
            return;
        }
        this.globalMessageListener.processResponse(messageID, context);
    }

    public void processRequest(String messageID, com.sun.xml.ws.spi.runtime.SOAPMessageContext context, TransportInfo info) {
        if (this.globalMessageListener == null) {
            return;
        }
        this.globalMessageListener.processRequest(messageID, context, info);
    }

    public void processResponse(String messageID, com.sun.xml.ws.spi.runtime.SOAPMessageContext context) {
        if (this.globalMessageListener == null) {
            return;
        }
        this.globalMessageListener.processResponse(messageID, context);
    }

    public void postProcessResponse(String messageID, TransportInfo info) {
        if (this.globalMessageListener == null) {
            return;
        }
        this.globalMessageListener.postProcessResponse(messageID, info);
    }

    public ThreadLocal getThreadLocal() {
        return servletThreadLocal;
    }

    private String pathFromURL(String urlString) {
        URL url;
        try {
            url = new URL(URLDecoder.decode(urlString));
        }
        catch (MalformedURLException e) {
            return null;
        }
        return url.getPath();
    }
}

