/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.common;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceSpec;
import com.sun.gjc.util.MethodExecutor;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;

public class DataSourceObjectBuilder
implements Serializable {
    private DataSourceSpec spec;
    private Hashtable driverProperties = null;
    private MethodExecutor executor = null;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private boolean debug = false;
    private StringManager sm = StringManager.getManager(DataSourceObjectBuilder.class);

    public DataSourceObjectBuilder(DataSourceSpec spec) {
        this.spec = spec;
        this.executor = new MethodExecutor();
    }

    public Object constructDataSourceObject() throws ResourceException {
        this.driverProperties = this.parseDriverProperties(this.spec);
        Object dataSourceObject = this.getDataSourceObject();
        Method[] methods = dataSourceObject.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (this.driverProperties.containsKey(methodName.toUpperCase())) {
                Vector values = (Vector)this.driverProperties.get(methodName.toUpperCase());
                this.executor.runMethod(methods[i], dataSourceObject, values);
                continue;
            }
            if (methodName.equalsIgnoreCase("setUser")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(1), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setPassword")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(2), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setLoginTimeOut")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(4), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setLogWriter")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(5), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setDatabaseName")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(6), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setDataSourceName")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(7), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setDescription")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(8), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setNetworkProtocol")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(9), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setPortNumber")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(10), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setRoleName")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(11), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setServerName")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(12), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setMaxStatements")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(13), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setInitialPoolSize")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(14), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setMinPoolSize")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(15), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setMaxPoolSize")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(16), methods[i], dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setMaxIdleTime")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(17), methods[i], dataSourceObject);
                continue;
            }
            if (!methodName.equalsIgnoreCase("setPropertyCycle")) continue;
            this.executor.runJavaBeanMethod(this.spec.getDetail(18), methods[i], dataSourceObject);
        }
        return dataSourceObject;
    }

    private Hashtable parseDriverProperties(DataSourceSpec spec) throws ResourceException {
        String delim = spec.getDetail(21);
        String prop = spec.getDetail(19);
        if (prop == null || prop.trim().equals("")) {
            return new Hashtable();
        }
        if (delim == null || delim.equals("")) {
            String msg = this.sm.getString("dsob.delim_not_specified");
            throw new ResourceException(msg);
        }
        Hashtable properties = new Hashtable();
        delim = delim.trim();
        String sep = delim + delim;
        int sepLen = sep.length();
        String cache = prop;
        Vector<String> methods = new Vector<String>();
        while (cache.indexOf(sep) != -1) {
            int index = cache.indexOf(sep);
            String name = cache.substring(0, index);
            if (name.trim() == "") continue;
            methods.add(name);
            cache = cache.substring(index + sepLen);
        }
        Enumeration allMethods = methods.elements();
        while (allMethods.hasMoreElements()) {
            String oneMethod = (String)allMethods.nextElement();
            if (oneMethod.trim().equals("")) continue;
            String methodName = null;
            Vector<String> parms = new Vector<String>();
            StringTokenizer methodDetails = new StringTokenizer(oneMethod, delim);
            int i = 0;
            while (methodDetails.hasMoreTokens()) {
                String token = methodDetails.nextToken();
                if (i == 0) {
                    methodName = token.toUpperCase();
                } else {
                    parms.add(token);
                }
                ++i;
            }
            properties.put(methodName, parms);
        }
        return properties;
    }

    private Object getDataSourceObject() throws ResourceException {
        String className = this.spec.getDetail(20);
        try {
            Class<?> dataSourceClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            Object dataSourceObject = dataSourceClass.newInstance();
            return dataSourceObject;
        }
        catch (ClassNotFoundException cfne) {
            _logger.log(Level.SEVERE, "jdbc.exc_cnfe_ds", cfne);
            String msg = this.sm.getString("dsob.class_not_found", className);
            throw new ResourceException(msg);
        }
        catch (InstantiationException ce) {
            _logger.log(Level.SEVERE, "jdbc.exc_inst", className);
            String msg = this.sm.getString("dsob.error_instantiating", className);
            throw new ResourceException(msg);
        }
        catch (IllegalAccessException ce) {
            _logger.log(Level.SEVERE, "jdbc.exc_acc_inst", className);
            String msg = this.sm.getString("dsob.access_error", className);
            throw new ResourceException(msg);
        }
    }
}

