/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.modeler.ant;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import com.sun.org.apache.commons.modeler.ManagedBean;
import com.sun.org.apache.commons.modeler.Registry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import org.apache.tools.ant.BuildException;

public final class RegistryTask {
    private static Log log = LogFactory.getLog(RegistryTask.class);
    String resource;
    String file;
    String type = "MbeansDescriptorsDOMSource";
    String outFile;

    public void setType(String type) {
        this.type = type;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setResource(String res) {
        this.resource = res;
    }

    public void setOut(String outFile) {
        this.outFile = outFile;
    }

    public void execute() throws Exception {
        URL url = null;
        if (this.resource != null) {
            url = this.getClass().getClassLoader().getResource(this.resource);
        } else if (this.file != null) {
            File f = new File(this.file);
            url = new URL("file", null, f.getAbsolutePath());
        } else {
            throw new BuildException("Resource or file attribute required");
        }
        Registry.getRegistry().loadDescriptors(this.type, url, null);
        if (this.outFile != null) {
            FileOutputStream fos = new FileOutputStream(this.outFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            Registry reg = Registry.getRegistry();
            String[] beans = reg.findManagedBeans();
            ManagedBean[] mbeans = new ManagedBean[beans.length];
            for (int i = 0; i < beans.length; ++i) {
                mbeans[i] = reg.findManagedBean(beans[i]);
            }
            oos.writeObject(mbeans);
            oos.flush();
            oos.close();
            fos.close();
        }
    }
}

