/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.Base64;

public class BasicAuthenticator
extends AuthenticatorBase {
    private static Log log = LogFactory.getLog(BasicAuthenticator.class);
    protected static final Base64 base64Helper = new Base64();
    protected static final String info = "org.apache.catalina.authenticator.BasicAuthenticator/1.0";

    public String getInfo() {
        return info;
    }

    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        String realmName;
        Principal principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal();
        if (principal != null) {
            if (log.isDebugEnabled()) {
                log.debug("Already authenticated '" + principal.getName() + "'");
            }
            return true;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        String authorization = request.getAuthorization();
        if (authorization != null) {
            String username = this.parseUsername(authorization);
            String password = this.parsePassword(authorization);
            principal = this.context.getRealm().authenticate(username, password);
            if (principal != null) {
                this.register(request, response, principal, "BASIC", username, password);
                return true;
            }
        }
        if ((realmName = config.getRealmName()) == null) {
            realmName = hreq.getServerName() + ":" + hreq.getServerPort();
        }
        hres.setHeader("WWW-Authenticate", "Basic realm=\"" + realmName + "\"");
        hres.sendError(401);
        return false;
    }

    protected String parseUsername(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.toLowerCase().startsWith("basic ")) {
            return null;
        }
        authorization = authorization.substring(6).trim();
        String unencoded = new String(Base64.decode(authorization.getBytes()));
        int colon = unencoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        String username = unencoded.substring(0, colon);
        return username;
    }

    protected String parsePassword(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Basic ")) {
            return null;
        }
        authorization = authorization.substring(6).trim();
        String unencoded = new String(Base64.decode(authorization.getBytes()));
        int colon = unencoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        String password = unencoded.substring(colon + 1);
        return password;
    }
}

