/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import com.sun.org.apache.commons.modeler.Registry;
import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.catalina.Group;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.mbeans.MBeanUtils;

public class GlobalResourcesLifecycleListener
implements LifecycleListener {
    private static Log log = LogFactory.getLog(GlobalResourcesLifecycleListener.class);
    protected Lifecycle component = null;
    protected static final Registry registry = MBeanUtils.createRegistry();
    protected int debug = 0;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if ("start".equals(event.getType())) {
            this.component = event.getLifecycle();
            this.createMBeans();
        } else if ("stop".equals(event.getType())) {
            this.destroyMBeans();
            this.component = null;
        }
    }

    protected void createMBeans() {
        Context context = null;
        try {
            context = (Context)new InitialContext().lookup("java:/");
        }
        catch (NamingException e) {
            log.error("No global naming context defined for server");
            return;
        }
        try {
            this.createMBeans("", context);
        }
        catch (NamingException e) {
            log.error("Exception processing Global JNDI Resources", e);
        }
    }

    protected void createMBeans(String prefix, Context context) throws NamingException {
        if (this.debug >= 1) {
            log.debug("Creating MBeans for Global JNDI Resources in Context '" + prefix + "'");
        }
        try {
            NamingEnumeration<Binding> bindings = context.listBindings("");
            while (bindings.hasMore()) {
                Binding binding = bindings.next();
                String name = prefix + binding.getName();
                Object value = context.lookup(binding.getName());
                if (this.debug >= 2) {
                    log.debug("Checking resource " + name);
                }
                if (value instanceof Context) {
                    this.createMBeans(name + "/", (Context)value);
                    continue;
                }
                if (!(value instanceof UserDatabase)) continue;
                try {
                    this.createMBeans(name, (UserDatabase)value);
                }
                catch (Exception e) {
                    log.error("Exception creating UserDatabase MBeans for " + name, e);
                }
            }
        }
        catch (RuntimeException ex) {
            log.error("RuntimeException " + ex);
        }
        catch (OperationNotSupportedException ex) {
            log.error("Operation not supported " + ex);
        }
    }

    protected void createMBeans(String name, UserDatabase database) throws Exception {
        if (this.debug >= 2) {
            log.debug("Creating UserDatabase MBeans for resource " + name);
            log.debug("Database=" + database);
        }
        if (MBeanUtils.createMBean(database) == null) {
            throw new IllegalArgumentException("Cannot create UserDatabase MBean for resource " + name);
        }
        Iterator roles = database.getRoles();
        while (roles.hasNext()) {
            Role role = (Role)roles.next();
            if (this.debug >= 3) {
                log.error("  Creating Role MBean for role " + role);
            }
            if (MBeanUtils.createMBean(role) != null) continue;
            throw new IllegalArgumentException("Cannot create Role MBean for role " + role);
        }
        Iterator groups = database.getGroups();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            if (this.debug >= 3) {
                log.debug("  Creating Group MBean for group " + group);
            }
            if (MBeanUtils.createMBean(group) != null) continue;
            throw new IllegalArgumentException("Cannot create Group MBean for group " + group);
        }
        Iterator users = database.getUsers();
        while (users.hasNext()) {
            User user = (User)users.next();
            if (this.debug >= 3) {
                log.debug("  Creating User MBean for user " + user);
            }
            if (MBeanUtils.createMBean(user) != null) continue;
            throw new IllegalArgumentException("Cannot create User MBean for user " + user);
        }
    }

    protected void destroyMBeans() {
        if (this.debug >= 1) {
            log.debug("Destroying MBeans for Global JNDI Resources");
        }
    }

    protected void log(String message) {
        log.info(message);
    }

    protected void log(String message, Throwable throwable) {
        log.info(message, throwable);
    }
}

