/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.util.Locale;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.http.MimeHeaders;

public final class Response {
    private static Locale DEFAULT_LOCALE = Locale.getDefault();
    protected int status = 200;
    protected String message = null;
    protected MimeHeaders headers = new MimeHeaders();
    protected OutputBuffer outputBuffer;
    protected Object[] notes = new Object[32];
    protected boolean commited = false;
    public ActionHook hook;
    protected String contentType = null;
    protected String contentLanguage = null;
    protected String characterEncoding;
    private String quotedCharsetValue = this.characterEncoding = "ISO-8859-1";
    protected int contentLength = -1;
    private Locale locale = DEFAULT_LOCALE;
    private long bytesWritten = 0L;
    protected Exception errorException = null;
    protected boolean charsetSet = false;
    protected String errorURI = null;
    protected Request req;

    public Request getRequest() {
        return this.req;
    }

    public void setRequest(Request req) {
        this.req = req;
    }

    public OutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    public void setOutputBuffer(OutputBuffer outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public ActionHook getHook() {
        return this.hook;
    }

    public void setHook(ActionHook hook) {
        this.hook = hook;
    }

    public final void setNote(int pos, Object value) {
        this.notes[pos] = value;
    }

    public final Object getNote(int pos) {
        return this.notes[pos];
    }

    public void action(ActionCode actionCode, Object param) {
        if (this.hook != null) {
            if (param == null) {
                this.hook.action(actionCode, this);
            } else {
                this.hook.action(actionCode, param);
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isCommitted() {
        return this.commited;
    }

    public void setCommitted(boolean v) {
        this.commited = v;
    }

    public void setErrorException(Exception ex) {
        this.errorException = ex;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public boolean isExceptionPresent() {
        return this.errorException != null;
    }

    public void setErrorURI(String uri) {
        this.errorURI = uri;
    }

    public String getErrorURI() {
        return this.errorURI;
    }

    public void reset() throws IllegalStateException {
        this.contentType = null;
        this.locale = DEFAULT_LOCALE;
        this.contentLanguage = null;
        this.quotedCharsetValue = this.characterEncoding = "ISO-8859-1";
        this.contentLength = -1;
        this.charsetSet = false;
        this.status = 200;
        this.message = null;
        this.headers.clear();
        if (this.commited) {
            throw new IllegalStateException();
        }
        this.action(ActionCode.ACTION_RESET, this);
    }

    public void finish() throws IOException {
        this.action(ActionCode.ACTION_CLOSE, this);
    }

    public void acknowledge() throws IOException {
        this.action(ActionCode.ACTION_ACK, this);
    }

    public boolean containsHeader(String name) {
        return this.headers.getHeader(name) != null;
    }

    public void setHeader(String name, String value) {
        char cc = name.charAt(0);
        if ((cc == 'C' || cc == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        this.headers.setValue(name).setString(value);
    }

    public void addHeader(String name, String value) {
        char cc = name.charAt(0);
        if ((cc == 'C' || cc == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        this.headers.addValue(name).setString(value);
    }

    private boolean checkSpecialHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            this.setContentType(value);
            return true;
        }
        if (name.equalsIgnoreCase("Content-Length")) {
            try {
                int cL = Integer.parseInt(value);
                this.setContentLength(cL);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (name.equalsIgnoreCase("Content-Language")) {
            // empty if block
        }
        return false;
    }

    public void sendHeaders() throws IOException {
        this.action(ActionCode.ACTION_COMMIT, this);
        this.commited = true;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        this.locale = locale;
        this.contentLanguage = locale.getLanguage();
        if (this.contentLanguage != null && this.contentLanguage.length() > 0) {
            String country = locale.getCountry();
            StringBuffer value = new StringBuffer(this.contentLanguage);
            if (country != null && country.length() > 0) {
                value.append('-');
                value.append(country);
            }
            this.contentLanguage = value.toString();
        }
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public void setCharacterEncoding(String charset) {
        if (this.isCommitted()) {
            return;
        }
        if (charset == null) {
            return;
        }
        this.characterEncoding = charset;
        this.quotedCharsetValue = charset;
        this.charsetSet = true;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setContentType(String type) {
        int semicolonIndex = -1;
        if (type == null) {
            this.contentType = null;
            return;
        }
        boolean hasCharset = false;
        int len = type.length();
        int index = type.indexOf(59);
        while (index != -1) {
            semicolonIndex = index++;
            while (index < len && Character.isSpace(type.charAt(index))) {
                ++index;
            }
            if (index + 8 < len && type.charAt(index) == 'c' && type.charAt(index + 1) == 'h' && type.charAt(index + 2) == 'a' && type.charAt(index + 3) == 'r' && type.charAt(index + 4) == 's' && type.charAt(index + 5) == 'e' && type.charAt(index + 6) == 't' && type.charAt(index + 7) == '=') {
                hasCharset = true;
                break;
            }
            index = type.indexOf(59, index);
        }
        if (!hasCharset) {
            this.contentType = type;
            return;
        }
        this.contentType = type.substring(0, semicolonIndex);
        String tail = type.substring(index + 8);
        int nextParam = tail.indexOf(59);
        String charsetValue = null;
        if (nextParam != -1) {
            this.contentType = this.contentType + tail.substring(nextParam);
            charsetValue = tail.substring(0, nextParam);
        } else {
            charsetValue = tail;
        }
        if (charsetValue != null && charsetValue.length() > 0) {
            this.charsetSet = true;
            this.quotedCharsetValue = charsetValue;
            this.characterEncoding = charsetValue.replace('\"', ' ').trim();
        }
    }

    public String getContentType() {
        String ret = this.contentType;
        if (ret != null && this.quotedCharsetValue != null && this.charsetSet) {
            ret = ret + ";charset=" + this.quotedCharsetValue;
        }
        return ret;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void doWrite(ByteChunk chunk) throws IOException {
        this.outputBuffer.doWrite(chunk, this);
        this.bytesWritten += (long)chunk.getLength();
    }

    public void recycle() {
        this.contentType = null;
        this.contentLanguage = null;
        this.locale = DEFAULT_LOCALE;
        this.quotedCharsetValue = this.characterEncoding = "ISO-8859-1";
        this.charsetSet = false;
        this.contentLength = -1;
        this.status = 200;
        this.message = null;
        this.commited = false;
        this.errorException = null;
        this.errorURI = null;
        this.headers.clear();
        this.bytesWritten = 0L;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void setBytesWritten(long bytesWritten) {
        this.bytesWritten = bytesWritten;
    }
}

