/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound;

import com.sun.genericra.AbstractXAResourceType;
import com.sun.genericra.inbound.ActivationSpec;
import com.sun.genericra.inbound.DeadMessageProducer;
import com.sun.genericra.inbound.InboundJmsResource;
import com.sun.genericra.inbound.InboundJmsResourcePool;
import com.sun.genericra.inbound.InboundXAResourceProxy;
import com.sun.genericra.inbound.SimpleXAResourceProxy;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;

public class DeliveryHelper {
    ActivationSpec spec;
    InboundJmsResource jmsResource;
    XAResource xar;
    Message msg = null;
    Destination dest = null;
    boolean transacted;
    boolean sentToDmd = false;
    private static Logger _logger = LogUtils.getLogger();

    public DeliveryHelper(InboundJmsResource jmsResource, InboundJmsResourcePool pool) {
        this.spec = pool.getConsumer().getSpec();
        this.jmsResource = jmsResource;
        this.transacted = pool.isTransacted();
        AbstractXAResourceType xarObject = null;
        xarObject = this.redeliveryRequired() ? new InboundXAResourceProxy(jmsResource.getXAResource()) : new SimpleXAResourceProxy(jmsResource.getXAResource());
        xarObject.setRMPolicy(this.spec.getRMPolicy());
        xarObject.setConnection(pool.getConnection());
        this.xar = xarObject;
    }

    public boolean redeliveryRequired() {
        return this.transacted && this.spec.getRedeliveryAttempts() > 0;
    }

    public XAResource getXAResource() {
        return this.xar;
    }

    private DeadMessageProducer createProducer(Connection con, Destination dest) throws JMSException {
        return new DeadMessageProducer(con, this.jmsResource.getPool(), dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageToDMD() {
        _logger.log(Level.FINE, "Trying to send message  to DMD :" + this.dest);
        Object session = null;
        DeadMessageProducer msgProducer = null;
        try {
            if (this.dest != null && this.spec.getSendBadMessagesToDMD()) {
                _logger.log(Level.FINE, "Sending the message to DMD :" + this.dest);
                InboundXAResourceProxy localXar = (InboundXAResourceProxy)this.xar;
                if (!localXar.endCalled()) {
                    localXar.end(null, 0x4000000);
                }
                localXar.prepare(null);
                Connection connection = this.jmsResource.getPool().getConnectionForDMD();
                msgProducer = this.createProducer(connection, this.dest);
                msgProducer.send(this.msg);
                localXar.commit(null, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.msg = null;
            this.dest = null;
            this.sentToDmd = false;
            if (msgProducer != null) {
                try {
                    msgProducer.close();
                }
                catch (Exception me) {
                    me.printStackTrace();
                }
            }
        }
    }

    public void deliver(Message message, Destination d) {
        this.msg = message;
        this.dest = d;
        this.deliver();
    }

    public void deliver() {
        int myattempts = 0;
        int attempts = this.spec.getRedeliveryAttempts();
        InboundXAResourceProxy localXar = null;
        while (true) {
            try {
                this.deliverMessage(this.msg);
                if (localXar != null) {
                    localXar.setToRollback(true);
                }
            }
            catch (Exception e) {
                if (this.redeliveryRequired()) {
                    if (localXar == null) {
                        localXar = (InboundXAResourceProxy)this.xar;
                    }
                    localXar.setToRollback(false);
                }
                if (!this.transacted) break;
                try {
                    this.msg.setJMSRedelivered(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (myattempts < attempts) {
                    ++myattempts;
                    _logger.log(Level.FINEST, "Releasing the endpoint after an exception");
                    this.jmsResource.releaseEndpoint();
                    try {
                        Thread.sleep(this.spec.getRedeliveryInterval() * 1000);
                        _logger.log(Level.FINE, "getting the endpoint after an exception");
                        this.jmsResource.refresh();
                    }
                    catch (Exception ie) {
                        ie.printStackTrace();
                    }
                    continue;
                }
                this.markForDMD();
                _logger.log(Level.FINEST, "Sent the message to DMD :" + this.dest);
            }
            break;
        }
    }

    public void markForDMD() {
        this.sentToDmd = true;
    }

    public boolean markedForDMD() {
        return this.sentToDmd;
    }

    private void deliverMessage(Message message) throws ResourceException {
        block2: {
            MessageEndpoint endPoint = this.jmsResource.getEndpoint();
            try {
                _logger.log(Level.FINEST, "Now it is feeding the message to MDB instance");
                ((MessageListener)endPoint).onMessage(message);
            }
            catch (Exception e) {
                if (!this.transacted) break block2;
                throw ExceptionUtils.newResourceException(e);
            }
        }
    }
}

