/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbqlc;

import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.lang.reflect.Method;
import java.util.ResourceBundle;

public class ParameterSupport {
    private Class[] parameterTypes;
    private String[] parameterEjbNames;
    protected static final ResourceBundle msgs = I18NHelper.loadBundle(ParameterSupport.class);

    public ParameterSupport(Method method) {
        this.parameterTypes = method == null ? new Class[]{} : method.getParameterTypes();
        this.parameterEjbNames = new String[this.parameterTypes.length];
    }

    public Class getParameterType(String ejbqlParamDecl) {
        return this.getParameterType(this.getParamNumber(ejbqlParamDecl));
    }

    public Class getParameterType(int paramNumber) {
        return this.parameterTypes[paramNumber - 1];
    }

    public String getParameterEjbName(String ejbqlParamDecl) {
        return this.getParameterEjbName(this.getParamNumber(ejbqlParamDecl));
    }

    public String getParameterEjbName(int paramNumber) {
        return this.parameterEjbNames[paramNumber - 1];
    }

    public void setParameterEjbName(String ejbqlParamDecl, String ejbName) {
        this.parameterEjbNames[this.getParamNumber((String)ejbqlParamDecl) - 1] = ejbName;
    }

    public String[] getParameterEjbNames() {
        return this.parameterEjbNames;
    }

    public String getParameterName(String ejbqlParamDecl) {
        return this.getParameterName(this.getParamNumber(ejbqlParamDecl));
    }

    public String getParameterName(int paramNumber) {
        return "_jdoParam" + String.valueOf(paramNumber);
    }

    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    private int getParamNumber(String ejbqlParamDecl) {
        int paramNum = 0;
        try {
            paramNum = Integer.parseInt(ejbqlParamDecl.substring(1));
        }
        catch (Exception ex) {
            ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidParameterIndex", ejbqlParamDecl, String.valueOf(this.parameterTypes.length)));
        }
        if (paramNum < 1 || paramNum > this.parameterTypes.length) {
            ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidParameterIndex", ejbqlParamDecl, String.valueOf(this.parameterTypes.length)));
        }
        return paramNum;
    }
}

