/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbqlc;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.ejb.model.util.NameMapper;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;

public class TypeSupport {
    public static final Object errorType = "error";
    public static final Object booleanType = "boolean";
    public static final Object byteType = "byte";
    public static final Object shortType = "short";
    public static final Object charType = "char";
    public static final Object intType = "int";
    public static final Object longType = "long";
    public static final Object floatType = "float";
    public static final Object doubleType = "double";
    public static final Object booleanClassType = "java.lang.Boolean";
    public static final Object byteClassType = "java.lang.Byte";
    public static final Object shortClassType = "java.lang.Short";
    public static final Object characterClassType = "java.lang.Character";
    public static final Object integerClassType = "java.lang.Integer";
    public static final Object longClassType = "java.lang.Long";
    public static final Object floatClassType = "java.lang.Float";
    public static final Object doubleClassType = "java.lang.Double";
    public static final Object stringType = "java.lang.String";
    public static final Object bigDecimalType = "java.math.BigDecimal";
    public static final Object bigIntegerType = "java.math.BigInteger";
    protected static Set numericTypes = new HashSet();
    protected static Set numericWrapperTypes = new HashSet();
    protected static Set dateTimeTypes = new HashSet();
    protected Model model;
    protected NameMapper nameMapper;
    protected static final ResourceBundle msgs = I18NHelper.loadBundle(TypeSupport.class);

    public TypeSupport(Model model, NameMapper nameMapper) {
        this.model = model;
        this.nameMapper = nameMapper;
    }

    public Object getTypeInfo(String name) {
        return name;
    }

    public Object getTypeInfo(Class clazz) {
        return this.getTypeInfo(clazz.getName());
    }

    public static boolean isErrorType(Object type) {
        return type.equals(errorType);
    }

    public static boolean isBooleanType(Object type) {
        return type.equals(booleanType) || type.equals(booleanClassType);
    }

    public static boolean isCharType(Object type) {
        return type.equals(charType) || type.equals(characterClassType);
    }

    public static boolean isIntType(Object type) {
        return type.equals(intType) || type.equals(integerClassType);
    }

    public static boolean isDoubleType(Object type) {
        return type.equals(doubleType) || type.equals(doubleClassType);
    }

    public static boolean isNumericType(Object type) {
        return numericTypes.contains(type);
    }

    public static boolean isNumericWrapperType(Object type) {
        return numericWrapperTypes.contains(type);
    }

    public static boolean isNumberType(Object type) {
        return TypeSupport.isNumericType(type) || TypeSupport.isNumericWrapperType(type) || bigDecimalType.equals(type) || bigIntegerType.equals(type);
    }

    public static boolean isFloatingPointType(Object type) {
        return doubleType.equals(type) || doubleClassType.equals(type) || floatType.equals(type) || floatClassType.equals(type);
    }

    public static boolean isStringType(Object type) {
        return type.equals(stringType);
    }

    public boolean isCollectionType(Object type) {
        return this.model.isCollection((String)type);
    }

    public boolean isDateTimeType(Object type) {
        return dateTimeTypes.contains(TypeSupport.getTypeName(type));
    }

    public boolean isOrderableType(Object type) {
        return TypeSupport.isNumberType(type) || this.isDateTimeType(type) || TypeSupport.isStringType(type);
    }

    public static Object getPrimitiveType(Object type) {
        Object result = errorType;
        if (type.equals(booleanClassType)) {
            result = booleanType;
        } else if (type.equals(integerClassType)) {
            result = intType;
        } else if (type.equals(longClassType)) {
            result = longType;
        } else if (type.equals(floatClassType)) {
            result = floatType;
        } else if (type.equals(doubleClassType)) {
            result = doubleType;
        } else if (type.equals(byteClassType)) {
            result = byteType;
        } else if (type.equals(shortClassType)) {
            result = shortType;
        } else if (type.equals(characterClassType)) {
            result = charType;
        }
        return result;
    }

    public static Object getWrapperType(Object type) {
        Object result = errorType;
        if (type.equals(booleanType)) {
            result = booleanClassType;
        } else if (type.equals(intType)) {
            result = integerClassType;
        } else if (type.equals(longType)) {
            result = longClassType;
        } else if (type.equals(floatType)) {
            result = floatClassType;
        } else if (type.equals(doubleType)) {
            result = doubleClassType;
        } else if (type.equals(byteType)) {
            result = byteClassType;
        } else if (type.equals(shortType)) {
            result = shortClassType;
        } else if (type.equals(charType)) {
            result = characterClassType;
        }
        return result;
    }

    public static Object binaryNumericPromotion(Object left, Object right) {
        if (TypeSupport.isNumericType(left) && TypeSupport.isNumericType(right)) {
            if (left.equals(doubleType) || right.equals(doubleType)) {
                return doubleType;
            }
            if (left.equals(floatType) || right.equals(floatType)) {
                return floatType;
            }
            if (left.equals(longType) || right.equals(longType)) {
                return longType;
            }
            return intType;
        }
        return errorType;
    }

    public static Object unaryNumericPromotion(Object type) {
        if (TypeSupport.isNumericType(type)) {
            if (type.equals(byteType) || type.equals(shortType) || type.equals(charType)) {
                return intType;
            }
            return type;
        }
        return errorType;
    }

    public boolean isCompatibleWith(Object left, Object right) {
        String leftTypeName = TypeSupport.getTypeName(left);
        String rightTypeName = TypeSupport.getTypeName(right);
        if (this.nameMapper.isLocalInterface(leftTypeName) && this.nameMapper.isEjbName(rightTypeName)) {
            rightTypeName = this.nameMapper.getLocalInterfaceForEjbName(rightTypeName);
        } else if (this.nameMapper.isRemoteInterface(leftTypeName) && this.nameMapper.isEjbName(rightTypeName)) {
            rightTypeName = this.nameMapper.getRemoteInterfaceForEjbName(rightTypeName);
        } else if (this.nameMapper.isLocalInterface(rightTypeName) && this.nameMapper.isEjbName(leftTypeName)) {
            leftTypeName = this.nameMapper.getLocalInterfaceForEjbName(leftTypeName);
        } else if (this.nameMapper.isRemoteInterface(rightTypeName) && this.nameMapper.isEjbName(leftTypeName)) {
            leftTypeName = this.nameMapper.getRemoteInterfaceForEjbName(leftTypeName);
        }
        return leftTypeName.equals(rightTypeName);
    }

    public static String getTypeName(Object type) {
        return (String)type;
    }

    public Object getTypeInfoForAbstractSchema(String abstractSchema) {
        return this.nameMapper.getEjbNameForAbstractSchema(abstractSchema);
    }

    public String getAbstractSchemaForTypeInfo(Object typeInfo) {
        String typeName = TypeSupport.getTypeName(typeInfo);
        return this.nameMapper.isEjbName(typeName) ? this.nameMapper.getAbstractSchemaForEjbName(typeName) : typeName;
    }

    public Object getFieldType(Object typeInfo, String fieldName) {
        String fieldType;
        String typeName = TypeSupport.getTypeName(typeInfo);
        if (!this.nameMapper.isEjbName(typeName)) {
            ErrorMsg.fatal(I18NHelper.getMessage(msgs, "ERR_EjbNameExpected", "TypeSupport.getFieldType", typeName));
        }
        if (this.nameMapper.isLocalInterface(fieldType = this.model.getFieldType(typeName, fieldName))) {
            fieldType = this.nameMapper.getEjbNameForLocalInterface(typeName, fieldName, fieldType);
        } else if (this.nameMapper.isRemoteInterface(fieldType)) {
            fieldType = this.nameMapper.getEjbNameForRemoteInterface(typeName, fieldName, fieldType);
        }
        return this.getTypeInfo(fieldType);
    }

    public Object getFieldInfo(Object typeInfo, String fieldName) {
        PersistenceFieldElement fieldInfo = null;
        String typeName = TypeSupport.getTypeName(typeInfo);
        if (!this.nameMapper.isEjbName(typeName)) {
            ErrorMsg.fatal(I18NHelper.getMessage(msgs, "ERR__EjbNameExpected", "TypeSupport.getFieldInfo", typeName));
        }
        String pcClassName = this.nameMapper.getPersistenceClassForEjbName(typeName);
        String pcFieldName = this.nameMapper.getPersistenceFieldForEjbField(typeName, fieldName);
        PersistenceClassElement pce = this.model.getPersistenceClass(pcClassName);
        if (pce != null) {
            fieldInfo = pce.getField(pcFieldName);
        }
        return fieldInfo;
    }

    public boolean isRelationship(Object fieldInfo) {
        return fieldInfo != null && fieldInfo instanceof RelationshipElement;
    }

    public Object getElementType(Object fieldInfo) {
        if (fieldInfo != null && fieldInfo instanceof RelationshipElement) {
            String elementClass = ((RelationshipElement)fieldInfo).getElementClass();
            return this.nameMapper.getEjbNameForPersistenceClass(elementClass);
        }
        return null;
    }

    public String getPCForTypeInfo(Object typeInfo) {
        String typeName = TypeSupport.getTypeName(typeInfo);
        String pcClassName = this.nameMapper.getPersistenceClassForEjbName(typeName);
        return pcClassName != null ? pcClassName : typeName;
    }

    public boolean isEjbName(Object typeInfo) {
        return this.nameMapper.isEjbName(TypeSupport.getTypeName(typeInfo));
    }

    public boolean isEjbOrInterfaceName(Object typeInfo) {
        String typeName = TypeSupport.getTypeName(typeInfo);
        return this.nameMapper.isEjbName(typeName) || this.nameMapper.isLocalInterface(typeName) || this.nameMapper.isRemoteInterface(typeName);
    }

    public boolean isRemoteInterfaceOfEjb(Object typeInfo, String ejbName) {
        String typeName = TypeSupport.getTypeName(typeInfo);
        String remoteInterface = this.nameMapper.getRemoteInterfaceForEjbName(ejbName);
        return remoteInterface != null && remoteInterface.equals(typeName);
    }

    public boolean isLocalInterfaceOfEjb(Object typeInfo, String ejbName) {
        String typeName = TypeSupport.getTypeName(typeInfo);
        String localInterface = this.nameMapper.getLocalInterfaceForEjbName(ejbName);
        return localInterface != null && localInterface.equals(typeName);
    }

    public boolean isRemoteInterface(Object typeInfo) {
        return this.nameMapper.isRemoteInterface(TypeSupport.getTypeName(typeInfo));
    }

    public boolean isLocalInterface(Object typeInfo) {
        return this.nameMapper.isLocalInterface(TypeSupport.getTypeName(typeInfo));
    }

    public boolean hasRemoteInterface(Object typeInfo) {
        return this.nameMapper.getRemoteInterfaceForEjbName(TypeSupport.getTypeName(typeInfo)) != null;
    }

    public boolean hasLocalInterface(Object typeInfo) {
        return this.nameMapper.getLocalInterfaceForEjbName(TypeSupport.getTypeName(typeInfo)) != null;
    }

    public Object getSumReturnType(Object type) {
        if (TypeSupport.isFloatingPointType(type)) {
            return doubleClassType;
        }
        if (TypeSupport.isNumericType(type) || TypeSupport.isNumericWrapperType(type)) {
            return longClassType;
        }
        return type;
    }

    public Object getAvgReturnType(Object type) {
        if (TypeSupport.isNumericType(type) || TypeSupport.isNumericWrapperType(type)) {
            return doubleClassType;
        }
        return type;
    }

    public Object getMinMaxReturnType(Object type) {
        if (TypeSupport.isFloatingPointType(type)) {
            return doubleClassType;
        }
        if (TypeSupport.isCharType(type)) {
            return characterClassType;
        }
        if (TypeSupport.isNumericType(type) || TypeSupport.isNumericWrapperType(type)) {
            return longClassType;
        }
        return type;
    }

    static {
        numericTypes.add(byteType);
        numericTypes.add(shortType);
        numericTypes.add(charType);
        numericTypes.add(intType);
        numericTypes.add(longType);
        numericTypes.add(floatType);
        numericTypes.add(doubleType);
        numericWrapperTypes.add(byteClassType);
        numericWrapperTypes.add(shortClassType);
        numericWrapperTypes.add(characterClassType);
        numericWrapperTypes.add(integerClassType);
        numericWrapperTypes.add(longClassType);
        numericWrapperTypes.add(floatClassType);
        numericWrapperTypes.add(doubleClassType);
        dateTimeTypes.add("java.util.Date");
        dateTimeTypes.add("java.sql.Date");
        dateTimeTypes.add("java.sql.Time");
        dateTimeTypes.add("java.sql.Timestamp");
    }
}

