/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.UpdateObjectDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.UpdateJoinTableDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.Concurrency;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class UpdateObjectDescImpl
implements UpdateObjectDesc {
    private List afterHiddenValues;
    private SQLStateManager afterImage;
    private List beforeHiddenValues;
    private SQLStateManager beforeImage;
    private Concurrency concurrency;
    private Class pcClass;
    private int updateAction;
    private List updatedFields;
    private Map updatedJoinTableRelationships;
    private boolean relationshipChanged = false;
    private static Logger logger = LogHelperSQLStore.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", UpdateObjectDescImpl.class.getClassLoader());

    public UpdateObjectDescImpl(Class pcClass) {
        this.pcClass = pcClass;
        this.updatedFields = new ArrayList();
    }

    public Class getPersistenceCapableClass() {
        return this.pcClass;
    }

    public void reset() {
        this.updatedFields.clear();
        if (this.updatedJoinTableRelationships != null) {
            this.updatedJoinTableRelationships.clear();
        }
        this.relationshipChanged = false;
        this.concurrency = null;
    }

    public boolean hasUpdatedFields() {
        return this.updatedFields.size() > 0;
    }

    public Collection getUpdatedJoinTableFields() {
        if (this.updatedJoinTableRelationships == null) {
            return null;
        }
        return this.updatedJoinTableRelationships.keySet();
    }

    public Collection getUpdateJoinTableDescs(FieldDesc fieldDesc) {
        HashMap updateJoinTableDescs = (HashMap)this.updatedJoinTableRelationships.get(fieldDesc);
        if (updateJoinTableDescs != null) {
            return updateJoinTableDescs.values();
        }
        return null;
    }

    public boolean hasUpdatedJoinTableRelationships() {
        return this.updatedJoinTableRelationships != null && this.updatedJoinTableRelationships.size() > 0;
    }

    public boolean hasModifiedLobField() {
        if (this.updatedFields != null) {
            for (LocalFieldDesc field : this.updatedFields) {
                if (!field.isMappedToLob()) continue;
                return true;
            }
        }
        return false;
    }

    public void markRelationshipChange(FieldDesc fieldDesc) {
        if (fieldDesc.isRelationshipField() || fieldDesc.absoluteID < 0) {
            if (logger.isLoggable(300)) {
                logger.finest("sqlstore.sql.updateobjdescimpl.markrelationshipchange");
            }
            this.relationshipChanged = true;
        }
    }

    public boolean hasChangedRelationships() {
        if (this.relationshipChanged) {
            return true;
        }
        if (this.hasUpdatedJoinTableRelationships()) {
            return true;
        }
        if (this.updatedFields != null) {
            for (LocalFieldDesc field : this.updatedFields) {
                if (field.absoluteID >= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean removeUpdatedJoinTableRelationship(ForeignFieldDesc fieldDesc, SQLStateManager foreignSM, int action) {
        HashMap updateJoinTableDescs = null;
        if (this.updatedJoinTableRelationships == null || (updateJoinTableDescs = (HashMap)this.updatedJoinTableRelationships.get(fieldDesc)) == null) {
            return false;
        }
        UpdateJoinTableDesc desc = (UpdateJoinTableDesc)updateJoinTableDescs.get(foreignSM);
        if (desc != null && desc.getAction() == action) {
            return updateJoinTableDescs.remove(foreignSM) != null;
        }
        return false;
    }

    public void recordUpdatedJoinTableRelationship(ForeignFieldDesc fieldDesc, SQLStateManager parentSM, SQLStateManager foreignSM, int action) {
        if (this.updatedJoinTableRelationships == null) {
            this.updatedJoinTableRelationships = new HashMap();
        }
        HashMap<SQLStateManager, UpdateJoinTableDesc> updateJoinTableDescs = null;
        updateJoinTableDescs = (HashMap<SQLStateManager, UpdateJoinTableDesc>)this.updatedJoinTableRelationships.get(fieldDesc);
        if (updateJoinTableDescs == null) {
            updateJoinTableDescs = new HashMap<SQLStateManager, UpdateJoinTableDesc>();
            this.updatedJoinTableRelationships.put(fieldDesc, updateJoinTableDescs);
        }
        UpdateJoinTableDesc desc = null;
        desc = (UpdateJoinTableDesc)updateJoinTableDescs.get(foreignSM);
        if (desc == null) {
            desc = new UpdateJoinTableDesc(parentSM, foreignSM, action);
            updateJoinTableDescs.put(foreignSM, desc);
        }
    }

    public void clearUpdatedJoinTableRelationships() {
        this.updatedJoinTableRelationships = null;
    }

    public void recordUpdatedField(LocalFieldDesc fieldDesc) {
        if (!this.updatedFields.contains(fieldDesc)) {
            this.updatedFields.add(fieldDesc);
        }
    }

    public List getUpdatedFields() {
        return this.updatedFields;
    }

    public Object getAfterValue(FieldDesc f) {
        if (this.afterImage == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "sqlstore.sql.updateobjdescimpl.afterimagenull"));
        }
        if (f.absoluteID < 0) {
            return this.afterHiddenValues.get(-(f.absoluteID + 1));
        }
        return f.getValue(this.afterImage);
    }

    public Object getBeforeValue(FieldDesc f) {
        if (this.beforeImage == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "sqlstore.sql.updateobjdescimpl.beforeimagenull"));
        }
        if (f.absoluteID < 0) {
            return this.beforeHiddenValues.get(-(f.absoluteID + 1));
        }
        return f.getValue(this.beforeImage);
    }

    public int getUpdateAction() {
        return this.updateAction;
    }

    public ClassDesc getConfig() {
        return (ClassDesc)this.afterImage.getPersistenceConfig();
    }

    public SQLStateManager getAfterImage() {
        return this.afterImage;
    }

    public boolean isBeforeImageRequired() {
        return this.afterImage.isBeforeImageRequired();
    }

    public Concurrency getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(Concurrency concurrency) {
        this.concurrency = concurrency;
    }

    public void setObjectInfo(StateManager biStateManager, StateManager aiStateManager, int action) {
        this.beforeImage = (SQLStateManager)biStateManager;
        this.afterImage = (SQLStateManager)aiStateManager;
        ClassDesc config = (ClassDesc)this.afterImage.getPersistenceConfig();
        this.updateAction = action;
        this.afterHiddenValues = this.afterImage.hiddenValues;
        if (this.beforeImage != null) {
            this.beforeHiddenValues = this.beforeImage.hiddenValues;
        }
        boolean debug = logger.isLoggable(400);
        for (int i = 0; i < config.fields.size(); ++i) {
            FieldDesc f = (FieldDesc)config.fields.get(i);
            LocalFieldDesc lf = null;
            boolean updated = false;
            if (!(f instanceof LocalFieldDesc)) continue;
            lf = (LocalFieldDesc)f;
            if (this.updateAction == 2 || (lf.sqlProperties & 8) > 0) continue;
            if (lf.absoluteID < 0) {
                if (this.beforeImage == null || this.beforeImage.getHiddenValue(lf.absoluteID) != this.afterImage.getHiddenValue(lf.absoluteID)) {
                    updated = true;
                }
            } else if (lf.getType().isPrimitive() || String.class == lf.getType() || Date.class == lf.getType()) {
                Object afterVal = lf.getValue(this.afterImage);
                Object beforeVal = null;
                if (this.beforeImage != null) {
                    beforeVal = lf.getValue(this.beforeImage);
                }
                if (beforeVal != null && afterVal != null) {
                    if (!beforeVal.equals(afterVal)) {
                        updated = true;
                    }
                } else {
                    updated = true;
                }
            }
            if (!updated) continue;
            if (debug) {
                logger.finer("sqlstore.sql.updateobjdescimpl.updated", f.getName());
            }
            this.updatedFields.add(lf);
        }
        if (this.concurrency != null) {
            this.concurrency.commit(this, this.beforeImage, this.afterImage, this.updateAction);
        }
    }

    public void incrementVersion() {
        if (this.afterImage.hasVersionConsistency() && this.updateAction == 3 && this.hasUpdatedFields()) {
            this.afterImage.incrementVersion();
        }
    }

    public void setVerificationFailed() {
        this.afterImage.setVerificationFailed();
    }

    public boolean hasVersionConsistency() {
        return this.afterImage.hasVersionConsistency();
    }
}

