/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.faces;

import com.sun.data.provider.RowKey;
import com.sun.data.provider.SortCriteria;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.TableRowDataProvider;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class ValueBindingSortCriteria
extends SortCriteria {
    private transient ValueBinding valueBinding;
    private String requestMapKey = "currentRow";
    private transient TableRowDataProvider rowProvider;
    private String rowProviderLock = "rowProviderLock";

    public ValueBindingSortCriteria() {
    }

    public ValueBindingSortCriteria(ValueBinding valueBinding) {
        this.valueBinding = valueBinding;
    }

    public ValueBindingSortCriteria(ValueBinding valueBinding, boolean ascending) {
        this.valueBinding = valueBinding;
        this.setAscending(ascending);
    }

    public ValueBinding getValueBinding() {
        return this.valueBinding;
    }

    public void setValueBinding(ValueBinding valueBinding) {
        this.valueBinding = valueBinding;
    }

    public String getRequestMapKey() {
        return this.requestMapKey;
    }

    public void setRequestMapKey(String requestMapKey) {
        this.requestMapKey = requestMapKey;
    }

    public String getDisplayName() {
        String name = super.getDisplayName();
        if ((name == null || "".equals(name)) && this.valueBinding != null) {
            return this.valueBinding.getExpressionString();
        }
        return name;
    }

    public String getCriteriaKey() {
        return this.valueBinding != null ? this.valueBinding.getExpressionString() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSortValue(TableDataProvider provider, RowKey row) {
        if (this.valueBinding == null) {
            return null;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Object value = null;
        String string = this.rowProviderLock;
        synchronized (string) {
            Object storedRequestMapValue = null;
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                storedRequestMapValue = requestMap.get(this.requestMapKey);
                if (this.rowProvider == null) {
                    this.rowProvider = new TableRowDataProvider();
                }
                this.rowProvider.setTableDataProvider(provider);
                this.rowProvider.setTableRow(row);
                requestMap.put(this.requestMapKey, this.rowProvider);
            }
            value = this.valueBinding.getValue(facesContext);
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                if (this.rowProvider != null) {
                    this.rowProvider.setTableDataProvider(null);
                    this.rowProvider.setTableRow(null);
                }
                requestMap.put(this.requestMapKey, storedRequestMapValue);
            }
        }
        return value;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.requestMapKey);
        out.writeObject(this.rowProviderLock);
        if (this.valueBinding != null) {
            out.writeObject(this.valueBinding.getExpressionString());
        } else {
            out.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.requestMapKey = (String)in.readObject();
        this.rowProviderLock = (String)in.readObject();
        String s = (String)in.readObject();
        if (s != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            this.valueBinding = facesContext.getApplication().createValueBinding(s);
        } else {
            this.valueBinding = null;
        }
    }
}

