/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Alert;
import com.sun.web.ui.renderer.AbstractRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class AlertRenderer
extends AbstractRenderer {
    public static final String ALERT_TYPE_ERROR = "error";
    public static final String ALERT_TYPE_WARN = "warning";
    public static final String ALERT_TYPE_INFO = "information";
    public static final String ALERT_TYPE_SUCCESS = "success";
    public static final String ALERT_TYPE_DEFAULT = "error";
    private static final String ICON_HYPERLINK_FACTORY = "com.sun.web.ui.component.util.factories.IconHyperlinkFactory";

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected void renderOuterDiv(FacesContext context, Alert alert, ResponseWriter writer) throws IOException {
        String styleClass = alert.getStyleClass();
        String style = alert.getStyle();
        String id = alert.getClientId(context);
        writer.startElement("div", (UIComponent)alert);
        if (id != null) {
            writer.writeAttribute("id", (Object)id, null);
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)alert, styleClass);
    }

    protected void renderOpeningTable(FacesContext context, Alert alert, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement("table", (UIComponent)alert);
        writer.writeAttribute("align", (Object)"center", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("title", (Object)"", null);
        String tableStyle = theme.getStyleClass("ALERT_TABLE");
        writer.writeAttribute("class", (Object)tableStyle, null);
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)alert);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)alert);
        writer.writeAttribute("valign", (Object)"middle", null);
        writer.writeText((Object)"\n", null);
    }

    protected void renderAlertIcon(FacesContext context, Alert alert, String type, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent alertIcon = alert.getAlertIcon();
        RenderingUtilities.renderComponent(alertIcon, context);
    }

    protected void renderAlertSummaryText(Alert alert, ResponseWriter writer) throws IOException {
        String summary = alert.getSummary();
        writer.writeText((Object)summary, null);
    }

    protected void renderAlertSummaryText(Alert alert, ResponseWriter writer, FacesContext context) throws IOException {
        String summary = alert.getSummary();
        if (summary != null) {
            this.renderFormattedMessage(writer, (UIComponent)alert, context, summary);
        }
    }

    protected void renderAlertDetailArea(FacesContext context, Alert alert, Theme theme, ResponseWriter writer) throws IOException {
        String detail = alert.getDetail();
        List children = alert.getChildren();
        if ((detail == null || detail.trim().length() == 0) && children.size() <= 0) {
            return;
        }
        writer.startElement("div", (UIComponent)alert);
        writer.writeAttribute("class", (Object)theme.getStyleClass("ALERT_MESSAGE_TEXT"), null);
        if (detail != null) {
            this.renderFormattedMessage(writer, (UIComponent)alert, context, detail);
        }
        super.encodeChildren(context, (UIComponent)alert);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    protected void renderAlertLink(FacesContext context, Alert alert, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent link = alert.getAlertLink();
        if (link != null) {
            writer.startElement("div", (UIComponent)alert);
            writer.writeAttribute("class", (Object)theme.getStyleClass("ALERT_LINK_DIV"), null);
            RenderingUtilities.renderComponent(link, context);
            writer.endElement("div");
        }
    }

    protected void renderClosingTags(ResponseWriter writer) throws IOException {
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Alert alert = (Alert)component;
        String summary = alert.getSummary();
        if (summary == null || summary.trim().length() == 0) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        if (!RenderingUtilities.isPortlet(context)) {
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            String viewId = context.getViewRoot().getViewId();
            String urlString = context.getApplication().getViewHandler().getActionURL(context, viewId);
            Cookie cookie = new Cookie(viewId, "");
            cookie.setPath(urlString);
            response.addCookie(cookie);
        }
        this.renderOuterDiv(context, alert, writer);
        this.renderOpeningTable(context, alert, theme, writer);
        String type = alert.getType();
        if (type == null) {
            type = "error";
        }
        type = type.toLowerCase();
        String textStyle = this.getAlertTextStyle(type, theme);
        writer.startElement("div", (UIComponent)alert);
        writer.writeAttribute("class", (Object)textStyle, null);
        this.renderAlertIcon(context, alert, type, theme, writer);
        this.renderAlertSummaryText(alert, writer, context);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
        this.renderAlertDetailArea(context, alert, theme, writer);
        this.renderAlertLink(context, alert, theme, writer);
        this.renderClosingTags(writer);
    }

    private String getAlertTextStyle(String type, Theme theme) {
        String style = type.equals(ALERT_TYPE_INFO) ? theme.getStyleClass("ALERT_INFORMATION_TEXT") : (type.equals(ALERT_TYPE_SUCCESS) ? theme.getStyleClass("ALERT_INFORMATION_TEXT") : (type.equals(ALERT_TYPE_WARN) ? theme.getStyleClass("ALERT_WARNING_TEXT") : theme.getStyleClass("ALERT_ERROR_TEXT")));
        return style;
    }

    private void renderFormattedMessage(ResponseWriter writer, UIComponent component, FacesContext context, String msg) throws IOException {
        ArrayList<Object> parameterList = new ArrayList<Object>();
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof UIParameter)) continue;
            parameterList.add(((UIParameter)kid).getValue());
        }
        String message = null;
        message = parameterList.size() > 0 ? MessageFormat.format(msg, parameterList.toArray(new Object[parameterList.size()])) : msg;
        if (message != null) {
            writer.write(message);
        }
    }
}

