/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Field;
import com.sun.web.ui.component.HiddenField;
import com.sun.web.ui.util.ConversionUtilities;
import com.sun.web.ui.util.MessageUtil;
import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class HiddenFieldRenderer
extends Renderer {
    private static final boolean DEBUG = false;

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof HiddenField)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), HiddenField.class.getName()};
            String message = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        HiddenField field = (HiddenField)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", (UIComponent)field);
        writer.writeAttribute("type", (Object)"hidden", null);
        String id = field.getClientId(context);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        if (((HiddenField)component).getSubmittedValue() == null) {
            ConversionUtilities.setRenderedValue(component, ((HiddenField)component).getValue());
        }
        String value = field.getValueAsString(context);
        writer.writeAttribute("value", (Object)value, "value");
        if (field.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
    }

    public void decode(FacesContext context, UIComponent component) {
        HiddenFieldRenderer.decodeInput(context, component);
    }

    static void decodeInput(FacesContext context, UIComponent component) {
        String id = component.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        Object valueObject = params.get(id);
        String value = null;
        if (valueObject == null && component instanceof Field) {
            Field cfr_ignored_0 = (Field)component;
            id = id.concat("_field");
            valueObject = params.get(id);
        }
        if (valueObject != null) {
            value = (String)valueObject;
            if (component instanceof Field && ((Field)component).isTrim()) {
                value = value.toString().trim();
            }
        }
        ((EditableValueHolder)component).setSubmittedValue((Object)value);
    }

    protected static void log(String s) {
        System.out.println(s);
    }
}

