/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.DropDown;
import com.sun.web.ui.component.Icon;
import com.sun.web.ui.component.Scheduler;
import com.sun.web.ui.component.Time;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.MessageUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.MissingResourceException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class SchedulerRenderer
extends Renderer {
    private static final String SPACE = "&nbsp;";
    private static final boolean DEBUG = false;

    public void encodeBegin(FacesContext context, UIComponent component) {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof Scheduler)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Scheduler.class.getName()};
            String message = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        Scheduler scheduler = (Scheduler)component;
        Theme theme = ThemeUtilities.getTheme(context);
        ResponseWriter writer = context.getResponseWriter();
        String spacerPath = theme.getIcon("DOT").getUrl();
        this.includeJsFile(writer, scheduler, theme.getPathToJSFile("scheduler"));
        this.renderEnclosingDiv(scheduler, theme, context, writer);
        writer.writeText((Object)"\n", null);
        this.renderOpenTable((UIComponent)scheduler, writer);
        writer.writeText((Object)"\n", null);
        this.renderLegendRow(scheduler, theme, writer, context);
        writer.writeText((Object)"\n", null);
        this.renderSpacerRow((UIComponent)scheduler, spacerPath, 5, 1, 2, writer);
        writer.writeText((Object)"\n", null);
        this.renderControlRow(scheduler, theme, spacerPath, writer, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
        writer.endElement("div");
        writer.write(this.getJavaScriptInitializer(scheduler, context, theme));
    }

    private void includeJsFile(ResponseWriter writer, Scheduler scheduler, String src) throws IOException {
        writer.startElement("script", (UIComponent)scheduler);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)src, null);
        writer.endElement("script");
    }

    private void renderEnclosingDiv(Scheduler scheduler, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("div", (UIComponent)scheduler);
        writer.writeAttribute("id", (Object)scheduler.getClientId(context), null);
        String style = scheduler.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        style = scheduler.getStyleClass();
        if (scheduler.isVisible()) {
            if (style != null) {
                writer.writeAttribute("class", (Object)style, "styleClass");
            }
        } else {
            style = style + " " + theme.getStyleClass("HIDDEN");
            writer.writeAttribute("class", (Object)style, "styleClass");
        }
    }

    private void renderOpenTable(UIComponent comp, ResponseWriter writer) throws IOException {
        writer.startElement("table", comp);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("title", (Object)"", null);
    }

    private void renderLegendRow(Scheduler scheduler, Theme theme, ResponseWriter writer, FacesContext context) throws IOException {
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        if (scheduler.isRequiredLegend()) {
            writer.writeText((Object)"\n", null);
            writer.startElement("div", (UIComponent)scheduler);
            writer.writeAttribute("align", (Object)"right", null);
            writer.writeAttribute("class", (Object)theme.getStyleClass("LABEL_REQUIRED_DIV"), null);
            writer.writeText((Object)"\n", null);
            Icon icon = theme.getIcon("LABEL_REQUIRED_ICON");
            icon.setId(scheduler.getId().concat("_icon"));
            icon.setParent((UIComponent)scheduler);
            RenderingUtilities.renderComponent((UIComponent)icon, context);
            writer.writeText((Object)"\n", null);
            writer.write(SPACE);
            writer.writeText((Object)theme.getMessage("Scheduler.requiredLegend"), null);
            writer.writeText((Object)"\n", null);
            writer.endElement("div");
        } else {
            writer.write(SPACE);
        }
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderSpacerRow(UIComponent component, String path, int height, int width, int colspan, ResponseWriter writer) throws IOException {
        writer.startElement("tr", component);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", component);
        writer.writeAttribute("colspan", (Object)String.valueOf(colspan), null);
        writer.writeText((Object)"\n", null);
        this.renderSpacerImage(component, path, height, width, writer);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderSpacerImage(UIComponent component, String path, int height, int width, ResponseWriter writer) throws IOException {
        writer.startElement("img", component);
        writer.writeAttribute("src", (Object)path, null);
        writer.writeAttribute("height", (Object)String.valueOf(height), null);
        writer.writeAttribute("width", (Object)String.valueOf(width), null);
        writer.writeAttribute("alt", (Object)"", null);
        writer.endElement("img");
    }

    private void renderControlRow(Scheduler scheduler, Theme theme, String spacerPath, ResponseWriter writer, FacesContext context) throws IOException {
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent((UIComponent)scheduler.getDatePicker(), context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        this.renderInputControls(context, scheduler, writer, theme, spacerPath);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderInputControls(FacesContext context, Scheduler scheduler, ResponseWriter writer, Theme theme, String spacerPath) throws IOException {
        UIComponent label;
        this.renderOpenTable((UIComponent)scheduler, writer);
        writer.writeText((Object)"\n", null);
        this.renderStartDateRow(scheduler, spacerPath, theme, context, writer);
        writer.writeText((Object)"\n", null);
        this.renderHelpTextRow(scheduler, theme, writer);
        writer.writeText((Object)"\n", null);
        if (scheduler.isStartTime()) {
            label = scheduler.getStartTimeLabelComponent(theme);
            this.renderTimeRow(scheduler, label, scheduler.getStartTimeComponent(), theme, spacerPath, context, writer);
            writer.writeText((Object)"\n", null);
        }
        if (scheduler.isEndTime()) {
            label = scheduler.getEndTimeLabelComponent(theme);
            this.renderTimeRow(scheduler, label, scheduler.getEndTimeComponent(), theme, spacerPath, context, writer);
            writer.writeText((Object)"\n", null);
        }
        if (scheduler.isRepeating()) {
            this.renderSpacerRow((UIComponent)scheduler, spacerPath, 5, 1, 4, writer);
            this.renderRepeatIntervalRow(scheduler, theme, context, writer);
            if (scheduler.isLimitRepeating()) {
                this.renderSpacerRow((UIComponent)scheduler, spacerPath, 5, 1, 4, writer);
                this.renderRepeatLimitRow(context, scheduler, writer, theme, spacerPath);
                this.renderRepeatLegend(scheduler, theme, context, writer);
            }
        }
        if (scheduler.isPreviewButton()) {
            this.renderSpacerRow((UIComponent)scheduler, spacerPath, 20, 1, 4, writer);
            this.renderPreviewRow(context, scheduler, writer, theme);
        }
        writer.writeText((Object)"\n", null);
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
    }

    private void renderTimeRow(Scheduler scheduler, UIComponent label, Time time, Theme theme, String spacerPath, FacesContext context, ResponseWriter writer) throws IOException {
        this.renderSpacerRow((UIComponent)scheduler, spacerPath, 5, 1, 4, writer);
        writer.writeText((Object)"\n", null);
        this.renderInputRowStart(scheduler, writer, theme);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(label, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("span");
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent((UIComponent)time, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
    }

    private void renderStartDateRow(Scheduler scheduler, String spacerPath, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        UIComponent date = scheduler.getDateComponent();
        UIComponent label = scheduler.getDateLabelComponent(theme);
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        this.renderSpacerImage((UIComponent)scheduler, spacerPath, 1, 30, writer);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(label, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        this.renderSpacerImage((UIComponent)scheduler, spacerPath, 1, 10, writer);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(date, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderHelpTextRow(Scheduler scheduler, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("colspan", (Object)"3", null);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)scheduler);
        String styleClass = theme.getStyleClass("HELP_FIELD_TEXT");
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeText((Object)this.getPattern(scheduler, theme), null);
        writer.endElement("div");
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private String getPattern(Scheduler scheduler, Theme theme) {
        String hint = scheduler.getDateFormatPatternHelp();
        if (hint == null) {
            try {
                String pattern = scheduler.getDatePicker().getDateFormatPattern();
                hint = theme.getMessage("calendar.".concat(pattern));
            }
            catch (MissingResourceException mre) {
                hint = ((SimpleDateFormat)scheduler.getDateFormat()).toLocalizedPattern().toLowerCase();
            }
        }
        return hint;
    }

    private void renderPreviewRow(FacesContext context, Scheduler scheduler, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("colspan", (Object)"3", null);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        UIComponent button = scheduler.getPreviewButtonComponent();
        RenderingUtilities.renderComponent(button, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderRepeatIntervalRow(Scheduler scheduler, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        UIComponent label = scheduler.getRepeatIntervalLabelComponent();
        DropDown menu = scheduler.getRepeatIntervalComponent();
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.writeText((Object)"\n", null);
        writer.startElement("span", (UIComponent)scheduler);
        writer.writeAttribute("class", (Object)theme.getStyleClass("DATE_TIME_LABEL_TEXT"), null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(label, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("span");
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent((UIComponent)menu, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderInputRowStart(Scheduler scheduler, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.writeText((Object)"\n", null);
        writer.startElement("span", (UIComponent)scheduler);
        String styleClass = theme.getStyleClass("DATE_TIME_LABEL_TEXT");
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeText((Object)"\n", null);
    }

    private void renderRepeatLimitRow(FacesContext context, Scheduler scheduler, ResponseWriter writer, Theme theme, String spacerPath) throws IOException {
        UIComponent label = scheduler.getRepeatLimitLabelComponent();
        UIComponent field = scheduler.getRepeatingFieldComponent();
        DropDown menu = scheduler.getRepeatUnitComponent();
        this.renderSpacerRow((UIComponent)scheduler, spacerPath, 5, 1, 4, writer);
        writer.writeText((Object)"\n", null);
        this.renderInputRowStart(scheduler, writer, theme);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(label, context);
        writer.endElement("span");
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        RenderingUtilities.renderComponent(field, context);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent((UIComponent)menu, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderRepeatLegend(Scheduler scheduler, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("tr", (UIComponent)scheduler);
        writer.write("\n");
        for (int i = 0; i < 3; ++i) {
            writer.startElement("td", (UIComponent)scheduler);
            writer.write(SPACE);
            writer.endElement("td");
            writer.write("\n");
        }
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.startElement("div", (UIComponent)scheduler);
        writer.writeAttribute("class", (Object)theme.getStyleClass("HELP_FIELD_TEXT"), null);
        writer.writeText((Object)theme.getMessage("Scheduler.blankForWhat"), null);
        writer.write("\n");
        writer.endElement("div");
        writer.endElement("td");
        writer.write("\n");
        writer.endElement("tr");
        writer.write("\n");
    }

    private String getJavaScriptInitializer(Scheduler scheduler, FacesContext context, Theme theme) {
        String jsName = scheduler.getJavaScriptObjectName(context);
        StringBuffer js = new StringBuffer(128);
        js.append("\n<script type=\"text/javascript\">\nvar ");
        js.append(jsName);
        js.append(" = new Scheduler('");
        js.append(scheduler.getDatePicker().getClientId(context));
        js.append("', '");
        js.append(scheduler.getDateComponent().getClientId(context));
        js.append("', '");
        js.append(theme.getStyleClass("DATE_TIME_LINK"));
        js.append("', '");
        js.append(theme.getStyleClass("DATE_TIME_BOLD_LINK"));
        js.append("', '");
        js.append(theme.getStyleClass("DATE_TIME_OTHER_LINK"));
        js.append("', '");
        js.append(theme.getStyleClass("DATE_TIME_OTHER_BOLD_LINK"));
        js.append("', '");
        js.append(theme.getStyleClass("DATE_TIME_TODAY_LINK"));
        js.append("', '");
        js.append(scheduler.getDatePicker().getDateFormatPattern());
        js.append("');</script>\n");
        return js.toString();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void log(String s) {
        System.out.println(((Object)((Object)this)).getClass().getName() + "::" + s);
    }
}

