/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jms.ra.OnMessageRunner;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceForRA
implements XAResource {
    private ConnectionImpl raConnection;
    private ConnectionImpl epConnection;
    private long resourceManagerId = 0L;
    private int transactionTimeout = 0;
    private OnMessageRunner omr;
    private int id;
    private long transactionID = -1L;
    private JMQXid jmqXid = null;
    protected boolean started = false;
    private boolean setRollback = false;
    private Exception rollbackCause = null;

    public XAResourceForRA(OnMessageRunner onMessageRunner, ConnectionImpl connectionImpl, ConnectionImpl connectionImpl2) throws JMSException {
        this.omr = onMessageRunner;
        this.id = onMessageRunner.getId();
        this.raConnection = connectionImpl;
        this.epConnection = connectionImpl2;
        if (connectionImpl == null) {
            System.err.println("MQRA:XARFRA:constr:raConnectionNull:unable to acquire RMId:assuming distinct");
        } else if (connectionImpl._isClosed()) {
            System.err.println("MQRA:XARFRA:constr:raConnectionClosed:unable to acquire RMId:assuming distinct");
        } else {
            try {
                this.resourceManagerId = connectionImpl.getProtocolHandler().generateUID();
            }
            catch (Exception exception) {
                System.err.println("MQRA:XARFRA:constr:Exc acquiring RMId:assuming distinct");
            }
        }
    }

    public synchronized void commit(Xid xid, boolean bl) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        if (bl && this.setRollback) {
            Debug.printStackTrace(this.rollbackCause);
            XAException xAException = new XAException(100);
            xAException.initCause(this.rollbackCause);
            throw xAException;
        }
        try {
            if (this.epConnection._isClosed()) {
                System.err.println("MQRA:XARFRA:commit:ConnectionClosed:throw XAExc txn:1p=" + bl + ":xid=" + jMQXid.toString());
                XAException xAException = new XAException(bl ? 100 : -7);
                throw xAException;
            }
            this.epConnection.getProtocolHandler().commit(0L, bl ? 0x40000000 : 0, jMQXid);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
    }

    public synchronized void end(Xid xid, int n) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        if (this.epConnection._isClosed()) {
            XAException xAException = new XAException(-7);
            throw xAException;
        }
        try {
            this.epConnection.getProtocolHandler().endTransaction(0L, n, jMQXid);
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace((Exception)((Object)jMSException));
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
        this.started = false;
    }

    public synchronized void _endLocal() throws XAException {
        try {
            this.epConnection.getProtocolHandler().commit(this.transactionID, 0, null);
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace((Exception)((Object)jMSException));
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
        this.started = false;
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        return this.getClass().isInstance(xAResource) ? this.isSameJMQRM((XAResourceForRA)xAResource) : false;
    }

    public boolean isSameJMQRM(XAResourceForRA xAResourceForRA) {
        if (this.resourceManagerId != 0L) {
            return this.resourceManagerId == xAResourceForRA.getResourceManagerId();
        }
        return false;
    }

    public synchronized int prepare(Xid xid) throws XAException {
        int n = 0;
        JMQXid jMQXid = new JMQXid(xid);
        if (this.setRollback) {
            Debug.printStackTrace(this.rollbackCause);
            XAException xAException = new XAException(100);
            xAException.initCause(this.rollbackCause);
            throw xAException;
        }
        try {
            if (this.epConnection._isClosed()) {
                XAException xAException = new XAException(100);
                throw xAException;
            }
            this.epConnection.getProtocolHandler().prepare(0L, jMQXid);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray = null;
        try {
            if (this.epConnection._isClosed()) {
                XAException xAException = new XAException(-7);
                throw xAException;
            }
            xidArray = this.epConnection.getProtocolHandler().recover(n);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        return xidArray;
    }

    public synchronized void rollback(Xid xid) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        try {
            if (this.epConnection._isClosed()) {
                XAException xAException = new XAException(-7);
                throw xAException;
            }
            this.epConnection.getProtocolHandler().rollback(0L, jMQXid, true);
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace((Exception)((Object)jMSException));
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    public synchronized void start(Xid xid, int n) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        try {
            if (this.epConnection._isClosed()) {
                XAException xAException = new XAException(-7);
                throw xAException;
            }
            this.transactionID = this.epConnection.getProtocolHandler().startTransaction(this.transactionID, n, jMQXid);
            this.jmqXid = jMQXid;
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace((Exception)((Object)jMSException));
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
        this.started = true;
    }

    public synchronized void _startLocal() throws XAException {
        try {
            this.transactionID = this.epConnection.protocolHandler.startTransaction(-1L, 0, null);
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace((Exception)((Object)jMSException));
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
        this.started = true;
    }

    public int getId() {
        return this.id;
    }

    public synchronized long getTransactionID() {
        return this.transactionID;
    }

    public boolean started() {
        return this.started;
    }

    public long getResourceManagerId() {
        return this.resourceManagerId;
    }

    public void setRollback(boolean bl, Exception exception) {
        this.setRollback = bl;
        this.rollbackCause = exception;
    }
}

