/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.logging;

import com.sun.messaging.jmq.jmsclient.ConnectionMetaDataImpl;
import com.sun.messaging.jmq.jmsclient.resources.ClientResources;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class ULFformatter
extends SimpleFormatter {
    public static final String FR_BEGIN = "[#|";
    public static final String FR_END = "|#]\n";
    public static final String FR_DELIMITER = "|";
    public static final String PRODUCT_NAME = ConnectionMetaDataImpl.JMSProviderName + " " + "4.0";
    public static ClientResources resources = ClientResources.getResources();
    public static final String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS z";
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z", Locale.getDefault());

    public synchronized String format(LogRecord logRecord) {
        String string = this.doFormat(logRecord);
        if (string == null) {
            string = super.format(logRecord);
        }
        return string;
    }

    private String doFormat(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer(FR_BEGIN);
        String string = this.formatter.format(new Date(logRecord.getMillis()));
        stringBuffer.append(string).append(FR_DELIMITER);
        stringBuffer.append(logRecord.getLevel().getName()).append(FR_DELIMITER);
        stringBuffer.append(PRODUCT_NAME).append(FR_DELIMITER);
        stringBuffer.append(logRecord.getSourceClassName()).append(FR_DELIMITER);
        Object[] objectArray = logRecord.getParameters();
        int n = 0;
        if (objectArray != null) {
            n = objectArray.length;
        }
        String string2 = logRecord.getMessage();
        String string3 = null;
        try {
            switch (n) {
                case 0: {
                    string3 = resources.getKString(string2);
                    break;
                }
                case 1: {
                    string3 = resources.getKString(string2, objectArray[0]);
                    break;
                }
                case 2: {
                    string3 = resources.getKString(string2, objectArray[0], objectArray[1]);
                    break;
                }
                default: {
                    string3 = resources.getKString(string2, objectArray);
                    break;
                }
            }
        }
        catch (Exception exception) {
            string3 = string2;
        }
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            string3 = string3 + "\n" + ULFformatter.getThrowableMessage(throwable);
        }
        stringBuffer.append(string3);
        stringBuffer.append(FR_END);
        return stringBuffer.toString();
    }

    private static String getThrowableMessage(Throwable throwable) {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            string = byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }
}

