/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato;

import com.iplanet.jato.SQLConnectionManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class SQLConnectionManagerBase
implements SQLConnectionManager {
    private static Map dataSourceNameMap = new HashMap();
    private static boolean usingJNDI = true;

    public Connection getConnection(String dataSource) throws SQLException {
        return SQLConnectionManagerBase.obtainConnection(dataSource);
    }

    public Connection getConnection(String dataSource, String user, String password) throws SQLException {
        return SQLConnectionManagerBase.obtainConnection(dataSource, user, password);
    }

    public static Connection obtainConnection(String dataSource) throws SQLException {
        return SQLConnectionManagerBase.obtainConnection(dataSource, null, null);
    }

    public static Connection obtainConnection(String dataSource, String user, String password) throws SQLException {
        Connection con = null;
        try {
            dataSource = SQLConnectionManagerBase.getMappedDataSourceName(dataSource);
            if (usingJNDI) {
                if (user != null) {
                    InitialContext context = new InitialContext();
                    DataSource jdbcDataSource = (DataSource)context.lookup(dataSource);
                    if (jdbcDataSource == null) {
                        throw new IllegalArgumentException("JNDI datasource \"" + dataSource + "\" not found in initial context");
                    }
                    con = jdbcDataSource.getConnection(user, password);
                } else {
                    InitialContext context = new InitialContext();
                    DataSource jdbcDataSource = (DataSource)context.lookup(dataSource);
                    if (jdbcDataSource == null) {
                        throw new IllegalArgumentException("JNDI datasource \"" + dataSource + "\" not found in initial context");
                    }
                    con = jdbcDataSource.getConnection();
                }
            } else if (user != null) {
                Properties info = new Properties();
                info.put("user", user);
                info.put("password", password);
                con = DriverManager.getConnection(dataSource, info);
            } else {
                con = DriverManager.getConnection(dataSource);
            }
        }
        catch (NamingException ex) {
            throw new SQLException(ex.toString(true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            throw new SQLException(ex.toString());
        }
        return con;
    }

    public static void addDataSourceMapping(String dataSourceName, String mappedValue) {
        dataSourceNameMap.put(dataSourceName, mappedValue);
    }

    protected static String getMappedDataSourceName(String dataSourceName) {
        String result = (String)dataSourceNameMap.get(dataSourceName);
        if (result == null) {
            result = dataSourceName;
        }
        return result;
    }

    public static boolean isUsingJNDI() {
        return usingJNDI;
    }

    public static void setUsingJNDI(boolean value) {
        usingJNDI = value;
    }
}

