/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.taglib;

import com.iplanet.jato.taglib.TagBase;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.html.HtmlDisplayField;

public class DisplayFieldTagBase
extends TagBase {
    public static boolean FORMATTING_ENABLED = true;

    protected String formatValue(Object value) {
        if (value == null) {
            return null;
        }
        if (!FORMATTING_ENABLED) {
            return value.toString();
        }
        String formatMask = this.getFormatMask();
        if (formatMask == null) {
            return value.toString();
        }
        int formatType = 1;
        String formatTypeString = this.getFormatType();
        if (formatTypeString != null) {
            if (formatTypeString.startsWith("alpha") || formatTypeString.startsWith("string")) {
                formatType = 1;
            } else if (formatTypeString.startsWith("date")) {
                formatType = 2;
            } else if (formatTypeString.startsWith("dec")) {
                formatType = 4;
            } else if (formatTypeString.startsWith("curr")) {
                formatType = 3;
            }
        }
        return HtmlUtil.format(value, formatType, formatMask);
    }

    protected void appendJavaScriptAttributes(NonSyncStringBuffer buffer) {
        this.appendMouseEventAttributes(buffer);
        this.appendKeyEventAttributes(buffer);
        this.appendTextEventAttributes(buffer);
        this.appendFocusEventAttributes(buffer);
    }

    private void appendMouseEventAttributes(NonSyncStringBuffer buffer) {
        if (this.getOnClick() != null) {
            buffer.append(" onClick=\"").append(this.getOnClick()).append("\"");
        }
        if (this.getOnDblClick() != null) {
            buffer.append(" onDblClick=\"").append(this.getOnDblClick()).append("\"");
        }
        if (this.getOnMouseOver() != null) {
            buffer.append(" onMouseOver=\"").append(this.getOnMouseOver()).append("\"");
        }
        if (this.getOnMouseOut() != null) {
            buffer.append(" onMouseOut=\"").append(this.getOnMouseOut()).append("\"");
        }
        if (this.getOnMouseMove() != null) {
            buffer.append(" onMouseMove=\"").append(this.getOnMouseMove()).append("\"");
        }
        if (this.getOnMouseDown() != null) {
            buffer.append(" onMouseDown=\"").append(this.getOnMouseDown()).append("\"");
        }
        if (this.getOnMouseUp() != null) {
            buffer.append(" onMouseUp=\"").append(this.getOnMouseUp()).append("\"");
        }
    }

    private void appendKeyEventAttributes(NonSyncStringBuffer buffer) {
        if (this.getOnKeyDown() != null) {
            buffer.append(" onKeyDown=\"").append(this.getOnKeyDown()).append("\"");
        }
        if (this.getOnKeyUp() != null) {
            buffer.append(" onKeyUp=\"").append(this.getOnKeyUp()).append("\"");
        }
        if (this.getOnKeyPress() != null) {
            buffer.append(" onKeyPress=\"").append(this.getOnKeyPress()).append("\"");
        }
    }

    private void appendTextEventAttributes(NonSyncStringBuffer buffer) {
        if (this.getOnSelect() != null) {
            buffer.append(" onSelect=\"").append(this.getOnSelect()).append("\"");
        }
        if (this.getOnChange() != null) {
            buffer.append(" onChange=\"").append(this.getOnChange()).append("\"");
        }
    }

    private void appendFocusEventAttributes(NonSyncStringBuffer buffer) {
        if (this.getOnBlur() != null) {
            buffer.append(" onBlur=\"").append(this.getOnBlur()).append("\"");
        }
        if (this.getOnFocus() != null) {
            buffer.append(" onFocus=\"").append(this.getOnFocus()).append("\"");
        }
    }

    protected void appendExtraHtml(HtmlDisplayField field, NonSyncStringBuffer buffer) {
        if (field.getExtraHtml() != null) {
            buffer.append(" ").append(field.getExtraHtml());
        }
        if (this.getExtraHtml() != null) {
            buffer.append(" ").append(this.getExtraHtml());
        }
    }

    protected void appendCommonHtmlAttributes(NonSyncStringBuffer buffer) {
        if (this.getAccessKey() != null) {
            buffer.append(" accesskey=\"").append(this.getAccessKey()).append("\"");
        }
        if (this.isTrue(this.getDisabled())) {
            buffer.append(" disabled");
        }
        if (this.getTabIndex() != null) {
            buffer.append(" tabindex=\"").append(this.getTabIndex()).append("\"");
        }
    }

    public String getDefaultValue() {
        return (String)this.getValue("defaultValue");
    }

    public void setDefaultValue(String value) {
        this.setValue("defaultValue", value);
    }

    public String getExtraHtml() {
        return (String)this.getValue("extraHtml");
    }

    public void setExtraHtml(String value) {
        this.setValue("extraHtml", value);
    }

    public String getAlt() {
        return (String)this.getValue("alt");
    }

    public void setAlt(String value) {
        this.setValue("alt", value);
    }

    public String getFormatType() {
        return (String)this.getValue("formatType");
    }

    public void setFormatType(String value) {
        this.setValue("formatType", value);
    }

    public String getFormatMask() {
        return (String)this.getValue("formatMask");
    }

    public void setFormatMask(String value) {
        this.setValue("formatMask", value);
    }

    public String getAccessKey() {
        return (String)this.getValue("accessKey");
    }

    public void setAccessKey(String value) {
        this.setValue("accessKey", value);
    }

    public String getDisabled() {
        return (String)this.getValue("disabled");
    }

    public void setDisabled(String value) {
        this.setValue("disabled", value);
    }

    public String getTabIndex() {
        return (String)this.getValue("tabIndex");
    }

    public void setTabIndex(String value) {
        this.setValue("tabIndex", value);
    }

    public String getOnClick() {
        return (String)this.getValue("onClick");
    }

    public void setOnClick(String value) {
        this.setValue("onClick", value);
    }

    public String getOnDblClick() {
        return (String)this.getValue("onDblClick");
    }

    public void setOnDblClick(String value) {
        this.setValue("onDblClick", value);
    }

    public String getOnMouseDown() {
        return (String)this.getValue("onMouseDown");
    }

    public void setOnMouseDown(String value) {
        this.setValue("onMouseDown", value);
    }

    public String getOnMouseUp() {
        return (String)this.getValue("onMouseUp");
    }

    public void setOnMouseUp(String value) {
        this.setValue("onMouseUp", value);
    }

    public String getOnMouseMove() {
        return (String)this.getValue("onMouseMove");
    }

    public void setOnMouseMove(String value) {
        this.setValue("onMouseMove", value);
    }

    public String getOnMouseOver() {
        return (String)this.getValue("onMouseOver");
    }

    public void setOnMouseOver(String value) {
        this.setValue("onMouseOver", value);
    }

    public String getOnMouseOut() {
        return (String)this.getValue("onMouseOut");
    }

    public void setOnMouseOut(String value) {
        this.setValue("onMouseOut", value);
    }

    public String getOnKeyDown() {
        return (String)this.getValue("onKeyDown");
    }

    public void setOnKeyDown(String value) {
        this.setValue("onKeyDown", value);
    }

    public String getOnKeyUp() {
        return (String)this.getValue("onKeyUp");
    }

    public void setOnKeyUp(String value) {
        this.setValue("onKeyUp", value);
    }

    public String getOnKeyPress() {
        return (String)this.getValue("onKeyPress");
    }

    public void setOnKeyPress(String value) {
        this.setValue("onKeyPress", value);
    }

    public String getOnChange() {
        return (String)this.getValue("onChange");
    }

    public void setOnChange(String value) {
        this.setValue("onChange", value);
    }

    public String getOnSelect() {
        return (String)this.getValue("onSelect");
    }

    public void setOnSelect(String value) {
        this.setValue("onSelect", value);
    }

    public String getOnBlur() {
        return (String)this.getValue("onBlur");
    }

    public void setOnBlur(String value) {
        this.setValue("onBlur", value);
    }

    public String getOnFocus() {
        return (String)this.getValue("onFocus");
    }

    public void setOnFocus(String value) {
        this.setValue("onFocus", value);
    }
}

