/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.taglib.html;

import com.iplanet.jato.ClientSession;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.taglib.AbstractVisualBodyTag;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.CommandField;
import com.iplanet.jato.view.CommandSourceTargetPair;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.view.html.HtmlDisplayField;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;

public class HrefTag
extends AbstractVisualBodyTag {
    static /* synthetic */ Class class$com$iplanet$jato$view$CommandField;

    protected void generateStartTagContent(NonSyncStringBuffer buffer) throws JspException {
        ContainerView parentContainer = this.getParentContainerView();
        View child = parentContainer.getChild(this.getName());
        this.checkChildType(child, class$com$iplanet$jato$view$CommandField == null ? (class$com$iplanet$jato$view$CommandField = HrefTag.class$("com.iplanet.jato.view.CommandField")) : class$com$iplanet$jato$view$CommandField);
        CommandField field = (CommandField)child;
        Object value = field.getValue();
        if (value == null) {
            value = this.getDefaultValue();
        }
        ViewBean viewBean = this.getParentViewBean();
        buffer.append("<a href=\"");
        this.appendHrefURL(buffer);
        buffer.append("?").append(field.getQualifiedName()).append("=");
        if (value != null) {
            buffer.append(URLEncoder.encode(value.toString()));
        }
        this.appendQueryParams(buffer);
        this.appendExtraValues(field, buffer);
        buffer.append("&");
        this.appendPageSessionParameter(buffer);
        this.appendClientSessionParameter(buffer);
        if (this.getAnchor() != null) {
            buffer.append("#").append(this.getAnchor());
        }
        buffer.append("\"");
        this.appendOtherAttributes(buffer);
        this.appendCommonHtmlAttributes(buffer);
        this.appendJavaScriptAttributes(buffer);
        this.appendStyleAttributes(buffer);
        if (field instanceof HtmlDisplayField) {
            this.appendExtraHtml((HtmlDisplayField)((Object)field), buffer);
        }
        buffer.append(">");
    }

    protected void generateBodyContent(NonSyncStringBuffer buffer) throws JspException {
        BodyContent bodyContent = this.getBodyContent();
        if (bodyContent != null) {
            if (this.getTrim() == null || this.isTrue(this.getTrim())) {
                buffer.append(bodyContent.getString().trim());
            } else {
                buffer.append(bodyContent.getString());
            }
        }
    }

    protected void generateEndTagContent(NonSyncStringBuffer buffer) throws JspException {
        buffer.append("</a>");
    }

    protected void appendHrefURL(NonSyncStringBuffer buffer) throws JspException {
        ViewBean viewBean = this.getParentViewBean();
        buffer.append(((HttpServletResponse)this.pageContext.getResponse()).encodeURL(viewBean.getModuleURL() + "/" + viewBean.getRequestInvocationName()));
    }

    protected void appendPageSessionParameter(NonSyncStringBuffer buffer) throws JspException {
        ViewBean viewBean = this.getParentViewBean();
        buffer.append("jato.pageSession").append("=").append(viewBean.getPageSessionAttributeString(false));
    }

    protected void appendClientSessionParameter(NonSyncStringBuffer buffer) throws JspException {
        try {
            ViewBean viewBean = this.getParentViewBean();
            ClientSession clientSession = viewBean.getRequestContext().getClientSession();
            if (clientSession.hasAttributes()) {
                buffer.append("&").append("jato.clientSession").append("=").append(clientSession.getEncodedString());
            }
        }
        catch (IOException e) {
            throw new JspException("Error serializing client session", (Throwable)e);
        }
    }

    protected void appendOtherAttributes(NonSyncStringBuffer buffer) throws JspException {
        if (this.getTarget() != null) {
            buffer.append(" target=\"").append(this.getTarget()).append("\"");
        }
        if (this.getTitle() != null) {
            buffer.append(" title=\"").append(this.getTitle()).append("\"");
        }
    }

    protected void appendQueryParams(NonSyncStringBuffer buffer) throws JspException {
        String nvPairs = this.getQueryParams();
        if (nvPairs != null && nvPairs.length() > 0) {
            buffer.append("&");
            buffer.append(nvPairs);
        }
    }

    protected void appendExtraValues(CommandField field, NonSyncStringBuffer buffer) throws JspException {
        Map values = field.getExtraValuesMap();
        if (values == null) {
            return;
        }
        this.addSourceTargetValues(field, values);
        if (values.size() == 0) {
            return;
        }
        Iterator i = values.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = values.get(key);
            if (value == null) continue;
            buffer.append("&").append(key).append("=").append(URLEncoder.encode(value.toString()));
        }
    }

    private void addSourceTargetValues(CommandField field, Map extraValues) throws JspException {
        if (field.getCommandFieldDescriptor() == null) {
            return;
        }
        CommandSourceTargetPair[] pairs = field.getCommandFieldDescriptor().getSourceTargetPairs();
        int i = 0;
        while (i < pairs.length) {
            CommandSourceTargetPair nextPair = pairs[i];
            String strValue = "";
            String[] sourcePath = nextPair.getSourcePath();
            switch (nextPair.getSourceType()) {
                case 1: 
                case 2: {
                    Model sourceModel = this.getParentViewBean().getModel(nextPair.getSourceClass());
                    Object objValue = sourceModel.getValue(sourcePath[1]);
                    if (objValue == null) break;
                    strValue = objValue.toString();
                    break;
                }
                case 3: {
                    DisplayField child = this.getDisplayField(sourcePath);
                    strValue = child.stringValue();
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
            }
            extraValues.put(HREF.getSourceTargetParameterName(i), strValue);
            ++i;
        }
    }

    private DisplayField getDisplayField(String[] namePath) throws JspException {
        ContainerView parentView = this.getParentViewBean();
        int j = 1;
        while (j < namePath.length - 1) {
            parentView = (ContainerView)parentView.getChild(namePath[j]);
            ++j;
        }
        return (DisplayField)parentView.getChild(namePath[namePath.length - 1]);
    }

    public String getTarget() {
        return (String)this.getValue("target");
    }

    public void setTarget(String value) {
        this.setValue("target", value);
    }

    public String getTitle() {
        return (String)this.getValue("title");
    }

    public void setTitle(String value) {
        this.setValue("title", value);
    }

    public String getAnchor() {
        return (String)this.getValue("anchor");
    }

    public void setAnchor(String value) {
        this.setValue("anchor", value);
    }

    public String getQueryParams() {
        return (String)this.getValue("queryParams");
    }

    public void setQueryParams(String value) {
        this.setValue("queryParams", value);
    }

    public String getTrim() {
        return (String)this.getValue("trim");
    }

    public void setTrim(String value) {
        this.setValue("trim", value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

