/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.view;

import com.iplanet.jato.model.ModelFieldBinding;
import com.iplanet.jato.model.ModelReference;
import com.iplanet.jato.util.TypeConverter;
import com.iplanet.jato.view.BasicDisplayField;
import com.iplanet.jato.view.BooleanDisplayField;
import com.iplanet.jato.view.View;

public class BasicBooleanDisplayField
extends BasicDisplayField
implements BooleanDisplayField {
    public static final String BOOLEAN_FIELD_MARKER_NAME = "jato_boolean";
    public static boolean OPTION_OLD_BOOLEAN_FIELD_MAPPING;
    private Object trueValue = Boolean.TRUE;
    private Object falseValue;

    public BasicBooleanDisplayField() {
    }

    public BasicBooleanDisplayField(View parent, String name) {
        this(parent, name, Boolean.TRUE, Boolean.FALSE);
    }

    public BasicBooleanDisplayField(View parent, String name, Object trueValue, Object falseValue) {
        super(parent, name);
        this.setTrueValue(trueValue);
        this.setFalseValue(falseValue);
    }

    public BasicBooleanDisplayField(View parent, String name, ModelReference reference, ModelFieldBinding binding, Object trueValue, Object falseValue) {
        super(parent, name, reference, binding);
        this.setTrueValue(trueValue);
        this.setFalseValue(falseValue);
    }

    public Object getValue() {
        Object value = super.getValue();
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return this.getTrueValue();
            }
            return this.getFalseValue();
        }
        return value;
    }

    public void setValue(Object value) {
        this.setValue(value, true);
    }

    public void setValue(Object value, boolean overwrite) {
        if (value == null) {
            super.setValue(this.getFalseValue(), overwrite);
        } else if (value.equals(this.getTrueValue()) || value.equals(this.getFalseValue())) {
            super.setValue(value, overwrite);
        } else {
            Object convertedValue;
            if (this.getTrueValue() != null && (convertedValue = TypeConverter.asType(this.getTrueValue().getClass(), value)) != null && convertedValue.equals(this.getTrueValue())) {
                super.setValue(this.getTrueValue(), overwrite);
                return;
            }
            if (this.getFalseValue() != null && (convertedValue = TypeConverter.asType(this.getFalseValue().getClass(), value)) != null && convertedValue.equals(this.getFalseValue())) {
                super.setValue(this.getFalseValue(), overwrite);
                return;
            }
            throw new IllegalArgumentException("Attempted to set field \"" + this.getName() + "\" to value \"" + value + "\", which is not equal to the true value \"" + this.getTrueValue() + "\" or false value \"" + this.getFalseValue() + "\"");
        }
    }

    public boolean booleanValue() {
        return this.getState();
    }

    public boolean getState() {
        if (this.getValue() != null) {
            if (this.getTrueValue() != null) {
                Object convertedValue = TypeConverter.asType(this.getTrueValue().getClass(), this.getValue());
                if (convertedValue != null && this.getValue().equals(this.getTrueValue())) {
                    return true;
                }
                return this.getValue().equals(this.getTrueValue());
            }
            if (this.getValue() instanceof Boolean) {
                return (Boolean)this.getValue();
            }
            return false;
        }
        return false;
    }

    public void setState(boolean value) {
        if (value && this.getTrueValue() == null) {
            super.setValue(Boolean.TRUE);
        } else if (!value && this.getFalseValue() == null) {
            super.setValue(Boolean.FALSE);
        } else {
            super.setValue(value ? this.getTrueValue() : this.getFalseValue());
        }
    }

    public Object getTrueValue() {
        return this.trueValue;
    }

    public Object getFalseValue() {
        return this.falseValue;
    }

    public void setTrueValue(Object value) {
        this.trueValue = value;
    }

    public void setFalseValue(Object value) {
        this.falseValue = value;
    }

    static {
        BOOLEAN_FIELD_MARKER_NAME = BOOLEAN_FIELD_MARKER_NAME;
        OPTION_OLD_BOOLEAN_FIELD_MAPPING = false;
    }
}

