/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.common;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.web.ui.common.CCDebugTrace;
import com.sun.web.ui.common.CCServerInterface;
import com.sun.web.ui.common.CCSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletContext;

public final class CCDebug {
    private static final boolean ON = true;
    private static final int TRACE_OFF = 0;
    private static final String DEBUG_LEVEL_PROP = "com.sun.web.ui.debug.options";
    private static final String DEBUG_DEVICE_PROP = "com.sun.web.ui.debug.device";
    private static final String STDERR = "stderr";
    private static final String STDOUT = "stdout";
    private static boolean trace_init = false;
    private static int trace_level = 0;
    private static CCDebugTrace tracer = null;
    private static boolean trace_time = false;
    private static boolean trace_method = false;
    private static boolean trace_thread = false;
    private static PrintStream pStream = null;

    public static final synchronized void initTrace() {
        if (trace_init) {
            return;
        }
        String config = null;
        String device = null;
        try {
            trace_level = 0;
            if (CCSystem.isAppInConsole()) {
                CCServerInterface server = CCSystem.getServerInterface();
                tracer = server.getCCDebugTrace();
                if (tracer != null) {
                    trace_level = tracer.getLevel();
                }
                if (trace_level > 0) {
                    tracer.enableTrace(trace_level);
                }
            } else {
                config = System.getProperty(DEBUG_LEVEL_PROP);
                device = System.getProperty(DEBUG_DEVICE_PROP);
                if (config == null || config.length() == 0) {
                    RequestContext reqContext = RequestManager.getRequestContext();
                    ServletContext context = reqContext.getServletContext();
                    config = context.getInitParameter(DEBUG_LEVEL_PROP);
                    device = context.getInitParameter(DEBUG_DEVICE_PROP);
                }
            }
        }
        catch (Throwable tex) {
            trace_level = 0;
        }
        try {
            if (config != null && device != null) {
                trace_level = Integer.parseInt(config.substring(0, 1));
                trace_method = config.indexOf(109) > 0;
                trace_time = config.indexOf(116) > 0;
                boolean bl = trace_thread = config.indexOf(112) > 0;
                if (device.equalsIgnoreCase(STDOUT)) {
                    pStream = System.out;
                } else if (device.equalsIgnoreCase(STDERR)) {
                    pStream = System.err;
                } else {
                    File f = new File(device);
                    if (f.exists()) {
                        FileOutputStream fos = new FileOutputStream(f, true);
                        pStream = new PrintStream(fos);
                    }
                }
            }
        }
        catch (Throwable tex) {
            trace_level = 0;
        }
        trace_init = true;
        CCDebug.trace1("Starting component debug tracing...");
    }

    public static final boolean isOn() {
        return trace_level > 0;
    }

    public static final void trace1(String message) {
        if (trace_level > 0) {
            CCDebug.writeTrace(message, null);
        }
    }

    public static final void trace1(String message, Throwable ex) {
        if (trace_level > 0) {
            CCDebug.writeTrace(message, ex);
        }
    }

    public static final void trace2(String message) {
        if (trace_level > 1) {
            CCDebug.writeTrace(message, null);
        }
    }

    public static final void trace2(String message, Throwable ex) {
        if (trace_level > 1) {
            CCDebug.writeTrace(message, ex);
        }
    }

    public static final void trace3(String message) {
        if (trace_level > 2) {
            CCDebug.writeTrace(message, null);
        }
    }

    public static final void trace3(String message, Throwable ex) {
        if (trace_level > 2) {
            CCDebug.writeTrace(message, ex);
        }
    }

    public static String getClassMethod(int ancestor) {
        StackTraceElement stackElement = CCDebug.getStackFrame(++ancestor);
        return stackElement.getClassName() + ":" + stackElement.getMethodName();
    }

    public static String where(int traceLevel) {
        StringBuffer stackbuf = new StringBuffer(1024);
        StackTraceElement[] st = CCDebug.getStack();
        traceLevel += 2;
        for (int i = 2; i < st.length && i < traceLevel; ++i) {
            stackbuf.append(st[i].toString());
            stackbuf.append("\n");
        }
        return stackbuf.toString();
    }

    public static String where(Throwable e, int traceLevel) {
        StringBuffer stackbuf = new StringBuffer(1024);
        stackbuf.append(e.getClass().getName()).append(" : ").append(e.getMessage()).append("\n");
        StackTraceElement[] st = e.getStackTrace();
        for (int i = 0; i < st.length && i < traceLevel; ++i) {
            stackbuf.append("    ").append(st[i].toString()).append("\n");
        }
        return stackbuf.toString();
    }

    private static synchronized void writeTrace(String msg, Throwable ex) {
        if (tracer != null) {
            String[] clmd = CCDebug.getClassMethodNames();
            tracer.trace(trace_level, msg, clmd[0], clmd[1], ex);
            return;
        }
        String trace_msg = "";
        if (trace_time) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            trace_msg = sdf.format(new Date()) + " | ";
        }
        if (trace_thread) {
            Thread th = Thread.currentThread();
            trace_msg = trace_msg + th.getName() + " | ";
        }
        if (trace_method) {
            String[] clmd = CCDebug.getClassMethodNames();
            trace_msg = trace_msg + clmd[0] + ":" + clmd[1] + " | ";
        }
        trace_msg = trace_msg + msg;
        pStream.println(trace_msg);
        if (ex != null) {
            ex.printStackTrace(pStream);
        }
    }

    private static String[] getClassMethodNames() {
        String mn;
        StackTraceElement stackElement = CCDebug.getStackFrame(3);
        String[] clmd = new String[]{"", ""};
        String cn = stackElement.getClassName();
        if (cn != null) {
            clmd[0] = cn;
        }
        if ((mn = stackElement.getMethodName()) != null) {
            clmd[1] = mn;
        }
        return clmd;
    }

    private static StackTraceElement getStackFrame(int frame) {
        StackTraceElement[] stack = CCDebug.getStack();
        if ((frame += 2) > stack.length) {
            return stack[2];
        }
        return stack[frame];
    }

    private static StackTraceElement[] getStack() {
        Exception e = new Exception();
        e.fillInStackTrace();
        return e.getStackTrace();
    }
}

