/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCNavNodeInterface;
import java.util.ArrayList;
import java.util.List;

public class CCNavNode
extends DefaultModel
implements CCNavNodeInterface {
    private static final long serialVersionUID = -6567750992047718315L;
    protected String label = null;
    protected String value = null;
    protected CCNavNodeInterface parent = null;
    protected boolean visible = true;
    protected boolean acceptsChildren = true;
    protected String tooltip = null;
    protected String status = null;
    protected List children = null;
    protected boolean expanded = false;
    protected boolean notClickable = false;
    protected boolean isRoot = false;
    protected String imageSrc = null;
    protected String imageAltText;
    protected int imageWidth = -1;
    protected int imageHeight;
    protected int id;
    protected String target;
    protected String onclick;
    protected int alarmSeverity = 5;

    public CCNavNode(int id) {
        this.id = id;
    }

    public CCNavNode(int id, String label, String tooltip, String status) {
        this.id = id;
        this.setLabel(label);
        this.setTooltip(tooltip);
        this.setStatus(status);
    }

    public CCNavNode(int id, String label, String tooltip, String status, boolean acceptsChildren) {
        this(id, label, tooltip, status);
        this.acceptsChildren = acceptsChildren;
    }

    public CCNavNode(int id, CCNavNodeInterface parent, String label, String tooltip, String status) {
        this(id, label, tooltip, status);
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public CCNavNode(int id, CCNavNodeInterface parent, String label, String tooltip, String status, boolean acceptsChildren) {
        this(id, parent, label, tooltip, status);
        this.acceptsChildren = acceptsChildren;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getOnClick() {
        return this.onclick;
    }

    public void setOnClick(String onclick) {
        this.onclick = onclick;
    }

    public CCNavNodeInterface getParent() {
        return this.parent;
    }

    public boolean setParent(CCNavNodeInterface parent) {
        if (this.isRoot) {
            return false;
        }
        if (this.parent != null) {
            List list = this.parent.getChildren();
            list.remove(list.indexOf(this));
        }
        this.parent = parent;
        if (this.parent != null) {
            this.parent.getChildren().add(this);
        }
        return true;
    }

    public List getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    public boolean getAcceptsChildren() {
        return this.acceptsChildren;
    }

    public void setAcceptsChildren(boolean acceptsChildren) {
        this.acceptsChildren = acceptsChildren;
        if (!acceptsChildren) {
            this.removeAllChildren();
        }
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.expanded = isExpanded;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isRoot() {
        if (this.getLevel() > 0) {
            this.isRoot = false;
        }
        return this.isRoot;
    }

    public boolean setAsRoot() {
        if (!this.acceptsChildren) {
            return false;
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = null;
        this.isRoot = true;
        return true;
    }

    public CCNavNodeInterface getNextSibling() {
        CCNavNodeInterface sibling = null;
        if (this.parent != null) {
            List family = this.parent.getChildren();
            int index = family.indexOf(this);
            if (++index < family.size()) {
                sibling = (CCNavNodeInterface)family.get(index);
            }
        }
        return sibling;
    }

    public CCNavNodeInterface getPreviousSibling() {
        CCNavNodeInterface sibling = null;
        if (this.parent != null) {
            List family = this.parent.getChildren();
            int index = family.indexOf(this);
            if (--index > -1) {
                sibling = (CCNavNodeInterface)family.get(index);
            }
        }
        return sibling;
    }

    public boolean addChild(CCNavNodeInterface newNode) {
        if (!this.acceptsChildren || newNode == null) {
            return false;
        }
        newNode.setParent(this);
        return true;
    }

    public boolean insertChildAfter(CCNavNodeInterface child, CCNavNodeInterface newNode) {
        if (!this.acceptsChildren || child == null || newNode == null) {
            return false;
        }
        int index = this.getChildren().indexOf(child);
        if (index < 0) {
            return false;
        }
        if (++index == this.getChildren().size()) {
            this.getChildren().add(newNode);
        } else {
            this.getChildren().add(index, newNode);
        }
        return true;
    }

    public boolean insertChildBefore(CCNavNodeInterface child, CCNavNodeInterface newNode) {
        if (!this.acceptsChildren || child == null || newNode == null) {
            return false;
        }
        int index = this.getChildren().indexOf(child);
        if (index < 0 || newNode == null) {
            return false;
        }
        this.getChildren().add(index, newNode);
        return true;
    }

    public boolean removeChild(CCNavNodeInterface child) {
        if (child == null || !this.isNodeChild(child)) {
            return false;
        }
        child.setParent(null);
        return true;
    }

    public int getNumDescendants() {
        int numChildren;
        int numDescendants = numChildren = this.getChildren().size();
        for (int i = 0; i < numChildren; ++i) {
            numDescendants += ((CCNavNodeInterface)this.getChildren().get(i)).getNumDescendants();
        }
        return numDescendants;
    }

    public int getNumSiblings() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getChildren().size() - 1;
    }

    public int getLevel() {
        int level = 0;
        for (CCNavNodeInterface p = this.parent; p != null; p = p.getParent()) {
            ++level;
        }
        return level;
    }

    public void removeAllChildren() {
        List kids = this.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            ((CCNavNodeInterface)kids.get(i)).setParent(null);
        }
        this.children = new ArrayList();
    }

    public CCNavNodeInterface[] getPath() {
        int level;
        CCNavNodeInterface[] path = new CCNavNodeInterface[level];
        CCNavNodeInterface p = this.parent;
        for (level = this.getLevel(); level > 0; --level) {
            path[level - 1] = p;
            p = p.getParent();
        }
        return path;
    }

    public List getPathList() {
        CCNavNodeInterface[] path = this.getPath();
        ArrayList<CCNavNodeInterface> list = new ArrayList<CCNavNodeInterface>(path.length);
        for (int i = 0; i < path.length; ++i) {
            list.add(path[i]);
        }
        return list;
    }

    public CCNavNodeInterface getLastChild() {
        List kids = this.getChildren();
        if (kids.size() == 0) {
            return null;
        }
        return (CCNavNodeInterface)kids.get(kids.size() - 1);
    }

    public CCNavNodeInterface getFirstChild() {
        List kids = this.getChildren();
        if (kids.size() == 0) {
            return null;
        }
        return (CCNavNodeInterface)kids.get(0);
    }

    public boolean isNodeChild(CCNavNodeInterface node) {
        if (node == null) {
            return false;
        }
        return this.getChildren().contains(node);
    }

    public boolean isNodeAncestor(CCNavNodeInterface node) {
        if (node == null) {
            return false;
        }
        if (this == node) {
            return true;
        }
        boolean found = false;
        for (CCNavNodeInterface p = this.parent; p != null && !found; p = p.getParent()) {
            found = p.equals(node);
        }
        return found;
    }

    public boolean isNodeDescendant(CCNavNodeInterface node) {
        return node.isNodeAncestor(this);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public CCNavNodeInterface hasDescendant(int id) {
        CCNavNodeInterface node = null;
        if (this.getId() == id) {
            return this;
        }
        int numKids = this.getChildren().size();
        for (int i = 0; i < numKids && (node = ((CCNavNodeInterface)this.getChildren().get(i)).hasDescendant(id)) == null; ++i) {
        }
        return node;
    }

    public int getNumChildren() {
        return this.getChildren().size();
    }

    public String getImage() {
        return this.imageSrc;
    }

    public void setImage(String src) {
        this.imageSrc = src;
    }

    public void setAlarmSeverity(int severity) {
        if (severity < 1 && severity > 5) {
            CCDebug.trace1("Invalid alarm severity : " + severity);
            return;
        }
        this.alarmSeverity = severity;
    }

    public int getAlarmSeverity() {
        return this.alarmSeverity;
    }

    public List getPathToDescendant(CCNavNodeInterface descendant) {
        if (descendant == null || this.hasDescendant(descendant.getId()) == null) {
            return null;
        }
        List path = descendant.getPathList();
        if (path == null) {
            return null;
        }
        path = path.subList(path.indexOf(this), path.size());
        return path;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int width) {
        this.imageWidth = width;
    }

    public boolean getNotClickable() {
        return this.notClickable;
    }

    public void setNotClickable(boolean notClickable) {
        this.notClickable = notClickable;
    }
}

