/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.datetime;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.web.ui.model.CCDateTimeModel;
import com.sun.web.ui.model.CCDateTimeModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.servlet.common.TagsViewBeanBase;
import com.sun.web.ui.servlet.datetime.DateTimeServlet;
import com.sun.web.ui.view.datetime.CCDateTime;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.masthead.CCSecondaryMasthead;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class DateTimeWindowViewBean
extends TagsViewBeanBase {
    public static final String PAGE_NAME = "DateTimeWindow";
    public static final String DEFAULT_DISPLAY_URL = "/com_sun_web_ui/jsp/datetime/DateTimeWindow.jsp";
    public static final String CHILD_MASTHEAD = "Masthead";
    public static final String CHILD_DATETIME = "DateTime";
    public static final String CHILD_PAGE_TITLE = "PageTitle";
    public static final String CHILD_HIDDEN_TEXT_NAME = "TextName";
    public static final String CHILD_HIDDEN_DTWIN_NAME = "DTWinName";
    public static final String CHILD_HIDDEN_INPUT_VALID = "InputValid";
    public static final String CHILD_HIDDEN_FORM_NAME = "ParentFormName";
    private CCPageTitleModel pageTitleModel = null;
    private CCDateTimeModelInterface dateTimeModel = null;
    private WindowAttributes winAttrs = null;

    public DateTimeWindowViewBean() {
        super(PAGE_NAME);
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.initModuleUrl();
        this.initPageTitleModel();
        this.registerChildren();
    }

    private void initModuleUrl() {
        String propertyName = "jato:" + DateTimeServlet.PACKAGE_NAME + ".*:moduleURL";
        RequestManager.getRequestContext().getServletContext().setAttribute(propertyName, (Object)"../datetime");
    }

    private void initPageTitleModel() {
        this.pageTitleModel = new CCPageTitleModel(RequestManager.getRequestContext().getServletContext(), "/com_sun_web_ui/jsp/datetime/pagetitle.xml");
        this.pageTitleModel.setValue("OkButton", "datetime.ok");
        this.pageTitleModel.setValue("CancelButton", "datetime.cancel");
    }

    protected void registerChildren() {
        this.registerChild(CHILD_MASTHEAD, CCSecondaryMasthead.class);
        this.registerChild(CHILD_PAGE_TITLE, CCPageTitle.class);
        this.registerChild(CHILD_HIDDEN_TEXT_NAME, CCHiddenField.class);
        this.registerChild(CHILD_HIDDEN_FORM_NAME, CCHiddenField.class);
        this.registerChild(CHILD_HIDDEN_DTWIN_NAME, CCHiddenField.class);
        this.registerChild(CHILD_HIDDEN_INPUT_VALID, CCHiddenField.class);
        this.registerChild(CHILD_DATETIME, CCDateTime.class);
        this.pageTitleModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        if (name.equals(CHILD_MASTHEAD)) {
            CCSecondaryMasthead child = new CCSecondaryMasthead((ContainerView)this, name);
            return child;
        }
        if (name.equals(CHILD_DATETIME)) {
            CCDateTime child = new CCDateTime((ContainerView)this, this.getDateTimeModel(), name);
            return child;
        }
        if (name.equals(CHILD_PAGE_TITLE)) {
            CCPageTitle child = new CCPageTitle((ContainerView)this, this.pageTitleModel, name);
            return child;
        }
        if (name.equals(CHILD_HIDDEN_TEXT_NAME) || name.equals(CHILD_HIDDEN_FORM_NAME) || name.equals(CHILD_HIDDEN_DTWIN_NAME) || name.equals(CHILD_HIDDEN_INPUT_VALID)) {
            CCHiddenField child = new CCHiddenField((ContainerView)this, name, null);
            return child;
        }
        if (this.pageTitleModel.isChildSupported(name)) {
            return this.pageTitleModel.createChild((View)this, name);
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        HttpServletRequest request = this.getRequestContext().getRequest();
        CCDateTime dt = (CCDateTime)this.getChild(CHILD_DATETIME);
        CCDateTimeModelInterface model = dt.getModel();
        WindowAttributes winAttrs = (WindowAttributes)this.getPageSessionAttribute("winAttrs");
        if (winAttrs == null) {
            winAttrs = new WindowAttributes();
            winAttrs.src = request.getParameter("src");
            winAttrs.alt = request.getParameter("alt");
            winAttrs.width = request.getParameter("width");
            winAttrs.height = request.getParameter("height");
            winAttrs.dateTextName = request.getParameter("dateTextName");
            winAttrs.parentFormName = request.getParameter("formName");
            winAttrs.dateTimeWindowName = request.getParameter("dateTimeWindowName");
            winAttrs.showPreviewButton = request.getParameter("showPreview");
            winAttrs.modelType = new Integer(model.getType());
            winAttrs.repeatIntervals = model.getRepeatIntervals();
            this.setPageSessionAttribute("winAttrs", winAttrs);
        }
        CCSecondaryMasthead child = (CCSecondaryMasthead)this.getChild(CHILD_MASTHEAD);
        child.setSrc(winAttrs.src);
        child.setHeight(winAttrs.height);
        child.setWidth(winAttrs.width);
        child.setAlt(winAttrs.alt);
        this.setDisplayFieldValue(CHILD_HIDDEN_TEXT_NAME, winAttrs.dateTextName);
        this.setDisplayFieldValue(CHILD_HIDDEN_FORM_NAME, winAttrs.parentFormName);
        this.setDisplayFieldValue(CHILD_HIDDEN_DTWIN_NAME, winAttrs.dateTimeWindowName);
        model.setType(winAttrs.modelType);
        model.setRepeatIntervals(winAttrs.repeatIntervals);
        if (winAttrs.showPreviewButton != null && winAttrs.showPreviewButton.equals("true")) {
            ((CCDateTime)this.getChild(CHILD_DATETIME)).setShowPreviewButton(true);
        }
        this.initDateTimeModel(request, dt, model);
    }

    private void initDateTimeModel(HttpServletRequest request, CCDateTime dateTime, CCDateTimeModelInterface model) {
        String startDateParam = request.getParameter("startDate");
        if (startDateParam != null && !startDateParam.equals("")) {
            startDateParam = dateTime.validateDateString(startDateParam);
            try {
                Calendar c = dateTime.getCalendar();
                c.setTime(dateTime.getDateFormat().parse(startDateParam));
                model.setStartDateTime(c.getTime());
                String hour = request.getParameter("startHour");
                String minute = request.getParameter("startMinute");
                c.set(11, new Integer(hour));
                c.set(12, new Integer(minute));
                model.setStartDateTime(c.getTime());
                hour = request.getParameter("endHour");
                minute = request.getParameter("endMinute");
                c.set(11, new Integer(hour));
                c.set(12, new Integer(minute));
                model.setEndTime(c.getTime());
                String interval = request.getParameter("repeatInterval");
                int index = 0;
                String[] repeatIntervals = model.getRepeatIntervals();
                interval = interval.substring("interval".length());
                index = new Integer(interval);
                model.setSelectedRepeatIntervalName(repeatIntervals[index]);
                String period = request.getParameter("repeatPeriod");
                model.setRepeatLimitPeriod(new Integer(period));
                String unit = request.getParameter("repeatUnit");
                unit = unit.substring("limitUnit".length());
                model.setRepeatLimitUnit(new Integer(unit));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void handleOkButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        WindowAttributes winAttrs = (WindowAttributes)this.getPageSessionAttribute("winAttrs");
        CCDateTime dt = (CCDateTime)this.getChild(CHILD_DATETIME);
        CCDateTimeModelInterface model = dt.getModel();
        model.setType(winAttrs.modelType);
        model.setRepeatIntervals(winAttrs.repeatIntervals);
        if (dt.validateDataInput()) {
            this.setDisplayFieldValue(CHILD_HIDDEN_INPUT_VALID, "true");
        }
        this.forwardTo(this.getRequestContext());
    }

    public CCDateTimeModelInterface getDateTimeModel() {
        if (this.dateTimeModel == null) {
            this.dateTimeModel = new CCDateTimeModel();
        }
        return this.dateTimeModel;
    }

    public void setDateTimeModel(CCDateTimeModelInterface model) {
        this.dateTimeModel = model;
    }

    static class WindowAttributes
    implements Serializable {
        public String alt;
        public String src;
        public String width;
        public String height;
        public String dateTextName;
        public String parentFormName;
        public String dateTimeWindowName;
        public Integer modelType;
        public String[] repeatIntervals;
        public String showPreviewButton;

        WindowAttributes() {
        }
    }
}

