/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.filechooser;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.web.ui.model.CCFileChooserModel;
import com.sun.web.ui.model.CCFileChooserModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.servlet.common.TagsViewBeanBase;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.filechooser.CCFileChooser;
import com.sun.web.ui.view.filechooser.CCPopupEventHandlerInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.masthead.CCSecondaryMasthead;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class FileChooserWindowViewBean
extends TagsViewBeanBase
implements CCPopupEventHandlerInterface {
    public static final String PAGE_NAME = "FileChooserWindow";
    public static final String DEFAULT_DISPLAY_URL = "/com_sun_web_ui/jsp/filechooser/FileChooserWindow.jsp";
    public static final String BROWSER_SERVER_MHEAD = "Masthead";
    public static final String CHILD_HIDDEN_FILELIST = "filelist";
    public static final String CHILD_HIDDEN_FIELDNAME = "fieldname";
    public static final String CHILD_FILECHOOSER = "FileChooser";
    public static final String CHILD_ALERT = "Alert";
    public static final String CHOOSE_FILE_BUTTON = "ChooseButton";
    public static final String CHILD_PAGE_TITLE = "PageTitle";
    private static CCPageTitleModel popupFCPageTitleModel;

    public FileChooserWindowViewBean(RequestContext requestContext) {
        super(PAGE_NAME);
        this.setRequestContext(requestContext);
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.deserializePageAttributes();
        popupFCPageTitleModel = this.createPageTitleModel();
        this.registerChildren();
    }

    private CCPageTitleModel createPageTitleModel() {
        CCPageTitleModel model = new CCPageTitleModel(RequestManager.getRequestContext().getServletContext(), "/com_sun_web_ui/jsp/filechooser/filechooserpgtitle.xml");
        return model;
    }

    protected void registerChildren() {
        this.registerChild(BROWSER_SERVER_MHEAD, CCSecondaryMasthead.class);
        this.registerChild(CHILD_FILECHOOSER, CCFileChooser.class);
        this.registerChild(CHILD_HIDDEN_FILELIST, CCHiddenField.class);
        this.registerChild(CHILD_HIDDEN_FIELDNAME, CCHiddenField.class);
        this.registerChild(CHILD_PAGE_TITLE, CCPageTitle.class);
        this.registerChild(CHILD_ALERT, CCAlertInline.class);
        popupFCPageTitleModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        if (name.equals(CHILD_HIDDEN_FILELIST)) {
            return new CCHiddenField((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_HIDDEN_FIELDNAME)) {
            String fieldName = (String)this.getRequestContext().getRequest().getSession().getAttribute("field_name");
            return new CCHiddenField((ContainerView)this, name, fieldName);
        }
        if (name.equals(CHILD_ALERT)) {
            CCAlertInline child = new CCAlertInline((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_FILECHOOSER)) {
            CCFileChooserModelInterface fileChooserModel = this.getFCModel();
            if (fileChooserModel == null) {
                fileChooserModel = new CCFileChooserModel();
                fileChooserModel.setServerName(null);
                fileChooserModel.setFileListBoxHeight(10);
            }
            fileChooserModel.setPopupMode(true);
            fileChooserModel.setAlertChildView(CHILD_ALERT);
            CCFileChooser child = new CCFileChooser((ContainerView)this, fileChooserModel, name);
            return child;
        }
        if (name.equals(BROWSER_SERVER_MHEAD)) {
            CCSecondaryMasthead child = new CCSecondaryMasthead((ContainerView)this, name);
            CCFileChooserModelInterface fileChooserModel = this.getFCModel();
            if (fileChooserModel != null) {
                child.setHeight(fileChooserModel.getProductNameHeight());
                child.setWidth(fileChooserModel.getProductNameWidth());
            }
            return child;
        }
        if (name.equals(CHILD_PAGE_TITLE)) {
            CCFileChooserModelInterface fcModel = this.getFCModel();
            CCButton chooseButton = (CCButton)this.getDisplayField(CHOOSE_FILE_BUTTON);
            CCButton cancelButton = (CCButton)this.getDisplayField("CancelButton");
            if (fcModel.getType().equals("file")) {
                if (fcModel.multipleSelect()) {
                    popupFCPageTitleModel.setValue(CHOOSE_FILE_BUTTON, "filechooser.chooseFiles");
                } else {
                    popupFCPageTitleModel.setValue(CHOOSE_FILE_BUTTON, "filechooser.chooseFile");
                }
                chooseButton.setTitle("filechooser.chooseFileTooltip");
            } else {
                if (fcModel.multipleSelect()) {
                    popupFCPageTitleModel.setValue(CHOOSE_FILE_BUTTON, "filechooser.chooseFolders");
                } else {
                    popupFCPageTitleModel.setValue(CHOOSE_FILE_BUTTON, "filechooser.chooseFolder");
                }
                chooseButton.setTitle("filechooser.chooseFolderTooltip");
            }
            cancelButton.setTitle("filechooser.cancelMsg");
            cancelButton.setType("secondary");
            popupFCPageTitleModel.setValue("CancelButton", "filechooser.cancel");
            CCPageTitle child = new CCPageTitle((ContainerView)this, popupFCPageTitleModel, name);
            return child;
        }
        if (popupFCPageTitleModel.isChildSupported(name)) {
            return popupFCPageTitleModel.createChild((View)this, name);
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    private CCFileChooserModelInterface getFCModel() {
        HttpServletRequest request = this.getRequestContext().getRequest();
        HttpSession session = request.getSession();
        String model_key = request.getParameter("model_key");
        if (model_key != null && model_key.length() != 0) {
            this.setPageSessionAttribute("model_key", (Serializable)((Object)model_key));
            return (CCFileChooserModelInterface)session.getAttribute(model_key);
        }
        model_key = (String)this.getPageSessionAttribute("model_key");
        if (model_key != null) {
            this.setPageSessionAttribute("model_key", (Serializable)((Object)model_key));
            return (CCFileChooserModelInterface)session.getAttribute(model_key);
        }
        return null;
    }

    public void handleChooseButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        String formFieldName = (String)this.getRequestContext().getRequest().getSession().getAttribute("field_name");
        CCAlertInline alertChild = (CCAlertInline)this.getChild(CHILD_ALERT);
        try {
            CCFileChooser child = (CCFileChooser)this.getChild(CHILD_FILECHOOSER);
            String[] fileList = child.getSelectedResources();
            if (fileList != null) {
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                buffer.append(fileList[i]);
                ++i;
                while (i < fileList.length) {
                    buffer.append(";").append(fileList[i]);
                    ++i;
                }
                this.setDisplayFieldValue(CHILD_HIDDEN_FILELIST, buffer.toString());
                this.setDisplayFieldValue(CHILD_HIDDEN_FIELDNAME, formFieldName);
            } else {
                String summary = alertChild.getSummary();
                if (summary == null || summary.length() == 0) {
                    if (child.getModel().getType().equals("file")) {
                        alertChild.setSummary("filechooser.noFileSelectedSum");
                        alertChild.setDetail("filechooser.noFileSelectedDet");
                    } else {
                        alertChild.setSummary("filechooser.noFolderSelectedErrSum");
                        alertChild.setDetail("filechooser.noFolderSelectedErrDet");
                    }
                }
                this.setDisplayFieldValue(CHILD_HIDDEN_FIELDNAME, formFieldName);
            }
        }
        catch (Exception e) {
            alertChild.setSummary("filechooser.cannotCompleteErrSum");
            alertChild.setDetail(e.getMessage());
            this.setDisplayFieldValue(CHILD_HIDDEN_FIELDNAME, formFieldName);
        }
        this.forwardTo(this.getRequestContext());
    }

    public void dblClickEvent(RequestInvocationEvent event) throws ServletException, IOException {
        String formFieldName = (String)this.getRequestContext().getRequest().getSession().getAttribute("field_name");
        try {
            CCFileChooser child = (CCFileChooser)this.getChild(CHILD_FILECHOOSER);
            String[] fileList = child.getModel().getSelectedFiles();
            if (fileList != null) {
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                buffer.append(fileList[i]);
                ++i;
                while (i < fileList.length) {
                    buffer.append(";").append(fileList[i]);
                    ++i;
                }
                this.setDisplayFieldValue(CHILD_HIDDEN_FILELIST, buffer.toString());
                this.setDisplayFieldValue(CHILD_HIDDEN_FIELDNAME, formFieldName);
            } else {
                this.setDisplayFieldValue(CHILD_HIDDEN_FIELDNAME, formFieldName);
            }
        }
        catch (Exception e) {
            CCAlertInline alertChild = (CCAlertInline)this.getChild(CHILD_ALERT);
            alertChild.setSummary("filechooser.cannotCompleteErrSum");
            alertChild.setDetail(e.getMessage());
            this.setDisplayFieldValue(CHILD_HIDDEN_FIELDNAME, formFieldName);
        }
        this.forwardTo(this.getRequestContext());
    }

    public void selectFieldEnterEvent(RequestInvocationEvent event) throws ServletException, IOException {
        this.dblClickEvent(event);
    }
}

