/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.topology;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.model.CCDefaultActionSet;
import com.sun.web.ui.model.CCTopologyEdge;
import com.sun.web.ui.model.CCTopologyIconSet;
import com.sun.web.ui.model.CCTopologyModelInterface;
import com.sun.web.ui.model.CCTopologyNode;
import com.sun.web.ui.servlet.topology.CCTopologyRenderer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class CCDefaultTopologyRenderer
implements CCTopologyRenderer {
    private static final int DEFAULT_ICON_SIZE = 8;
    private static final int EDGE_HOT_SPACE = 2;
    private static final int TEXT_HSPACE = 5;
    private static final int TEXT_VSPACE = 1;
    private static final int MIN_EDGE_LENGTH = 10;
    private static final int ARROW_SPACE = 7;
    private static final int NODE_SPACE = 5;
    private static final int EDGE_SPACE = 4;
    private static final int BADGE_OVERHANG = 3;
    private static final String TURNER_OPEN = "topologyTurnerOpen.gif";
    private static final String TURNER_CLOSED = "topologyTurnerClosed.gif";
    private static final String TURNER_CLOSED_WLINE = "topologyTurnerClosedWithLine.gif";
    private static final int TURNER_CENTER = 4;
    private static final int TURNER_NARROW = 5;
    private static final int TURNER_WIDE = 9;
    private static final int TURNER_HEIGHT = 13;
    private static final int PLURAL_IMAGE_COUNT = 3;
    private static final int PLURAL_IMAGE_OFFSET = 4;
    private static final int PLURAL_EXTRA = 8;
    private static final int GROUP_LINE_WIDTH = 1;
    private static final int GROUP_LINE_HEIGHT = 1;
    private static final int GROUP_LINE_SPACE = 5;
    private static final int GROUP_INDENT = 25;
    private static final int GROUP_BOX_WIDTH = 38;
    private static final int GROUP_BOX_HEIGHT = 32;
    private static final int NODE_EDGE_SPACE = 3;
    private static final Color BG_COLOR = Color.white;
    private static final Color FG_COLOR = Color.black;
    private static final Object NULL_SIZE = new Object();
    private static final Color GROUP_LINE_COLOR = new Color(204, 204, 204);
    private static final Color FILTER_COLOR = new Color(204, 204, 204);
    private static final Stroke STROKE_1PIXEL = new BasicStroke(1.0f);
    private static final Stroke STROKE_3PIXEL = new BasicStroke(3.0f, 0, 0);
    private static final Stroke STROKE_5PIXEL = new BasicStroke(5.0f, 0, 0);
    private final CCTopologyModelInterface model;
    private final Font font;
    private final FontRenderContext fontContext;
    private final CCI18N cci18n;
    private final CCI18N i18n;
    private DisplayModel displayModel;
    private Dimension size;
    private final Map pluralImages = new WeakHashMap();
    private final Map filteredImages = new WeakHashMap();
    private final Map badgeSizes = new HashMap();

    public CCDefaultTopologyRenderer(CCTopologyModelInterface model, CCI18N cci18n, CCI18N i18n, Font labelFont) {
        this.validateModel(model);
        this.model = model;
        this.cci18n = cci18n;
        this.i18n = i18n;
        this.font = labelFont != null ? labelFont : this.getDefaultLabelFont();
        BufferedImage image = new BufferedImage(1, 1, 9);
        Graphics2D g2 = image.createGraphics();
        g2.setFont(this.font);
        this.fontContext = g2.getFontRenderContext();
        g2.dispose();
        image.flush();
    }

    public static Image createPluralImage(Image image) {
        if (image == null) {
            return null;
        }
        int pluralSpace = 8;
        int width = image.getWidth(null) + pluralSpace;
        int height = image.getHeight(null) + pluralSpace;
        BufferedImage pluralImage = new BufferedImage(width, height, 9);
        Graphics2D graphics = pluralImage.createGraphics();
        graphics.setColor(BG_COLOR);
        graphics.fillRect(0, 0, width, height);
        int i = 0;
        int offset = 0;
        while (i < 3) {
            graphics.drawImage(image, offset, offset, BG_COLOR, null);
            ++i;
            offset += 4;
        }
        graphics.dispose();
        return pluralImage;
    }

    public static Image createFilteredImage(Image image) {
        if (image == null) {
            return null;
        }
        AlphaComposite filterOutComposite = AlphaComposite.getInstance(3, 0.2f);
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage filteredImage = new BufferedImage(width, height, 9);
        Graphics2D graphics = filteredImage.createGraphics();
        graphics.setColor(BG_COLOR);
        graphics.fillRect(0, 0, width, height);
        graphics.setComposite(filterOutComposite);
        graphics.drawImage(image, 0, 0, BG_COLOR, null);
        graphics.dispose();
        return filteredImage;
    }

    public final CCTopologyModelInterface getModel() {
        return this.model;
    }

    public final void renderModel() {
        this.layoutImage();
    }

    public Dimension getImageSize() {
        if (this.displayModel == null) {
            this.layoutImage();
        }
        return this.size;
    }

    public final BufferedImage getImage(Rectangle clipRegion) {
        if (this.displayModel == null) {
            this.layoutImage();
        }
        BufferedImage image = null;
        try {
            int width = clipRegion == null ? this.size.width : Math.min(this.size.width, clipRegion.width);
            int height = clipRegion == null ? this.size.height : Math.min(this.size.height, clipRegion.height);
            image = new BufferedImage(width, height, 9);
        }
        catch (OutOfMemoryError oome) {
            CCDebug.trace1("Could not create off-screen image", oome);
            return null;
        }
        Graphics2D graphics = image.createGraphics();
        if (clipRegion != null) {
            graphics.setTransform(AffineTransform.getTranslateInstance(-clipRegion.x, -clipRegion.y));
            graphics.clip(clipRegion);
        }
        try {
            this.drawTopology(graphics);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            CCDebug.trace1("Could not draw topology image", e);
        }
        graphics.dispose();
        return image;
    }

    public CCTopologyModelInterface.Node[] getDisplayedNodes() {
        if (this.displayModel == null) {
            this.layoutImage();
        }
        CCTopologyModelInterface.Node[] tier1Nodes = this.displayModel.getTierNodes(0);
        CCTopologyModelInterface.Node[] tier2Nodes = this.displayModel.getTierNodes(1);
        CCTopologyModelInterface.Node[] tier3Nodes = this.displayModel.getTierNodes(2);
        CCTopologyModelInterface.Node[] allNodes = new CCTopologyModelInterface.Node[tier1Nodes.length + tier2Nodes.length + tier3Nodes.length];
        System.arraycopy(tier1Nodes, 0, allNodes, 0, tier1Nodes.length);
        System.arraycopy(tier2Nodes, 0, allNodes, tier1Nodes.length, tier2Nodes.length);
        System.arraycopy(tier3Nodes, 0, allNodes, tier1Nodes.length + tier2Nodes.length, tier3Nodes.length);
        return allNodes;
    }

    public CCTopologyModelInterface.Edge[] getDisplayedEdges() {
        if (this.displayModel == null) {
            this.layoutImage();
        }
        Object[] edges = this.displayModel.getEdges();
        Arrays.sort(edges);
        return edges;
    }

    public Rectangle getIconArea(CCTopologyModelInterface.Node node, Rectangle clipRegion) {
        DisplayElement element;
        if (this.displayModel == null) {
            this.layoutImage();
        }
        Rectangle area = (element = this.displayModel.getDisplayElement(node)) instanceof DisplayNode ? ((DisplayNode)element).imageBounds : null;
        return this.clipArea(area, clipRegion);
    }

    public Rectangle getLabelArea(CCTopologyModelInterface.Node node, Rectangle clipRegion) {
        DisplayElement element;
        if (this.displayModel == null) {
            this.layoutImage();
        }
        Rectangle area = (element = this.displayModel.getDisplayElement(node)) instanceof DisplayNode ? ((DisplayNode)element).labelBounds : null;
        return this.clipArea(area, clipRegion);
    }

    public Polygon getEdgeArea(CCTopologyModelInterface.Edge edge, Rectangle clipRegion) {
        DisplayElement element;
        if (this.displayModel == null) {
            this.layoutImage();
        }
        Polygon area = (element = this.displayModel.getDisplayElement(edge)) instanceof DisplayEdge ? ((DisplayEdge)element).getArea() : null;
        return this.clipArea(area, clipRegion);
    }

    public Rectangle getBadgeArea(CCTopologyModelInterface.Node node, Rectangle clipRegion) {
        Dimension badgeSize;
        if (this.displayModel == null) {
            this.layoutImage();
        }
        if ((badgeSize = this.getBadgeSize(node.getBadge())) == null) {
            return null;
        }
        DisplayNode dNode = (DisplayNode)this.displayModel.getDisplayElement(node);
        return dNode == null ? null : this.clipArea(new Rectangle(dNode.imageBounds.x + dNode.imageBounds.width - badgeSize.width + 3, dNode.imageBounds.y + dNode.imageBounds.height - badgeSize.height + 3, badgeSize.width, badgeSize.height), clipRegion);
    }

    public Rectangle getBadgeArea(CCTopologyModelInterface.Edge edge, Rectangle clipRegion) {
        Dimension badgeSize;
        if (this.displayModel == null) {
            this.layoutImage();
        }
        if ((badgeSize = this.getBadgeSize(edge.getBadge())) != null) {
            DisplayEdge dEdge = (DisplayEdge)this.displayModel.getDisplayElement(edge);
            if (dEdge == null) {
                return null;
            }
            if (dEdge.getBadge() != 0) {
                Point badgePoint = dEdge.getPoints()[dEdge.badgePoint];
                int x = badgePoint.x - badgeSize.width / 2;
                int y = badgePoint.y - badgeSize.height / 2;
                return this.clipArea(new Rectangle(x, y, badgeSize.width, badgeSize.height), clipRegion);
            }
        }
        return null;
    }

    public Rectangle getTurnerArea(CCTopologyModelInterface.Node node, Rectangle clipRegion) {
        DisplayNode dNode;
        if (!(node instanceof CCTopologyModelInterface.GroupNode)) {
            return null;
        }
        if (this.displayModel == null) {
            this.layoutImage();
        }
        return (dNode = (DisplayNode)this.displayModel.getDisplayElement(node)) == null ? null : this.clipArea(new Rectangle(dNode.turnerPoint.x, dNode.turnerPoint.y, dNode.isExpanded ? 9 : 5, dNode.isExpanded ? 5 : 9), clipRegion);
    }

    public final Font getLabelFont() {
        return this.font;
    }

    public final Font getDefaultLabelFont() {
        return new Font("SansSerif", 10, 0).deriveFont(0, 10.0f);
    }

    private void validateModel(CCTopologyModelInterface model) {
        if (model == null) {
            throw new IllegalArgumentException("model == null");
        }
        int tierCount = model.getTierCount();
        if (tierCount < 1 || tierCount > 3) {
            throw new IllegalArgumentException("invalid model: tierCount not 1, 2 or 3");
        }
        CCTopologyModelInterface.Node[][] tierNodes = new CCTopologyModelInterface.Node[tierCount][0];
        for (int t = 0; t < tierCount; ++t) {
            tierNodes[t] = model.getTierNodes(t);
            if (tierNodes[t] == null) {
                throw new IllegalArgumentException("invalid model: getTierNodes(" + t + ") == null");
            }
            for (int n = 0; n < tierNodes[t].length; ++n) {
                if (tierNodes[t][n] == null) {
                    throw new IllegalArgumentException("invalid model: getTierNodes(" + t + ")[" + n + "] == null");
                }
                if (tierNodes[t][n].getLabel() != null) continue;
                throw new IllegalArgumentException("invalid model: getTierNodes(" + t + ")[" + n + "].getLabel() == null");
            }
        }
        CCTopologyModelInterface.Edge[] edges = model.getEdges();
        if (edges == null) {
            throw new IllegalArgumentException("invalid model: getEdges() == null");
        }
        for (int e = 0; e < edges.length; ++e) {
            if (edges[e] == null) {
                throw new IllegalArgumentException("invalid model: getEdges()[" + e + "] == null");
            }
            CCTopologyModelInterface.Node src = edges[e].getSource();
            CCTopologyModelInterface.Node dst = edges[e].getDestination();
            if (src == null) {
                throw new IllegalArgumentException("invalid model: getEdges()[" + e + "].getSource() == null");
            }
            if (dst == null) {
                throw new IllegalArgumentException("invalid model: getEdges()[" + e + "].getDestination() == null");
            }
            if (model.getNode(src.getId()) == null) {
                throw new IllegalArgumentException("invalid model: getNode(getEdges()[" + e + "].getSource().getId()) == null");
            }
            if (model.getNode(dst.getId()) != null) continue;
            throw new IllegalArgumentException("invalid model: getNode(getEdges()[" + e + "].getDestination().getId()) == null (label=" + dst.getLabel() + ")");
        }
    }

    private Dimension getBadgeSize(int badge) {
        Integer key = new Integer(badge);
        Object value = this.badgeSizes.get(key);
        CCTopologyModelInterface.BadgeSet badgeSet = this.model.getBadgeSet();
        if (value == null && badgeSet != null) {
            Image image = badgeSet.getImage(badge);
            value = image == null ? NULL_SIZE : new Dimension(image.getWidth(null), image.getHeight(null));
            this.badgeSizes.put(key, value);
        }
        return value instanceof Dimension ? (Dimension)value : null;
    }

    private Rectangle clipArea(Rectangle area, Rectangle clipRegion) {
        if (clipRegion == null) {
            return area;
        }
        if (area == null || !area.intersects(clipRegion)) {
            return null;
        }
        Rectangle intersection = clipRegion.intersection(area);
        intersection.translate(-clipRegion.x, -clipRegion.y);
        return intersection;
    }

    private Polygon clipArea(Polygon area, Rectangle clipRegion) {
        if (clipRegion == null) {
            return area;
        }
        if (area == null || !area.intersects(clipRegion)) {
            return null;
        }
        area.translate(-clipRegion.x, -clipRegion.y);
        return area;
    }

    private void layoutImage() {
        this.displayModel = new DisplayModel(this.model, this.cci18n, this.i18n);
        int tierCount = this.displayModel.getTierCount();
        this.size = tierCount == 1 && !this.displayModel.hasGroupNodes ? this.layoutDiagonally() : (tierCount > 0 && tierCount < 4 ? this.layoutOrthogonally() : new Dimension(1, 1));
    }

    private Dimension layoutDiagonally() {
        DisplayNode node;
        int t1;
        DisplayNode[] t1Nodes = (DisplayNode[])this.displayModel.getTierNodes(0);
        int t1Width = this.calculateSizes(t1Nodes, true);
        int minEdgeLength = Math.max(10, 4 + (this.displayModel.hasArrowheads ? 7 : 0) + (this.displayModel.hasEdgeBadges || this.displayModel.hasSelectableEdges || this.displayModel.hasGroupEdges ? 7 : 0));
        DisplayEdge[][] sortedEdges = new DisplayEdge[t1Nodes.length][];
        int edgeSortIndex = 1;
        boolean[] isSelfConnected = new boolean[t1Nodes.length];
        boolean selfConnectedNodes = false;
        for (int t12 = 0; t12 < t1Nodes.length; ++t12) {
            DisplayNode node2 = t1Nodes[t12];
            int edgeCount = node2.edges.size();
            sortedEdges[t12] = node2.edges.toArray(new DisplayEdge[edgeCount]);
            Arrays.sort(sortedEdges[t12], new DiagonalTierEdgeComparator(node2));
            for (int e = 0; e < sortedEdges[t12].length; ++e) {
                if (sortedEdges[t12][e].sortIndex != 0) continue;
                sortedEdges[t12][e].sortIndex = edgeSortIndex++;
            }
            for (int i = 0; i < edgeCount; ++i) {
                DisplayNode other = sortedEdges[t12][i].getOtherNode(node2);
                if (other.index == node2.index) {
                    selfConnectedNodes = true;
                    isSelfConnected[t12] = true;
                }
                if (other.index < node2.index) continue;
                node2.belowEdgeCount = edgeCount - i;
                break;
            }
            node2.aboveEdgeCount = edgeCount - node2.belowEdgeCount;
        }
        int edgeSpace = 4 + (selfConnectedNodes && this.displayModel.hasSelectableEdges || this.displayModel.hasEdgeBadges || this.displayModel.hasArrowheads || this.displayModel.hasGroupEdges ? 3 : 0);
        if (this.displayModel.hasGroupEdges || this.displayModel.hasEdgeBadges) {
            ++edgeSpace;
        }
        int nodeSpace = 5 + (this.displayModel.hasNodeBadges ? 3 : 0);
        int nodeEdgeSpace = 3 + (this.displayModel.hasNodeBadges ? 3 : 0);
        int minLabelX = 0;
        int imageWidth = 0;
        int imageHeight = 0;
        for (int i = 0; i < t1Nodes.length; ++i) {
            imageWidth = Math.max(imageWidth, t1Nodes[i].imageBounds.width);
            imageHeight = Math.max(imageHeight, t1Nodes[i].imageBounds.height);
        }
        int x = t1Nodes.length > 0 ? t1Nodes[0].labelBounds.width + 5 : 0;
        int y = 0;
        for (t1 = 0; t1 < t1Nodes.length; ++t1) {
            node = t1Nodes[t1];
            int width = Math.max(imageWidth, (node.aboveEdgeCount + 2) * edgeSpace);
            int height = Math.max(imageHeight, (node.belowEdgeCount + 2) * edgeSpace);
            node.imageBounds.setLocation(x + (width - imageWidth) / 2, y + (height - imageHeight) / 2);
            node.labelBounds.setLocation(node.imageBounds.x - 5 - node.labelBounds.width, node.imageBounds.y + node.imageBounds.height - node.labelBounds.height);
            minLabelX = Math.min(minLabelX, node.labelBounds.x);
            x += width + nodeSpace + (isSelfConnected[t1] ? minEdgeLength : 0);
            y += height + nodeSpace;
        }
        if (minLabelX < 0) {
            for (t1 = 0; t1 < t1Nodes.length; ++t1) {
                node = t1Nodes[t1];
                node.labelBounds.x -= minLabelX;
                node.imageBounds.x -= minLabelX;
            }
            x -= minLabelX;
        }
        int totalWidth = x - 5;
        int totalHeight = y - 5;
        boolean lastNodeIsSelfConnected = false;
        for (int t13 = 0; t13 < t1Nodes.length; ++t13) {
            int e;
            DisplayNode node3 = t1Nodes[t13];
            DisplayEdge[] edges = sortedEdges[t13];
            x = node3.imageBounds.x + (node3.imageBounds.width - (node3.aboveEdgeCount - 1) * edgeSpace) / 2;
            y = node3.imageBounds.y - 3;
            for (e = 0; e < node3.aboveEdgeCount; ++e) {
                if (node3 == edges[e].displaySource) {
                    edges[e].sourcePoint = new Point(x, y);
                } else {
                    edges[e].destinationPoint = new Point(x, y);
                }
                x += edgeSpace;
            }
            x = Math.max(x, node3.imageBounds.x + node3.imageBounds.width + nodeEdgeSpace);
            y = node3.imageBounds.y + (node3.imageBounds.height + (node3.belowEdgeCount - 1) * edgeSpace) / 2;
            while (e < edges.length) {
                if (node3 == edges[e].displaySource) {
                    if (node3 == edges[e].displayDestination) {
                        edges[e].sourcePoint = new Point(x, y);
                        edges[e].destinationPoint = new Point(x, y -= edgeSpace);
                        edges[e].offset = minEdgeLength;
                        ++e;
                        if (t13 == t1Nodes.length - 1) {
                            lastNodeIsSelfConnected = true;
                        }
                    } else {
                        edges[e].sourcePoint = new Point(x, y);
                    }
                } else {
                    edges[e].destinationPoint = new Point(x, y);
                }
                y -= edgeSpace;
                ++e;
            }
        }
        if (lastNodeIsSelfConnected) {
            totalWidth += nodeEdgeSpace + minEdgeLength + 3;
        }
        return new Dimension(totalWidth, totalHeight);
    }

    private Dimension layoutOrthogonally() {
        int t2vOffset;
        int o;
        int indent;
        int n;
        int e;
        int e2;
        int n2;
        int n3;
        int indent2;
        boolean textAbove;
        DisplayNode[] t1Nodes = (DisplayNode[])this.displayModel.getTierNodes(0);
        DisplayNode[] t2Nodes = (DisplayNode[])this.displayModel.getTierNodes(1);
        DisplayNode[] t3Nodes = (DisplayNode[])this.displayModel.getTierNodes(2);
        int t1Width = this.calculateSizes(t1Nodes, true);
        int t2Height = this.calculateSizes(t2Nodes, false);
        int t3Width = this.calculateSizes(t3Nodes, true);
        int maxWidth = Math.max(t1Width, t3Width);
        boolean bl = textAbove = t1Nodes.length == 0;
        if (!textAbove && this.displayModel.hasGroupNodes) {
            for (int n4 = 0; n4 < t2Nodes.length; ++n4) {
                if (!t2Nodes[n4].isGroup) continue;
                textAbove = true;
                break;
            }
        }
        boolean selfConnectedNodes = false;
        DisplayEdge[][][] sortedEdges = new DisplayEdge[3][][];
        int edgeSortIndex = 1;
        for (int t = 0; t < 3; ++t) {
            DisplayNode[] nodes = t == 0 ? t1Nodes : (t == 1 ? t2Nodes : t3Nodes);
            sortedEdges[t] = new DisplayEdge[nodes.length][];
            for (int n5 = 0; n5 < nodes.length; ++n5) {
                int e3;
                DisplayNode node = nodes[n5];
                int edgeCount = node.edges.size();
                sortedEdges[t][n5] = node.edges.toArray(new DisplayEdge[edgeCount]);
                if (t == 0 || t == 1 && textAbove) {
                    Arrays.sort(sortedEdges[t][n5], new TierOneEdgeComparator(node));
                } else {
                    Arrays.sort(sortedEdges[t][n5], new TierThreeEdgeComparator(node));
                }
                for (e3 = 0; e3 < sortedEdges[t][n5].length; ++e3) {
                    if (sortedEdges[t][n5][e3].sortIndex != 0) continue;
                    sortedEdges[t][n5][e3].sortIndex = edgeSortIndex++;
                }
                block0 : switch (t) {
                    case 0: {
                        node.belowEdgeCount = edgeCount;
                        break;
                    }
                    case 2: {
                        node.belowEdgeCount = 0;
                        break;
                    }
                    case 1: {
                        DisplayNode other;
                        int i;
                        if (textAbove) {
                            for (i = 0; i < edgeCount; ++i) {
                                other = sortedEdges[t][n5][i].getOtherNode(node);
                                if (other.tier < node.tier) continue;
                                node.belowEdgeCount = edgeCount - i;
                                break block0;
                            }
                        } else {
                            for (i = 0; i < edgeCount; ++i) {
                                other = sortedEdges[t][n5][i].getOtherNode(node);
                                if (other.tier <= node.tier) continue;
                                node.belowEdgeCount = edgeCount - i;
                                break block0;
                            }
                        }
                        break;
                    }
                }
                node.aboveEdgeCount = edgeCount - node.belowEdgeCount;
                for (e3 = 0; e3 < sortedEdges[t][n5].length; ++e3) {
                    if (sortedEdges[t][n5][e3].displaySource != sortedEdges[t][n5][e3].displayDestination) continue;
                    selfConnectedNodes = true;
                }
            }
        }
        int edgeSpace = 4 + (selfConnectedNodes && this.displayModel.hasSelectableEdges || this.displayModel.hasEdgeBadges || this.displayModel.hasArrowheads || this.displayModel.hasGroupEdges ? 3 : 0);
        int nodeSpace = 5 + (this.displayModel.hasNodeBadges ? 3 : 0);
        int nodeEdgeSpace = this.displayModel.hasNodeBadges ? 6 : 3;
        int minEdgeLength = Math.max(10, 4 + (this.displayModel.hasArrowheads ? 7 : 0) + (this.displayModel.hasEdgeBadges || this.displayModel.hasSelectableEdges ? 7 : 0));
        boolean turnersUsed = false;
        int imageWidth = 0;
        int imageHeight = 0;
        for (int i = 0; i < t1Nodes.length; ++i) {
            imageWidth = Math.max(imageWidth, t1Nodes[i].imageBounds.width);
        }
        int x = maxWidth - imageWidth;
        int y = this.displayModel.hasEdgeBadges ? 3 : 0;
        int maxIndentH = 0;
        DisplayNode[] nestNodes = new DisplayNode[Math.max(t1Nodes.length, Math.max(t2Nodes.length, t3Nodes.length))];
        for (int t1 = 0; t1 < t1Nodes.length; ++t1) {
            int nextNesting;
            DisplayNode node = t1Nodes[t1];
            boolean isExpandedGroup = node.isGroup && node.isExpanded;
            imageHeight = isExpandedGroup ? Math.max(13, node.labelBounds.height) : node.imageBounds.height;
            int height = Math.max(imageHeight, node.belowEdgeCount * edgeSpace + minEdgeLength - nodeSpace);
            int leftX = x;
            int indent3 = node.nesting * 25;
            maxIndentH = Math.max(maxIndentH, indent3);
            if (!isExpandedGroup) {
                node.imageBounds.setLocation(x + indent3, y + (height - imageHeight) / 2);
            }
            if (node.isGroup) {
                turnersUsed = true;
                leftX = x - 5 - 5;
                node.turnerPoint = new Point(leftX + indent3, y + (height - 9) / 2);
            }
            node.labelBounds.setLocation(leftX + indent3 - 5 - node.labelBounds.width, y + (height - node.labelBounds.height) / 2);
            y += height;
            int n6 = nextNesting = t1 == t1Nodes.length - 1 ? 0 : t1Nodes[t1 + 1].nesting;
            if (nextNesting > node.nesting) {
                nestNodes[node.nesting] = node;
            } else if (nextNesting < node.nesting) {
                for (int n7 = node.nesting - 1; n7 >= nextNesting; --n7) {
                    nestNodes[n7].groupLineLength = (y += 5) - nestNodes[n7].turnerPoint.y;
                }
            }
            y += nodeSpace;
        }
        imageWidth = 0;
        imageHeight = 0;
        for (int i = 0; i < t2Nodes.length; ++i) {
            imageHeight = Math.max(imageHeight, t2Nodes[i].imageBounds.height);
        }
        x = maxWidth + nodeEdgeSpace + minEdgeLength;
        int maxIndentV = 0;
        if (t1Nodes.length > 0) {
            y = y - nodeSpace + minEdgeLength;
        }
        int textHeight = 0;
        for (int i = 0; i < t2Nodes.length; ++i) {
            textHeight = Math.max(textHeight, t2Nodes[i].labelBounds.height);
        }
        int imageY = textAbove ? y + (--textHeight - 1) + 1 : y;
        int textY = y;
        if (!textAbove) {
            textY += imageHeight + 1;
            if (this.displayModel.hasNodeBadges) {
                textY += 3;
            }
        }
        boolean prevIsExpandedGroup = false;
        for (int t2 = 0; t2 < t2Nodes.length; ++t2) {
            int nextNesting;
            DisplayNode lastNode;
            DisplayNode node = t2Nodes[t2];
            boolean isExpandedGroup = node.isGroup && node.isExpanded;
            int n8 = imageWidth = isExpandedGroup ? 0 : node.imageBounds.width;
            int turnerWidth = node.isGroup ? (node.isExpanded ? 9 : 5) + 5 : 0;
            int width = Math.max(Math.max(node.aboveEdgeCount, node.belowEdgeCount) * edgeSpace + minEdgeLength - nodeSpace, Math.max(turnerWidth + imageWidth, node.labelBounds.width));
            indent2 = node.nesting * 25;
            maxIndentV = Math.max(maxIndentV, indent2);
            int turnerImageX = x + (width - imageWidth - turnerWidth) / 2;
            if (node.isGroup) {
                node.turnerPoint = new Point(turnerImageX, imageY + indent2 + 1);
            }
            if (!isExpandedGroup) {
                node.imageBounds.setLocation(turnerImageX + turnerWidth, imageY + indent2);
                node.labelBounds.setLocation(node.imageBounds.x + (node.imageBounds.width - node.labelBounds.width) / 2, textY + indent2);
            } else {
                node.labelBounds.setLocation(x + (width - node.labelBounds.width) / 2, textY + indent2);
            }
            int leftShift = 0;
            if (t2 == 0 && isExpandedGroup) {
                leftShift = Math.min(x, width + nodeSpace);
            } else if (prevIsExpandedGroup) {
                int topEdgesWidth;
                lastNode = t2Nodes[t2 - 1];
                int nodeLeft = node.labelBounds.x;
                if (node.imageBounds.x > 0) {
                    nodeLeft = Math.min(nodeLeft, node.imageBounds.x);
                }
                if (turnerImageX != 0) {
                    nodeLeft = Math.min(nodeLeft, turnerImageX);
                }
                int edgesLeft = (topEdgesWidth = node.aboveEdgeCount * edgeSpace) > 0 ? nodeLeft + (width - topEdgesWidth) / 2 : nodeLeft + width;
                leftShift = Math.min(nodeLeft - lastNode.turnerPoint.x + 9, edgesLeft - (lastNode.labelBounds.x + lastNode.labelBounds.width)) - nodeSpace - 5;
            }
            if (leftShift > 0) {
                if (prevIsExpandedGroup && !isExpandedGroup && t2 == 1) {
                    lastNode = t2Nodes[t2 - 1];
                    lastNode.labelBounds.x += leftShift;
                    lastNode.turnerPoint.x += leftShift;
                } else {
                    node.labelBounds.x -= leftShift;
                    if (node.imageBounds.x > 0) {
                        node.imageBounds.x -= leftShift;
                    }
                    if (node.turnerPoint != null) {
                        node.turnerPoint.x -= leftShift;
                    }
                    x -= leftShift;
                }
            }
            prevIsExpandedGroup = isExpandedGroup;
            x += width;
            int n9 = nextNesting = t2 == t2Nodes.length - 1 ? 0 : t2Nodes[t2 + 1].nesting;
            if (nextNesting > node.nesting) {
                nestNodes[node.nesting] = node;
            } else if (nextNesting < node.nesting) {
                for (n3 = node.nesting - 1; n3 >= nextNesting; --n3) {
                    nestNodes[n3].groupLineLength = (x += 5) - nestNodes[n3].turnerPoint.x;
                }
            }
            x += nodeSpace;
        }
        int totalWidth = x - 5 + (this.displayModel.hasEdgeBadges ? 3 : 0);
        y += imageHeight + 1 + textHeight + minEdgeLength + maxIndentV;
        imageWidth = 0;
        imageHeight = 0;
        for (int i = 0; i < t3Nodes.length; ++i) {
            imageWidth = Math.max(imageWidth, t3Nodes[i].imageBounds.width);
        }
        x = maxWidth - imageWidth;
        for (int t3 = 0; t3 < t3Nodes.length; ++t3) {
            int nextNesting;
            DisplayNode node = t3Nodes[t3];
            boolean isExpandedGroup = node.isGroup && node.isExpanded;
            imageHeight = isExpandedGroup ? Math.max(13, node.labelBounds.height) : node.imageBounds.height;
            int height = Math.max(imageHeight, node.aboveEdgeCount * edgeSpace + minEdgeLength - nodeSpace);
            indent2 = node.nesting * 25;
            maxIndentH = Math.max(maxIndentH, indent2);
            if (!isExpandedGroup) {
                node.imageBounds.setLocation(x + indent2, y + (height - imageHeight) / 2);
            }
            int leftX = x;
            if (node.isGroup) {
                turnersUsed = true;
                leftX = x - 5 - 5;
                node.turnerPoint = new Point(leftX + indent2, y + (height - 9) / 2);
            }
            node.labelBounds.setLocation(leftX + indent2 - 5 - node.labelBounds.width, y + (height - node.labelBounds.height) / 2);
            y += height;
            int n10 = nextNesting = t3 == t3Nodes.length - 1 ? 0 : t3Nodes[t3 + 1].nesting;
            if (nextNesting > node.nesting) {
                nestNodes[node.nesting] = node;
            } else if (nextNesting < node.nesting) {
                for (int n11 = node.nesting - 1; n11 >= nextNesting; --n11) {
                    nestNodes[n11].groupLineLength = (y += 5) - nestNodes[n11].turnerPoint.y;
                }
            }
            y += nodeSpace;
        }
        int totalHeight = t3Nodes.length == 0 ? y + 1 : y - 5 + (this.displayModel.hasEdgeBadges ? 3 : 0);
        for (n2 = 0; n2 < t1Nodes.length; ++n2) {
            int ee;
            DisplayNode node = t1Nodes[n2];
            DisplayEdge[] edges = sortedEdges[0][n2];
            x = node.imageBounds.x + node.imageBounds.width + nodeEdgeSpace;
            y = node.imageBounds.y + (node.imageBounds.height + (node.belowEdgeCount - 1) * edgeSpace) / 2;
            for (ee = 0; ee < edges.length && node == edges[ee].displaySource && node == edges[ee].displayDestination; ee += 2) {
                edges[ee].sourcePoint = new Point(x, y);
                edges[ee].destinationPoint = new Point(x, y -= edgeSpace);
                y -= edgeSpace;
                edges[ee].offset = minEdgeLength;
            }
            for (e2 = edges.length - 1; e2 >= ee; --e2) {
                if (node == edges[e2].displaySource) {
                    edges[e2].sourcePoint = new Point(x, y);
                } else {
                    edges[e2].destinationPoint = new Point(x, y);
                }
                y -= edgeSpace;
            }
        }
        for (n2 = 0; n2 < t2Nodes.length; ++n2) {
            DisplayNode node = t2Nodes[n2];
            DisplayEdge[] edges = sortedEdges[1][n2];
            x = node.imageBounds.x + (node.imageBounds.width - (node.aboveEdgeCount - 1) * edgeSpace) / 2;
            y = Math.min(node.imageBounds.y, node.labelBounds.y) - 3 - 1;
            for (e = 0; e < node.aboveEdgeCount; ++e) {
                if (node == edges[e].displaySource) {
                    if (node == edges[e].displayDestination) {
                        edges[e].destinationPoint = new Point(x, y);
                        edges[e].sourcePoint = new Point(x += edgeSpace, y);
                        edges[e].offset = minEdgeLength;
                        ++e;
                    } else {
                        edges[e].sourcePoint = new Point(x, y);
                    }
                } else {
                    edges[e].destinationPoint = new Point(x, y);
                }
                x += edgeSpace;
            }
            x = node.imageBounds.x + (node.imageBounds.width - (node.belowEdgeCount - 1) * edgeSpace) / 2;
            y = Math.max(node.imageBounds.y + node.imageBounds.height + nodeEdgeSpace, node.labelBounds.y + node.labelBounds.height + 3);
            if (!textAbove) {
                y -= 2;
            }
            while (e < edges.length) {
                if (node == edges[e].displaySource) {
                    if (node == edges[e].displayDestination) {
                        edges[e].destinationPoint = new Point(x, y);
                        edges[e].sourcePoint = new Point(x += edgeSpace, y);
                        edges[e].offset = minEdgeLength;
                        ++e;
                    } else {
                        edges[e].sourcePoint = new Point(x, y);
                    }
                } else {
                    edges[e].destinationPoint = new Point(x, y);
                }
                x += edgeSpace;
                ++e;
            }
        }
        for (n2 = 0; n2 < t3Nodes.length; ++n2) {
            DisplayNode node = t3Nodes[n2];
            DisplayEdge[] edges = sortedEdges[2][n2];
            x = node.imageBounds.x + node.imageBounds.width + nodeEdgeSpace;
            y = node.imageBounds.y + (node.imageBounds.height + (node.aboveEdgeCount - 1) * edgeSpace) / 2;
            for (e = edges.length - 1; e >= 0; --e) {
                if (node == edges[e].displaySource) {
                    if (node == edges[e].displayDestination) {
                        edges[e].sourcePoint = new Point(x, y);
                        edges[e].destinationPoint = new Point(x, y -= edgeSpace);
                        edges[e].offset = minEdgeLength;
                        --e;
                    } else {
                        edges[e].sourcePoint = new Point(x, y);
                    }
                } else {
                    edges[e].destinationPoint = new Point(x, y);
                }
                y -= edgeSpace;
            }
        }
        int[][] offsets = new int[3][];
        int[][] indents = new int[3][];
        offsets[0] = new int[t1Nodes.length];
        indents[0] = new int[t1Nodes.length];
        offsets[1] = new int[t2Nodes.length];
        indents[1] = new int[t2Nodes.length];
        offsets[2] = new int[t3Nodes.length];
        indents[2] = new int[t3Nodes.length];
        int lastIndent = 0;
        if (t1Nodes.length > 0) {
            lastIndent = t1Nodes[0].imageBounds.x + t1Nodes[0].imageBounds.width;
            for (n = 0; n < offsets[0].length - 1; ++n) {
                indent = t1Nodes[n + 1].imageBounds.x + t1Nodes[n + 1].imageBounds.width;
                indents[0][n] = Math.max(lastIndent, indent);
                offsets[0][n] = minEdgeLength + indents[0][n];
                lastIndent = indent;
            }
        }
        if (t2Nodes.length > 0) {
            lastIndent = t2Nodes[0].imageBounds.y + t2Nodes[0].imageBounds.height;
            for (n = 0; n < offsets[1].length - 1; ++n) {
                indent = t2Nodes[n + 1].imageBounds.y + t2Nodes[n + 1].imageBounds.height;
                indents[1][n] = Math.max(lastIndent, indent);
                offsets[1][n] = minEdgeLength + indents[1][n];
                lastIndent = indent;
            }
        }
        if (t3Nodes.length > 0) {
            lastIndent = t3Nodes[0].imageBounds.x + t3Nodes[0].imageBounds.width;
            for (n = 0; n < offsets[2].length - 1; ++n) {
                indent = t3Nodes[n + 1].imageBounds.x + t3Nodes[n + 1].imageBounds.width;
                indents[2][n] = Math.max(lastIndent, indent);
                offsets[2][n] = minEdgeLength + indents[2][n];
                lastIndent = indent;
            }
        }
        DisplayEdge[] edges = (DisplayEdge[])this.displayModel.getEdges();
        Arrays.sort(edges, new WithinTierEdgeComparator());
        for (e2 = 0; e2 < edges.length; ++e2) {
            int i;
            edges[e2].invalidateLayout();
            if (WithinTierEdgeComparator.getEdgeLength(edges[e2]) == Integer.MAX_VALUE) break;
            int tier = edges[e2].displaySource.tier;
            int minNode = edges[e2].displaySource.index;
            int maxNode = edges[e2].displayDestination.index;
            if (minNode > maxNode) {
                minNode = maxNode;
                maxNode = edges[e2].displaySource.index;
            }
            int sourceIndent = edges[e2].displaySource.tier == 1 ? edges[e2].displaySource.imageBounds.y + edges[e2].displaySource.imageBounds.height : edges[e2].displaySource.imageBounds.x + edges[e2].displaySource.imageBounds.width;
            int offset = 0;
            if (minNode == maxNode) {
                offset = minEdgeLength + sourceIndent;
            } else {
                for (i = minNode; i < maxNode; ++i) {
                    offset = Math.max(offset, offsets[tier][i]);
                }
                offset += edgeSpace;
            }
            edges[e2].offset = tier == 1 && !textAbove ? -(offset - sourceIndent) : offset - sourceIndent;
            if (minNode == maxNode) {
                offsets[tier][minNode] = Math.max(offsets[tier][minNode], offset);
                continue;
            }
            for (i = minNode; i < maxNode; ++i) {
                offsets[tier][i] = offset;
            }
        }
        int hOffset = 0;
        int vOffset = 0;
        for (o = 0; o < offsets[0].length - 1; ++o) {
            hOffset = Math.max(hOffset, offsets[0][o] - indents[0][o]);
        }
        for (o = 0; o < offsets[1].length - 1; ++o) {
            vOffset = Math.max(vOffset, offsets[1][o] - indents[1][o]);
        }
        for (o = 0; o < offsets[2].length - 1; ++o) {
            hOffset = Math.max(hOffset, offsets[2][o] - indents[2][o]);
        }
        int n12 = t2vOffset = textAbove ? 0 : vOffset;
        if ((hOffset += maxIndentH) > 0 || t2vOffset > 0) {
            for (n3 = 0; n3 < t2Nodes.length; ++n3) {
                t2Nodes[n3].imageBounds.translate(hOffset, t2vOffset);
                t2Nodes[n3].labelBounds.translate(hOffset, t2vOffset);
                if (t2Nodes[n3].turnerPoint == null) continue;
                t2Nodes[n3].turnerPoint.translate(hOffset, t2vOffset);
            }
        }
        if (vOffset > 0) {
            for (n3 = 0; n3 < t3Nodes.length; ++n3) {
                t3Nodes[n3].imageBounds.translate(0, vOffset);
                t3Nodes[n3].labelBounds.translate(0, vOffset);
                if (t3Nodes[n3].turnerPoint == null) continue;
                t3Nodes[n3].turnerPoint.translate(0, vOffset);
            }
        }
        if (vOffset > 0 || hOffset > 0) {
            block51: for (int e4 = 0; e4 < edges.length; ++e4) {
                switch (edges[e4].displaySource.tier) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        edges[e4].sourcePoint.translate(hOffset, t2vOffset);
                        break;
                    }
                    case 2: {
                        edges[e4].sourcePoint.translate(0, vOffset);
                    }
                }
                switch (edges[e4].displayDestination.tier) {
                    case 0: {
                        continue block51;
                    }
                    case 1: {
                        edges[e4].destinationPoint.translate(hOffset, t2vOffset);
                        continue block51;
                    }
                    case 2: {
                        edges[e4].destinationPoint.translate(0, vOffset);
                    }
                }
            }
        }
        int font_workaround = 4;
        return new Dimension(totalWidth + hOffset + 1 + font_workaround, totalHeight + vOffset + font_workaround);
    }

    private int calculateSizes(DisplayNode[] nodes, boolean vertical) {
        int maxSize = 0;
        boolean addTurnerSpace = false;
        for (int i = 0; i < nodes.length; ++i) {
            int size;
            String label;
            int imageHeight;
            DisplayNode node = nodes[i];
            Image image = this.getIconImage(node.getIcon());
            int pluralExtra = node.usesPluralIcon ? 8 : 0;
            int imageWidth = image == null ? -1 : image.getWidth(null) + pluralExtra;
            int n = imageHeight = image == null ? -1 : image.getHeight(null) + pluralExtra;
            if (imageWidth == -1) {
                imageWidth = 8;
            }
            if (imageHeight == -1) {
                imageHeight = 8;
            }
            node.labelBounds = this.font.getStringBounds((label = node.getLabel()) != null ? label : " ", this.fontContext).getBounds();
            ++node.labelBounds.width;
            node.imageBounds = new Rectangle(0, 0, imageWidth, imageHeight);
            int n2 = size = vertical ? node.labelBounds.width + imageWidth : node.labelBounds.height + imageHeight;
            if (vertical && node.isGroup) {
                addTurnerSpace = true;
            }
            maxSize = Math.max(maxSize, size);
        }
        if (addTurnerSpace) {
            maxSize += 10;
        }
        return maxSize + (vertical ? 5 : 1);
    }

    private void drawTopology(Graphics2D graphics) {
        int e;
        graphics.setFont(this.getLabelFont());
        graphics.setColor(BG_COLOR);
        graphics.fillRect(0, 0, this.size.width, this.size.height);
        graphics.setColor(FG_COLOR);
        for (int t = 0; t < this.displayModel.getTierCount(); ++t) {
            DisplayNode[] nodes = (DisplayNode[])this.displayModel.getTierNodes(t);
            for (int n = 0; n < nodes.length; ++n) {
                this.drawNode(graphics, nodes[n], this.displayModel.hasGroupNodes);
            }
        }
        DisplayEdge[] edges = (DisplayEdge[])this.displayModel.getEdges();
        for (e = 0; e < edges.length; ++e) {
            if (edges[e].isInFilter()) continue;
            this.drawEdgeLines(graphics, edges[e]);
        }
        for (e = 0; e < edges.length; ++e) {
            if (edges[e].isInFilter()) continue;
            this.drawEdgeAdornments(graphics, edges[e]);
        }
        for (e = 0; e < edges.length; ++e) {
            if (!edges[e].isInFilter()) continue;
            this.drawEdgeLines(graphics, edges[e]);
        }
        for (e = 0; e < edges.length; ++e) {
            if (!edges[e].isInFilter()) continue;
            this.drawEdgeAdornments(graphics, edges[e]);
        }
    }

    private void drawNode(Graphics2D graphics, DisplayNode node, boolean hasGroups) {
        int ascent = graphics.getFontMetrics().getAscent();
        graphics.setColor(node.isInFilter() ? FG_COLOR : FILTER_COLOR);
        graphics.setStroke(STROKE_1PIXEL);
        graphics.drawString(node.getLabel(), node.labelBounds.x, node.labelBounds.y + ascent);
        if (node.isGroup) {
            String turnerImageFile;
            Image turnerImage;
            if (node.isExpanded) {
                int top;
                int left;
                if (node.tier == 1) {
                    left = node.turnerPoint.x + 4;
                    top = node.turnerPoint.y + 4;
                    int right = left + node.groupLineLength;
                    int bottom = top + 32;
                    graphics.setColor(BG_COLOR);
                    graphics.fillRect(left, top, right - left, bottom - top);
                    graphics.setColor(GROUP_LINE_COLOR);
                    graphics.fillRect(left, top, 1, bottom - top);
                    graphics.fillRect(left, bottom, right - left, 1);
                    graphics.fillRect(right - 1, top, 1, bottom - top);
                    graphics.fillRect(right - 5, top, 5, 1);
                } else {
                    left = node.turnerPoint.x + 4;
                    top = node.turnerPoint.y + 4;
                    int right = left + 38 + (node.imageBounds.width - (node.usesPluralIcon ? 8 : 0)) / 2;
                    int bottom = top + node.groupLineLength;
                    graphics.setColor(BG_COLOR);
                    graphics.fillRect(left, top, right - left, bottom - top);
                    graphics.setColor(GROUP_LINE_COLOR);
                    graphics.fillRect(left, top, right - left, 1);
                    graphics.fillRect(right - 1, top, 1, bottom - top);
                    graphics.fillRect(left, bottom, right - left, 1);
                    graphics.fillRect(left, bottom - 5, 1, 5);
                }
            }
            if ((turnerImage = CCTopologyIconSet.ImageLoader.getCachedImage(CCDefaultTopologyRenderer.class, turnerImageFile = node.isExpanded ? TURNER_OPEN : (node.nesting == 0 && node.tier == 1 ? TURNER_CLOSED_WLINE : TURNER_CLOSED))) != null) {
                graphics.drawImage(turnerImage, node.turnerPoint.x, node.turnerPoint.y, null);
            }
        }
        if (!node.isGroup || !node.isExpanded) {
            Image nodeImage = this.getIconImage(node.getIcon());
            if (node.usesPluralIcon) {
                nodeImage = this.getPluralImage(nodeImage);
            }
            if (!node.isInFilter()) {
                nodeImage = this.getFilteredImage(nodeImage);
            }
            if (nodeImage == null) {
                return;
            }
            graphics.drawImage(nodeImage, node.imageBounds.x, node.imageBounds.y, null);
            Image badgeImage = this.getBadgeImage(node.getBadge());
            if (badgeImage == null) {
                return;
            }
            if (!node.isInFilter()) {
                badgeImage = this.getFilteredImage(badgeImage);
            }
            graphics.drawImage(badgeImage, (int)node.imageBounds.getMaxX() + 3 - badgeImage.getWidth(null), (int)node.imageBounds.getMaxY() + 3 - badgeImage.getHeight(null), null);
        }
    }

    private final Image getIconImage(int icon) {
        CCTopologyModelInterface.IconSet iconSet = this.model.getIconSet();
        return iconSet == null ? null : iconSet.getImage(icon);
    }

    private final Image getBadgeImage(int badge) {
        CCTopologyModelInterface.BadgeSet badgeSet = this.model.getBadgeSet();
        return badgeSet == null ? null : badgeSet.getImage(badge);
    }

    private final Color getBadgeColor(int badge) {
        CCTopologyModelInterface.BadgeSet badgeSet = this.model.getBadgeSet();
        return badgeSet == null ? null : badgeSet.getColor(badge);
    }

    private Image getPluralImage(Image image) {
        if (image == null) {
            return null;
        }
        Image pluralImage = (Image)this.pluralImages.get(image);
        if (pluralImage == null) {
            pluralImage = CCDefaultTopologyRenderer.createPluralImage(image);
            this.pluralImages.put(image, pluralImage);
        }
        return pluralImage;
    }

    private Image getFilteredImage(Image image) {
        if (image == null) {
            return null;
        }
        Image filteredImage = (Image)this.filteredImages.get(image);
        if (filteredImage == null) {
            filteredImage = CCDefaultTopologyRenderer.createFilteredImage(image);
            this.filteredImages.put(image, filteredImage);
        }
        return filteredImage;
    }

    private void drawEdgeLines(Graphics2D graphics, DisplayEdge edge) {
        Color edgeColor;
        Point[] points = edge.getPoints();
        int length = points.length;
        if (length < 2) {
            return;
        }
        int[] xCoords = new int[length + 1];
        int[] yCoords = new int[length + 1];
        for (int i = 0; i < length; ++i) {
            xCoords[i] = points[i].x;
            yCoords[i] = points[i].y;
        }
        xCoords[length] = xCoords[length - 2];
        yCoords[length] = yCoords[length - 2];
        graphics.setColor(BG_COLOR);
        graphics.setStroke(edge.isGroup ? STROKE_5PIXEL : STROKE_3PIXEL);
        graphics.drawPolyline(xCoords, yCoords, length);
        Color color = edgeColor = !edge.isInFilter() ? FILTER_COLOR : this.getBadgeColor(edge.getBadge());
        if (edgeColor == null || edgeColor.equals(BG_COLOR)) {
            edgeColor = FG_COLOR;
        }
        graphics.setColor(edgeColor);
        if (edge.isGroup) {
            graphics.setStroke(STROKE_3PIXEL);
            graphics.drawPolyline(xCoords, yCoords, length);
            graphics.setColor(BG_COLOR);
        }
        graphics.setStroke(STROKE_1PIXEL);
        graphics.drawPolyline(xCoords, yCoords, length);
    }

    private void drawEdgeAdornments(Graphics2D graphics, DisplayEdge edge) {
        Color edgeColor;
        Point[] points = edge.getPoints();
        boolean inFilter = edge.isInFilter();
        boolean isSelfEdge = edge.displaySource == edge.displayDestination;
        Image badgeImage = this.getBadgeImage(edge.getBadge());
        if (!edge.isInFilter()) {
            badgeImage = this.getFilteredImage(badgeImage);
        }
        Color color = edgeColor = !inFilter ? FILTER_COLOR : this.getBadgeColor(edge.getBadge());
        if (edgeColor == null) {
            edgeColor = FG_COLOR;
        }
        graphics.setColor(edgeColor);
        boolean clickable = edge.getAction() == Integer.MIN_VALUE ? this.model.getActionSet() instanceof CCDefaultActionSet : edge.getAction() != 0;
        for (int p = 1; p < points.length - 1; ++p) {
            int x = points[p].x;
            int y = points[p].y;
            if (badgeImage != null && p == edge.badgePoint) {
                graphics.drawImage(badgeImage, x - badgeImage.getWidth(null) / 2, y - badgeImage.getHeight(null) / 2, null);
                continue;
            }
            if (!inFilter || isSelfEdge && p != edge.badgePoint) continue;
            if (clickable) {
                int drawSouth = 0;
                int drawEast = 0;
                if (y == points[p - 1].y) {
                    drawSouth = y < points[p + 1].y ? 1 : -1;
                    drawEast = x < points[p - 1].x ? 1 : -1;
                } else {
                    drawSouth = y < points[p - 1].y ? 1 : -1;
                    drawEast = x < points[p + 1].x ? 1 : -1;
                }
                int wide = edge.isGroup ? 1 : 0;
                int[] xCoords = new int[7];
                int[] yCoords = new int[7];
                int i = 0;
                xCoords[i] = x -= drawEast;
                yCoords[i++] = y -= drawSouth;
                xCoords[i] = x += drawEast * (8 + wide);
                yCoords[i++] = y;
                xCoords[i] = x;
                yCoords[i++] = y += drawSouth * (2 + wide);
                xCoords[i] = x -= drawEast * 3;
                yCoords[i++] = y;
                xCoords[i] = x -= drawEast * 3;
                yCoords[i++] = y += drawSouth * 3;
                xCoords[i] = x;
                yCoords[i++] = y += drawSouth * 3;
                xCoords[i] = x -= drawEast * (2 + wide);
                yCoords[i++] = y;
                graphics.fillPolygon(xCoords, yCoords, 7);
                graphics.drawPolygon(xCoords, yCoords, 7);
                continue;
            }
            if (edge.isGroup) continue;
            graphics.fillRect(points[p].x - 1, points[p].y - 1, 3, 3);
        }
        if (edge.isDirected() && points.length > 1) {
            this.drawArrowhead(graphics, points[points.length - 2], points[points.length - 1], edge.isGroup);
            if (edge.isBidirectional()) {
                this.drawArrowhead(graphics, points[1], points[0], edge.isGroup);
            }
        }
    }

    private void drawArrowhead(Graphics2D graphics, Point src, Point dst, boolean clearTip) {
        if (clearTip) {
            Color fg = graphics.getColor();
            graphics.setColor(BG_COLOR);
            graphics.fillRect(dst.x - 2, dst.y - 2, 5, 5);
            graphics.setColor(fg);
        }
        graphics.fillRect(dst.x, dst.y, 1, 1);
        if (src.y == dst.y) {
            int drawWest = src.x > dst.x ? 1 : -1;
            int x = drawWest > 0 ? 0 : -1;
            graphics.fillRect(dst.x + x, dst.y, 2, 1);
            graphics.fillRect(dst.x + x + 2 * drawWest, dst.y - 1, 2, 3);
            graphics.fillRect(dst.x + x + 4 * drawWest, dst.y - 2, 2, 5);
        } else {
            int drawNorth = src.y > dst.y ? 1 : -1;
            int y = drawNorth > 0 ? 0 : -1;
            graphics.fillRect(dst.x, dst.y + y, 1, 2);
            graphics.fillRect(dst.x - 1, dst.y + y + 2 * drawNorth, 3, 2);
            graphics.fillRect(dst.x - 2, dst.y + y + 4 * drawNorth, 5, 2);
        }
    }

    private static class WithinTierEdgeComparator
    implements Comparator {
        private WithinTierEdgeComparator() {
        }

        public int compare(Object o1, Object o2) {
            DisplayEdge edge1 = null;
            DisplayEdge edge2 = null;
            try {
                edge1 = (DisplayEdge)o1;
                edge2 = (DisplayEdge)o2;
            }
            catch (ClassCastException cce) {
                return 0;
            }
            int length1 = WithinTierEdgeComparator.getEdgeLength(edge1);
            int length2 = WithinTierEdgeComparator.getEdgeLength(edge2);
            return length1 != length2 ? length1 - length2 : (edge1.displaySource.index != edge2.displaySource.index ? edge1.displaySource.index - edge2.displaySource.index : (edge1.displayDestination.index != edge2.displayDestination.index ? edge1.displayDestination.index - edge2.displayDestination.index : edge1.getId().compareTo(edge2.getId())));
        }

        public static int getEdgeLength(DisplayEdge edge) {
            if (edge.displaySource.tier != edge.displayDestination.tier) {
                return Integer.MAX_VALUE;
            }
            return edge.displaySource.tier == 1 ? Math.abs(edge.sourcePoint.x - edge.destinationPoint.x) : Math.abs(edge.sourcePoint.y - edge.destinationPoint.y);
        }
    }

    private static class TierThreeEdgeComparator
    implements Comparator {
        public static final int LEFT = 0;
        public static final int ABOVE = 1;
        public static final int RIGHT = 2;
        public static final int BELOW = 3;
        private DisplayNode node;

        public TierThreeEdgeComparator(DisplayNode node) {
            this.node = node;
        }

        public int compare(Object o1, Object o2) {
            int delta;
            int position2;
            if (!(o1 instanceof DisplayEdge) || !(o2 instanceof DisplayEdge)) {
                return 0;
            }
            DisplayEdge edge1 = (DisplayEdge)o1;
            DisplayEdge edge2 = (DisplayEdge)o2;
            DisplayNode node1 = edge1.getOtherNode(this.node);
            DisplayNode node2 = edge2.getOtherNode(this.node);
            if (node1 == null || node2 == null) {
                return node1 == null ? (node2 == null ? 0 : -1) : 1;
            }
            int position1 = this.getPosition(node1);
            if (position1 != (position2 = this.getPosition(node2))) {
                return position1 - position2;
            }
            int n = delta = position1 == 0 || position1 == 2 ? node2.index - node1.index : node1.index - node2.index;
            if (delta == 0) {
                delta = position1 == 0 || position1 == 1 && this.node.tier == 1 ? edge2.getId().compareTo(edge1.getId()) : edge1.getId().compareTo(edge2.getId());
            }
            return delta;
        }

        public int getPosition(DisplayNode other) {
            if (other.tier == this.node.tier) {
                return other.index < this.node.index ? 0 : 2;
            }
            return other.tier < this.node.tier ? 1 : 3;
        }
    }

    private static class TierOneEdgeComparator
    implements Comparator {
        public static final int ABOVE = 0;
        public static final int LEFT = 1;
        public static final int BELOW = 2;
        public static final int RIGHT = 3;
        private DisplayNode node;

        public TierOneEdgeComparator(DisplayNode node) {
            this.node = node;
        }

        public int compare(Object o1, Object o2) {
            int delta;
            int position2;
            if (!(o1 instanceof DisplayEdge) || !(o2 instanceof DisplayEdge)) {
                return 0;
            }
            DisplayEdge edge1 = (DisplayEdge)o1;
            DisplayEdge edge2 = (DisplayEdge)o2;
            DisplayNode node1 = edge1.getOtherNode(this.node);
            DisplayNode node2 = edge2.getOtherNode(this.node);
            if (node1 == null || node2 == null) {
                return node1 == null ? (node2 == null ? 0 : -1) : 1;
            }
            int position1 = this.getPosition(node1);
            if (position1 != (position2 = this.getPosition(node2))) {
                return this.node.tier == 1 ? position1 - position2 : position2 - position1;
            }
            int n = delta = position1 == 1 || position1 == 3 ? node1.index - node2.index : node2.index - node1.index;
            if (this.node.tier == 1) {
                delta = -delta;
            }
            if (delta == 0) {
                delta = position1 == 1 || position1 == 0 ? edge2.getId().compareTo(edge1.getId()) : edge1.getId().compareTo(edge2.getId());
            }
            return delta;
        }

        public int getPosition(DisplayNode other) {
            if (other.tier == this.node.tier) {
                return other.index < this.node.index ? 1 : 3;
            }
            return other.tier < this.node.tier ? 0 : 2;
        }
    }

    private static final class DiagonalTierEdgeComparator
    implements Comparator {
        private DisplayNode node;

        public DiagonalTierEdgeComparator(DisplayNode node) {
            this.node = node;
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof DisplayEdge) || !(o2 instanceof DisplayEdge)) {
                return 0;
            }
            DisplayNode node1 = ((DisplayEdge)o1).getOtherNode(this.node);
            DisplayNode node2 = ((DisplayEdge)o2).getOtherNode(this.node);
            int delta = node1.index - node2.index;
            if (delta == 0) {
                delta = node1.getId().compareTo(node2.getId());
            }
            if (node1.index < this.node.index && node2.index < this.node.index && node1.index != node2.index) {
                delta = -delta;
            }
            return delta;
        }
    }

    private static final class DisplayModel
    implements CCTopologyModelInterface {
        public boolean hasNodeBadges;
        public boolean hasEdgeBadges;
        public boolean hasArrowheads;
        public boolean hasSelectableEdges;
        public boolean hasGroupNodes;
        public boolean hasGroupEdges;
        private final int tierCount;
        private final DisplayNode[][] displayNodes;
        private final DisplayEdge[] displayEdges;
        private final Map elementMap = new HashMap();

        DisplayModel(CCTopologyModelInterface model, CCI18N cci18n, CCI18N i18n) {
            int t;
            CCTopologyModelInterface.Node[][] tierNodes = new CCTopologyModelInterface.Node[3][];
            int tierCount = model.getTierCount();
            for (t = 0; t < tierCount; ++t) {
                tierNodes[t] = model.getTierNodes(t);
            }
            if (tierCount == 2) {
                tierCount = 3;
                tierNodes[2] = tierNodes[1];
                tierNodes[1] = tierNodes[0];
                tierNodes[0] = new DisplayNode[0];
            }
            this.tierCount = tierCount;
            this.displayNodes = new DisplayNode[tierCount][];
            for (t = 0; t < tierCount; ++t) {
                ArrayList nodeList = new ArrayList();
                this.createDisplayNodes(nodeList, tierNodes[t], 0, cci18n, i18n, model.getBadgeSet());
                this.displayNodes[t] = nodeList.toArray(new DisplayNode[nodeList.size()]);
                boolean reverseOrder = tierCount != 1 && t == 0;
                for (int n = 0; n < this.displayNodes[t].length; ++n) {
                    this.displayNodes[t][n].tier = t;
                    this.displayNodes[t][n].i18n = i18n;
                    this.displayNodes[t][n].index = reverseOrder ? this.displayNodes[t].length - 1 - n : n;
                }
            }
            this.displayEdges = this.createDisplayEdges(model.getEdges(), cci18n, i18n, model.getBadgeSet());
            for (int e = 0; e < this.displayEdges.length; ++e) {
                this.displayEdges[e].displaySource.edges.add(this.displayEdges[e]);
                this.displayEdges[e].displayDestination.edges.add(this.displayEdges[e]);
                if (!this.hasEdgeBadges && this.displayEdges[e].getBadge() != 0) {
                    this.hasEdgeBadges = true;
                }
                if (!this.hasArrowheads && this.displayEdges[e].isDirected()) {
                    this.hasArrowheads = true;
                }
                if (!this.hasGroupEdges && this.displayEdges[e].isGroup) {
                    this.hasGroupEdges = true;
                }
                if (this.hasSelectableEdges || this.displayEdges[e].getAction() == 0) continue;
                this.hasSelectableEdges = true;
            }
        }

        public int getTierCount() {
            return this.tierCount;
        }

        public CCTopologyModelInterface.Node[] getTierNodes(int tier) {
            return tier >= 0 && tier < this.tierCount ? this.displayNodes[tier] : new CCTopologyModelInterface.Node[]{};
        }

        public CCTopologyModelInterface.Edge[] getEdges() {
            return this.displayEdges;
        }

        public CCTopologyModelInterface.IconSet getIconSet() {
            return null;
        }

        public CCTopologyModelInterface.BadgeSet getBadgeSet() {
            return null;
        }

        public CCTopologyModelInterface.ActionSet getActionSet() {
            return null;
        }

        public CCTopologyModelInterface.Node getNode(String nodeId) {
            return null;
        }

        public CCTopologyModelInterface.Edge getEdge(String edgeId) {
            return null;
        }

        public String getName() {
            return null;
        }

        public Object getValue(String name) {
            return null;
        }

        public Object[] getValues(String name) {
            return null;
        }

        public void setName(String name) {
        }

        public void setValue(String name, Object value) {
        }

        public void setValues(String name, Object[] values) {
        }

        public DisplayElement getDisplayElement(Object element) {
            return element == null ? null : (element instanceof DisplayElement ? (DisplayElement)element : (DisplayElement)this.elementMap.get(element));
        }

        private int createDisplayNodes(List list, CCTopologyModelInterface.Node[] nodes, int nesting, CCI18N cci18n, CCI18N i18n, CCTopologyModelInterface.BadgeSet badgeSet) {
            if (nodes == null) {
                return 0;
            }
            int totalChildCount = 0;
            for (int n = 0; n < nodes.length; ++n) {
                DisplayNode dNode = null;
                dNode = nodes[n] instanceof CCTopologyModelInterface.GroupNode ? new DisplayGroupNode((CCTopologyModelInterface.GroupNode)nodes[n], nesting, cci18n, i18n, badgeSet) : new DisplayNode(nodes[n], nesting, i18n, badgeSet);
                list.add(dNode);
                this.elementMap.put(nodes[n], dNode);
                if (!this.hasNodeBadges && dNode.getBadge() != 0) {
                    this.hasNodeBadges = true;
                }
                if (!this.hasGroupNodes && dNode.isGroup) {
                    this.hasGroupNodes = true;
                }
                if (dNode.isExpanded) {
                    dNode.childCount = this.createDisplayNodes(list, dNode.nodes, nesting + 1, cci18n, i18n, badgeSet);
                    totalChildCount += dNode.childCount;
                    continue;
                }
                if (dNode.isGroup) {
                    dNode.childCount = this.setDisplayNode(nodes[n], dNode);
                    totalChildCount += dNode.childCount;
                    continue;
                }
                ++totalChildCount;
            }
            return totalChildCount;
        }

        private int setDisplayNode(CCTopologyModelInterface.Node node, DisplayNode displayNode) {
            this.elementMap.put(node, displayNode);
            int nodeCount = 1;
            if (node instanceof CCTopologyModelInterface.GroupNode) {
                CCTopologyModelInterface.GroupNode groupNode = (CCTopologyModelInterface.GroupNode)node;
                CCTopologyModelInterface.Node[] nodes = groupNode.getNodes();
                for (int n = 0; n < nodes.length; ++n) {
                    nodeCount += this.setDisplayNode(nodes[n], displayNode);
                }
                if (groupNode.usesSubnodeRollup()) {
                    --nodeCount;
                }
            }
            return nodeCount;
        }

        private DisplayNode getDisplayNode(CCTopologyModelInterface.Node node) {
            try {
                return (DisplayNode)this.elementMap.get(node);
            }
            catch (Exception e) {
                return null;
            }
        }

        private DisplayEdge[] createDisplayEdges(CCTopologyModelInterface.Edge[] edges, CCI18N cci18n, CCI18N i18n, CCTopologyModelInterface.BadgeSet badgeSet) {
            ArrayList<DisplayEdge> edgeList = new ArrayList<DisplayEdge>();
            for (int e = 0; e < edges.length; ++e) {
                DisplayEdge dEdge;
                boolean isGroup;
                CCTopologyModelInterface.Node srcNode = edges[e].getSource();
                CCTopologyModelInterface.Node destNode = edges[e].getDestination();
                DisplayNode srcDNode = this.getDisplayNode(srcNode);
                DisplayNode destDNode = this.getDisplayNode(destNode);
                if (srcDNode == null || destDNode == null) continue;
                boolean bl = isGroup = !srcNode.getId().equals(srcDNode.getId()) || !destNode.getId().equals(destDNode.getId());
                if (isGroup) {
                    if (srcDNode == destDNode) continue;
                    dEdge = srcDNode.getDisplayEdge(destDNode);
                    if (dEdge == null) {
                        dEdge = new DisplayEdge(edges[e], cci18n, i18n, srcDNode, destDNode, true);
                        edgeList.add(dEdge);
                        this.elementMap.put(edges[e], dEdge);
                        continue;
                    }
                    dEdge.addEdge(edges[e], srcDNode, destDNode, badgeSet);
                    continue;
                }
                dEdge = new DisplayEdge(edges[e], null, i18n, srcDNode, destDNode, false);
                edgeList.add(dEdge);
                this.elementMap.put(edges[e], dEdge);
            }
            return edgeList.toArray(new DisplayEdge[edgeList.size()]);
        }
    }

    private static final class DisplayEdge
    extends CCTopologyEdge
    implements DisplayElement,
    Comparable {
        public DisplayNode displaySource;
        public DisplayNode displayDestination;
        public boolean isGroup;
        public Point sourcePoint;
        public Point destinationPoint;
        public int badgePoint = -1;
        public int offset;
        private Point[] points;
        private Polygon area;
        private final CCI18N cci18n;
        private final CCI18N i18n;
        public int edgeCount = 1;
        public int sortIndex;

        DisplayEdge(CCTopologyModelInterface.Edge edge, CCI18N cci18n, CCI18N i18n, DisplayNode source, DisplayNode destination, boolean isGroup) {
            super(isGroup ? source.getId() + "^cc^" + destination.getId() : edge.getId(), source, destination, isGroup ? "topology.group.edge" : edge.getTooltip(), isGroup ? -2147483647 : edge.getAction(), edge.isInFilter(), edge.getBadge(), edge.getBadgeTooltip(), isGroup ? -2147483646 : edge.getBadgeAction(), edge.isDirected(), edge.isBidirectional());
            this.displaySource = source;
            this.displayDestination = destination;
            this.i18n = i18n;
            this.cci18n = cci18n;
            this.isGroup = isGroup;
            source.addDisplayEdge(destination, this);
        }

        public String getTooltip() {
            return this.localizeTooltip(super.getTooltip());
        }

        public String getBadgeTooltip() {
            return this.localizeTooltip(super.getBadgeTooltip());
        }

        private String localizeTooltip(String tooltipKey) {
            String tooltip = null;
            if (tooltipKey != null) {
                boolean edgeBadgeOpenTip;
                boolean edgeOpenTip = tooltipKey == "topology.group.edge";
                boolean bl = edgeBadgeOpenTip = tooltipKey == "topology.group.edge.badge";
                if (this.i18n != null) {
                    tooltip = edgeOpenTip ? this.i18n.getMessage(tooltipKey, new String[]{String.valueOf(this.edgeCount)}) : this.i18n.getMessage(tooltipKey);
                }
                if ((edgeOpenTip || edgeBadgeOpenTip) && tooltip.equals(tooltipKey) && this.cci18n != null) {
                    tooltip = this.cci18n.getMessage(tooltipKey, new String[]{String.valueOf(this.edgeCount)});
                }
            }
            return tooltip;
        }

        public void addEdge(CCTopologyModelInterface.Edge newEdge, DisplayNode newEdgeSource, DisplayNode newEdgeDestination, CCTopologyModelInterface.BadgeSet badgeSet) {
            ++this.edgeCount;
            this.inFilter |= newEdge.isInFilter();
            if (badgeSet != null) {
                int newBadge = badgeSet.getCombinedBadge(this.badge, newEdge.getBadge());
                if (newBadge != this.badge) {
                    this.badgeTooltip = newEdge.getBadgeTooltip();
                }
                this.badge = newBadge;
            }
            if (newEdgeSource != newEdgeDestination && !this.bidirectional && newEdge.isDirected()) {
                if (newEdge.isBidirectional()) {
                    this.directed = true;
                    this.bidirectional = true;
                } else if (newEdgeSource == this.getSource()) {
                    this.directed = true;
                } else if (this.directed) {
                    this.bidirectional = true;
                } else {
                    DisplayNode aNode = this.displaySource;
                    this.displaySource = this.displayDestination;
                    this.source = this.displaySource;
                    this.displayDestination = aNode;
                    this.destination = this.displayDestination;
                    this.directed = true;
                }
            }
        }

        public Polygon getArea() {
            if (this.area != null) {
                return this.area;
            }
            this.getPoints();
            int xOffset = this.points[0].x < this.points[2].x ? 2 : -2;
            int yOffset = this.points[0].y < this.points[2].y ? 2 : -2;
            this.area = new Polygon();
            if (this.points[0].y == this.points[1].y) {
                int x = this.points[0].x;
                int y = this.points[0].y - yOffset;
                this.area.addPoint(x, y);
                x = this.points[1].x + xOffset;
                this.area.addPoint(x, y);
                if (this.points.length == 3) {
                    y = this.points[2].y;
                    this.area.addPoint(x, y);
                } else {
                    y = this.points[2].y + yOffset;
                    this.area.addPoint(x, y);
                    x = this.points[3].x;
                    this.area.addPoint(x, y);
                    y = this.points[3].y - yOffset;
                    this.area.addPoint(x, y);
                }
                x = this.points[2].x - xOffset;
                this.area.addPoint(x, y);
                y = this.points[1].y + yOffset;
                this.area.addPoint(x, y);
                x = this.points[0].x;
                this.area.addPoint(x, y);
            } else {
                int x = this.points[0].x + xOffset;
                int y = this.points[0].y;
                this.area.addPoint(x, y);
                y = this.points[1].y - yOffset;
                this.area.addPoint(x, y);
                if (this.points.length == 3) {
                    x = this.points[2].x;
                    this.area.addPoint(x, y);
                } else {
                    x = this.points[2].x - xOffset;
                    this.area.addPoint(x, y);
                    y = this.points[3].y;
                    this.area.addPoint(x, y);
                    x = this.points[2].x + xOffset;
                    this.area.addPoint(x, y);
                }
                y = this.points[2].y + yOffset;
                this.area.addPoint(x, y);
                x = this.points[1].x - xOffset;
                this.area.addPoint(x, y);
                y = this.points[0].y;
                this.area.addPoint(x, y);
            }
            return this.area;
        }

        public DisplayNode getOtherNode(DisplayNode node) {
            return node == this.displaySource ? this.displayDestination : this.displaySource;
        }

        public void invalidateLayout() {
            this.points = null;
            this.area = null;
        }

        public Point[] getPoints() {
            if (this.sourcePoint == null || this.destinationPoint == null) {
                return new Point[0];
            }
            if (this.points != null) {
                return this.points;
            }
            if (this.offset == 0) {
                this.points = new Point[]{this.sourcePoint, this.sourcePoint.x < this.destinationPoint.x ? new Point(this.destinationPoint.x, this.sourcePoint.y) : new Point(this.sourcePoint.x, this.destinationPoint.y), this.destinationPoint};
                this.badgePoint = 1;
            } else {
                boolean vertical;
                boolean bl = vertical = this.displaySource.tier != 1;
                if (vertical) {
                    Point[] pointArray;
                    Point s = this.sourcePoint.y < this.destinationPoint.y ? this.sourcePoint : this.destinationPoint;
                    Point d = s == this.sourcePoint ? this.destinationPoint : this.sourcePoint;
                    int offsetX = this.sourcePoint.x + this.offset;
                    Point p2 = new Point(offsetX, s.y);
                    Point p3 = new Point(offsetX, d.y);
                    if (s == this.sourcePoint) {
                        Point[] pointArray2 = new Point[4];
                        pointArray2[0] = s;
                        pointArray2[1] = p2;
                        pointArray2[2] = p3;
                        pointArray = pointArray2;
                        pointArray2[3] = d;
                    } else {
                        Point[] pointArray3 = new Point[4];
                        pointArray3[0] = d;
                        pointArray3[1] = p3;
                        pointArray3[2] = p2;
                        pointArray = pointArray3;
                        pointArray3[3] = s;
                    }
                    this.points = pointArray;
                    this.badgePoint = this.points[1].y < this.points[2].y ? 1 : 2;
                } else {
                    Point[] pointArray;
                    Point s = this.sourcePoint.x < this.destinationPoint.x ? this.sourcePoint : this.destinationPoint;
                    Point d = s == this.sourcePoint ? this.destinationPoint : this.sourcePoint;
                    int offsetY = this.sourcePoint.y + this.offset;
                    Point p2 = new Point(s.x, offsetY);
                    Point p3 = new Point(d.x, offsetY);
                    if (s == this.sourcePoint) {
                        Point[] pointArray4 = new Point[4];
                        pointArray4[0] = s;
                        pointArray4[1] = p2;
                        pointArray4[2] = p3;
                        pointArray = pointArray4;
                        pointArray4[3] = d;
                    } else {
                        Point[] pointArray5 = new Point[4];
                        pointArray5[0] = d;
                        pointArray5[1] = p3;
                        pointArray5[2] = p2;
                        pointArray = pointArray5;
                        pointArray5[3] = s;
                    }
                    this.points = pointArray;
                    this.badgePoint = this.points[1].x < this.points[2].x ? 1 : 2;
                }
            }
            return this.points;
        }

        public int compareTo(Object o) {
            try {
                return this.sortIndex - ((DisplayEdge)o).sortIndex;
            }
            catch (ClassCastException cce) {
                return 0;
            }
        }
    }

    private static class DisplayNode
    implements DisplayElement,
    CCTopologyModelInterface.Node {
        public final CCTopologyModelInterface.Node node;
        public CCI18N i18n;
        public int tier;
        public int index;
        public Rectangle imageBounds;
        public Rectangle labelBounds;
        public Point turnerPoint;
        public Collection edges = new ArrayList();
        public int aboveEdgeCount;
        public int belowEdgeCount;
        public int nesting;
        public int groupLineLength;
        public int badge;
        public int childCount;
        public String tooltip;
        public boolean isGroup;
        public boolean isExpanded;
        public boolean usesPluralIcon;
        public CCTopologyModelInterface.Node[] nodes;
        private Map displayEdges = new HashMap();

        DisplayNode(CCTopologyModelInterface.Node node, int nesting, CCI18N i18n, CCTopologyModelInterface.BadgeSet badgeSet) {
            this.node = node;
            this.nesting = nesting;
            if (node instanceof CCTopologyModelInterface.GroupNode) {
                CCTopologyModelInterface.GroupNode gNode = (CCTopologyModelInterface.GroupNode)node;
                this.isGroup = true;
                this.isExpanded = gNode.isExpanded();
                this.usesPluralIcon = gNode.usesPluralIcon();
                this.nodes = gNode.getNodes();
                this.badge = DisplayNode.getGroupBadge(gNode, badgeSet);
                this.tooltip = DisplayNode.getGroupTooltip(gNode, i18n);
            } else {
                this.badge = node.getBadge();
            }
        }

        public String getId() {
            return this.node.getId();
        }

        public String getLabel() {
            String label = this.i18n == null ? this.node.getLabel() : this.i18n.getMessage(this.node.getLabel());
            return this.isGroup ? label + " (" + this.childCount + ')' : label;
        }

        public String getTooltip() {
            if (this.tooltip != null) {
                return this.tooltip;
            }
            String tip = this.node.getTooltip();
            return this.i18n == null || tip == null ? tip : this.i18n.getMessage(tip);
        }

        public int getAction() {
            return this.node.getAction();
        }

        public boolean isInFilter() {
            return this.node.isInFilter();
        }

        public int getBadge() {
            return this.badge;
        }

        public String getBadgeTooltip() {
            String tooltip = this.node.getBadgeTooltip();
            return this.i18n == null || tooltip == null ? tooltip : this.i18n.getMessage(tooltip);
        }

        public int getBadgeAction() {
            return this.node.getBadgeAction();
        }

        public int getIcon() {
            return this.node.getIcon();
        }

        public void addDisplayEdge(DisplayNode otherNode, DisplayEdge edge) {
            this.displayEdges.put(otherNode, edge);
        }

        private DisplayEdge getDisplayEdge(DisplayNode otherNode) {
            DisplayEdge edge = (DisplayEdge)this.displayEdges.get(otherNode);
            if (edge == null) {
                edge = (DisplayEdge)otherNode.displayEdges.get(this);
            }
            return edge;
        }

        public static String getGroupTooltip(CCTopologyModelInterface.GroupNode node, CCI18N i18n) {
            String tooltip = node.getTooltip();
            CCTopologyModelInterface.Node[] nodes = node.getNodes();
            if (tooltip == null && node.usesSubnodeRollup() && nodes != null) {
                NonSyncStringBuffer buf = new NonSyncStringBuffer();
                for (int n = 0; n < nodes.length; ++n) {
                    if (n > 0) {
                        buf.append(", ");
                    }
                    String label = nodes[n].getLabel();
                    buf.append(i18n == null || label == null ? label : i18n.getMessage(label));
                }
                tooltip = buf.toString();
            }
            return tooltip;
        }

        public static int getGroupBadge(CCTopologyModelInterface.GroupNode node, CCTopologyModelInterface.BadgeSet badgeSet) {
            int badge = node.getBadge();
            if (badgeSet != null && badge == 0 && node.usesSubnodeRollup()) {
                CCTopologyModelInterface.Node[] nodes = node.getNodes();
                for (int n = 0; n < nodes.length; ++n) {
                    int nBadge = nodes[n] instanceof CCTopologyModelInterface.GroupNode ? DisplayNode.getGroupBadge((CCTopologyModelInterface.GroupNode)nodes[n], badgeSet) : nodes[n].getBadge();
                    badge = badgeSet.getCombinedBadge(badge, nBadge);
                }
            }
            if (node instanceof CCTopologyNode) {
                ((CCTopologyNode)((Object)node)).setBadge(badge);
            }
            return badge;
        }
    }

    private static final class DisplayGroupNode
    extends DisplayNode
    implements CCTopologyModelInterface.GroupNode {
        private final CCI18N cci18n;

        public DisplayGroupNode(CCTopologyModelInterface.GroupNode node, int nesting, CCI18N cci18n, CCI18N i18n, CCTopologyModelInterface.BadgeSet badgeSet) {
            super(node, nesting, i18n, badgeSet);
            this.cci18n = cci18n;
        }

        public CCTopologyModelInterface.Node[] getNodes() {
            return this.nodes != null ? this.nodes : new CCTopologyModelInterface.Node[]{};
        }

        public String getBadgeTooltip() {
            String badgeText = null;
            if (this.usesSubnodeRollup() && this.getBadge() != 0) {
                String tooltipKey = "topology.group.node.badge";
                if (this.i18n != null) {
                    this.tooltip = this.i18n.getMessage(tooltipKey);
                }
                if (this.tooltip.equals(tooltipKey) && this.cci18n != null) {
                    this.tooltip = this.cci18n.getMessage(tooltipKey);
                }
                if (!this.tooltip.equals(tooltipKey)) {
                    badgeText = ", " + this.tooltip;
                }
            }
            return badgeText != null ? super.getBadgeTooltip() : super.getBadgeTooltip() + badgeText;
        }

        public int getBadgeAction() {
            int badgeAction = this.node.getBadgeAction();
            if (this.usesSubnodeRollup() && this.getBadge() != 0) {
                badgeAction = -2147483645;
            }
            return badgeAction;
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public void setExpanded(boolean expanded) {
            this.isExpanded = expanded;
        }

        public boolean usesPluralIcon() {
            return this.usesPluralIcon;
        }

        public boolean usesSubnodeRollup() {
            return ((CCTopologyModelInterface.GroupNode)this.node).usesSubnodeRollup();
        }
    }

    private static interface DisplayElement {
        public String getId();

        public String getTooltip();

        public int getAction();

        public boolean isInFilter();

        public int getBadge();

        public String getBadgeTooltip();

        public int getBadgeAction();
    }
}

