/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.topology;

import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.model.CCContextualMenuModelInterface;
import com.sun.web.ui.model.CCDefaultActionSet;
import com.sun.web.ui.model.CCTopologyModelInterface;
import com.sun.web.ui.servlet.common.TagsServletBase;
import com.sun.web.ui.servlet.topology.CCDefaultTopologyRenderer;
import com.sun.web.ui.servlet.topology.CCSessionImageCache;
import com.sun.web.ui.servlet.topology.CCTopologyImageData;
import com.sun.web.ui.servlet.topology.CCTopologyRenderer;
import com.sun.web.ui.taglib.common.CCTagBase;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

public final class CCTopologyServlet
extends TagsServletBase {
    private static final String MENU_PREFIX = "window.CCMenu";
    private static final String IMAGE_ID_PARAM = "image";
    private static final int DEFAULT_MAX_IMAGE_SIZE = 1000000;
    private static final String DEFAULT_IMAGE_FORMAT = "png";
    public static final String ID_PARAM = "cctopologyid";
    public static final String ACTION_PARAM = "cctopologyaction";
    public static final String TURNER_OPEN_ACTION = "cctrno";
    public static final String TURNER_CLOSE_ACTION = "cctrnc";
    public static final String GROUP_NODE_BADGE_CLICKED = "ccGnodb";
    public static final String GROUP_EDGE_CLICKED = "ccGedg";
    public static final String GROUP_EDGE_BADGE_CLICKED = "ccGedgb";
    public static final String GROUP_EDGE_ID_SEPARATOR = "^cc^";
    static final int GROUP_EDGE_DEFAULT = -2147483647;
    static final int GROUP_EDGE_BADGE_DEFAULT = -2147483646;
    static final int GROUP_NODE_BADGE_DEFAULT = -2147483645;
    public static final String TURNER_OPEN_TOOLTIP = "topology.turner.open";
    public static final String TURNER_CLOSE_TOOLTIP = "topology.turner.close";
    public static final String GROUP_EDGE_TOOLTIP = "topology.group.edge";
    public static final String GROUP_NODE_BADGE_TOOLTIP = "topology.group.node.badge";
    public static final String GROUP_EDGE_BADGE_TOOLTIP = "topology.group.edge.badge";
    public static final String IMG_ALT_ATTR_TEXT = "topology.img.alt.att.text";

    public static String getTopologyImageTags(PageContext pageContext, String servletURI, String form, CCI18N modelI18N, CCTopologyModelInterface model, boolean isNav4, boolean isIE, String tabIndex) {
        if (model == null) {
            throw new IllegalArgumentException("model == null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext == null");
        }
        CCI18N servletI18N = new CCI18N(pageContext.getRequest(), pageContext.getResponse(), "com.sun.web.ui.resources.Resources", "com.sun.web.ui", null);
        return CCTopologyServlet.getTopologyImageTags(pageContext.getSession(), servletURI, form, new CCDefaultTopologyRenderer(model, servletI18N, modelI18N, null), modelI18N, servletI18N, 1000000, DEFAULT_IMAGE_FORMAT, isNav4, isIE, tabIndex);
    }

    public static String getTopologyImageTags(HttpSession session, String servletURI, String form, CCTopologyRenderer renderer, CCI18N modelI18N, CCI18N servletI18N, int maxImageArea, String imageFormat, boolean isNav4, boolean isIE, String tabIndex) {
        if (session == null) {
            throw new IllegalArgumentException("session == null");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("renderer == null");
        }
        maxImageArea = maxImageArea == 0 ? 1000000 : Math.max(maxImageArea, 10000);
        if (!CCTopologyServlet.isValidImageFormat(imageFormat)) {
            imageFormat = DEFAULT_IMAGE_FORMAT;
        }
        int columns = 1;
        int rows = 1;
        Rectangle size = new Rectangle(renderer.getImageSize());
        int cells = size.width * size.height / maxImageArea + 1;
        if (cells > 1) {
            double cols = Math.sqrt((double)cells * size.getWidth() / size.getHeight());
            columns = (int)Math.ceil(cols);
            rows = (int)Math.ceil((double)cells / cols);
        }
        int columnWidth = size.width / columns + 1;
        int rowHeight = size.height / rows + 1;
        String[][] ids = new String[rows][columns];
        Rectangle[][] areas = new Rectangle[rows][columns];
        CCSessionImageCache imageCache = CCSessionImageCache.getInstance(session);
        NonSyncStringBuffer tags = new NonSyncStringBuffer();
        tags.append("\n<input type=\"hidden\" name=\"cctopologyid\"/>");
        tags.append("<input type=\"hidden\" name=\"cctopologyaction\"/>\n");
        tags.append("\n<table cellpadding=\"0\" cellspacing=\"0\"");
        tags.append(" border=\"0\">\n");
        String altText = CCTopologyServlet.localize(modelI18N, servletI18N, IMG_ALT_ATTR_TEXT);
        for (int r = 0; r < rows; ++r) {
            tags.append("  <tr>\n");
            for (int c = 0; c < columns; ++c) {
                areas[r][c] = size.intersection(new Rectangle(c * columnWidth, r * rowHeight, columnWidth, rowHeight));
                ids[r][c] = imageCache.cacheImage(renderer, areas[r][c], imageFormat);
                tags.append("    <td><img src=\"").append(servletURI).append('?').append(IMAGE_ID_PARAM).append('=').append(ids[r][c]).append("\" width=\"").append(areas[r][c].width).append("\" height=\"").append(areas[r][c].height).append("\" usemap=\"#").append(ids[r][c]).append("\" border=\"0\"").append(" alt=\"" + altText + "\">").append("</img></td>\n");
            }
            tags.append("</tr>\n");
        }
        tags.append("</table>\n");
        tags.append("<script type=\"text/javascript\" ");
        tags.append("language=\"JavaScript1.2\">\n<!--\n");
        tags.append("function onLoad() {\n");
        CCTopologyModelInterface model = renderer.getModel();
        CCTopologyModelInterface.ActionSet actionSet = model.getActionSet();
        int[] actions = actionSet == null ? new int[]{} : actionSet.getValidIds();
        String lastMenuName = null;
        for (int a = 0; a < actions.length; ++a) {
            String menuName;
            CCContextualMenuModelInterface menu = actionSet.getMenu(actions[a]);
            if (menu == null) continue;
            lastMenuName = menuName = MENU_PREFIX + actions[a];
            tags.append(menuName).append(" = new Menu();\n");
            tags.append(menuName).append(".addMenuItem(\"&#8212;&nbsp;").append(modelI18N.getMessage(menu.getTitle())).append("&nbsp;&#8212;\");\n");
            String[] items = menu.getItems();
            for (int i = 0; i < items.length; ++i) {
                String item = items[i];
                if (item.equals("CCContextualMenuModelInterface.SEPARATOR")) {
                    tags.append(menuName).append(".addMenuSeparator();\n");
                    continue;
                }
                String itemLabel = modelI18N.getMessage(item);
                if (!menu.isItemEnabled(item)) {
                    itemLabel = "<font color=#999>" + itemLabel + "</font>";
                }
                tags.append(menuName).append(".addMenuItem(\"").append(itemLabel).append("\",\"hideMenu(").append(menuName).append(")");
                if (menu.isItemEnabled(item)) {
                    tags.append(";closeTopoMenu(document.").append(form).append(",'").append(items[i]).append("')");
                }
                tags.append("\");\n");
            }
            tags.append(menuName).append(".disableDrag = true;\n\n");
        }
        if (lastMenuName != null) {
            tags.append(lastMenuName).append(".writeMenus();\n");
        }
        tags.append("}\n//-->\n</script>\n");
        CCTopologyModelInterface.Node[] displayNodes = renderer.getDisplayedNodes();
        CCTopologyModelInterface.Edge[] displayEdges = renderer.getDisplayedEdges();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                Rectangle area = areas[r][c];
                tags.append("<map name=\"");
                tags.append(ids[r][c]);
                tags.append("\" id=\"topologyMap\">");
                for (int n = 0; n < displayNodes.length; ++n) {
                    CCTopologyServlet.appendAreaTags(tags, form, renderer, modelI18N, servletI18N, displayNodes[n], area, isNav4, isIE, tabIndex);
                }
                for (int e = 0; e < displayEdges.length; ++e) {
                    CCTopologyServlet.appendAreaTags(tags, form, renderer, modelI18N, servletI18N, displayEdges[e], area, isNav4, isIE, tabIndex);
                }
                tags.append("\n</map>\n");
            }
        }
        tags.append("<script type=\"text/javascript\" ");
        tags.append("language=\"JavaScript1.2\">\n<!--\n");
        tags.append("if (document.all || document.getElementById) {\n");
        tags.append("    onLoad(); \n} var ccScroll = ").append("new ccScrollCookie(\"ccScroll\");").append(" ccScroll.restore();ccScroll.reset();\n//-->\n</script>\n");
        return tags.toString();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream out = response.getOutputStream();
        CCSessionImageCache imageCache = CCSessionImageCache.getInstance(request.getSession());
        CCTopologyImageData imageData = imageCache.takeImageData(request.getParameter(IMAGE_ID_PARAM));
        if (imageData != null) {
            response.setContentType(imageData.getImageType());
            out.write(imageData.getImageBytes());
        }
        out.flush();
    }

    static boolean isValidImageFormat(String imageFormat) {
        return imageFormat != null && Arrays.asList(ImageIO.getWriterFormatNames()).contains(imageFormat);
    }

    private static void appendAreaTags(NonSyncStringBuffer buf, String form, CCTopologyRenderer renderer, CCI18N modelI18N, CCI18N servletI18N, CCTopologyModelInterface.Node node, Rectangle clip, boolean isNav4, boolean isIE, String tabIndex) {
        boolean inFilter;
        CCTopologyModelInterface.ActionSet actionSet = renderer.getModel().getActionSet();
        String label = node.getLabel();
        String action = null;
        String badgeAction = null;
        int menuId = 0;
        int badgeMenuId = 0;
        int actionId = node.getAction();
        if (actionSet instanceof CCDefaultActionSet && actionId == Integer.MIN_VALUE) {
            action = "ccnod";
        } else if (actionSet != null && actionId != 0) {
            action = actionSet.getAction(actionId);
            if (actionSet.getMenu(actionId) != null) {
                menuId = actionId;
            }
        }
        int badgeActionId = node.getBadgeAction();
        String badgeTooltipSuffix = null;
        if (actionSet instanceof CCDefaultActionSet && badgeActionId == Integer.MIN_VALUE) {
            badgeAction = "ccnodb";
        } else if (badgeActionId == -2147483645) {
            badgeAction = GROUP_NODE_BADGE_CLICKED;
            badgeTooltipSuffix = CCTopologyServlet.localize(modelI18N, servletI18N, GROUP_NODE_BADGE_TOOLTIP);
        } else if (actionSet != null && badgeActionId != 0) {
            badgeAction = actionSet.getAction(badgeActionId);
            if (actionSet.getMenu(badgeActionId) != null) {
                badgeMenuId = badgeActionId;
            }
        }
        String tooltip = node.getTooltip();
        if (tooltip != null) {
            tooltip = HtmlUtil.escape((String)tooltip);
        }
        if (tooltip != null) {
            tooltip = label + ", " + tooltip;
        }
        boolean mainAreaNeeded = (inFilter = node.isInFilter()) && (tooltip != null || action != null);
        boolean isOpenGroup = false;
        if (node instanceof CCTopologyModelInterface.GroupNode) {
            isOpenGroup = ((CCTopologyModelInterface.GroupNode)node).isExpanded();
            String turnerTooltip = CCTopologyServlet.localize(modelI18N, servletI18N, isOpenGroup ? TURNER_CLOSE_TOOLTIP : TURNER_OPEN_TOOLTIP);
            if (turnerTooltip != null) {
                turnerTooltip = label + ", " + turnerTooltip;
            }
            String turnerAction = isOpenGroup ? TURNER_CLOSE_ACTION : TURNER_OPEN_ACTION;
            CCTopologyServlet.appendAreaTags(buf, form, renderer.getTurnerArea(node, clip), turnerTooltip, node.getId(), turnerAction, 0, isNav4, isIE, tabIndex);
        }
        int badge = node.getBadge();
        if (!isOpenGroup && badge != 0) {
            String badgeTooltip = node.getBadgeTooltip();
            if (badgeTooltipSuffix != null) {
                badgeTooltip = badgeTooltip != null ? badgeTooltip + ", " + badgeTooltipSuffix : badgeTooltipSuffix;
            }
            if (badgeTooltip != null) {
                badgeTooltip = HtmlUtil.escape((String)badgeTooltip);
            }
            if (badgeTooltip != null) {
                badgeTooltip = label + ", " + badgeTooltip;
            }
            if (inFilter && (badgeTooltip != null || badgeAction != null)) {
                CCTopologyServlet.appendAreaTags(buf, form, renderer.getBadgeArea(node, clip), badgeTooltip, node.getId(), badgeAction, badgeMenuId, isNav4, isIE, tabIndex);
            }
        }
        if (mainAreaNeeded) {
            Rectangle labelArea = renderer.getLabelArea(node, clip);
            Rectangle iconArea = renderer.getIconArea(node, clip);
            if (isOpenGroup || iconArea == null) {
                CCTopologyServlet.appendAreaTags(buf, form, labelArea, tooltip, node.getId(), action, menuId, isNav4, isIE, tabIndex);
            } else if (labelArea == null) {
                CCTopologyServlet.appendAreaTags(buf, form, iconArea, tooltip, node.getId(), action, menuId, isNav4, isIE, tabIndex);
            } else {
                CCTopologyServlet.appendAreaTags(buf, form, CCTopologyServlet.mergeAreas(labelArea, iconArea), tooltip, node.getId(), action, menuId, isNav4, isIE, tabIndex);
            }
        }
    }

    private static Polygon mergeAreas(Rectangle labelArea, Rectangle iconArea) {
        Polygon area = new Polygon();
        if (labelArea.x + labelArea.width < iconArea.x) {
            int x = labelArea.x - 2;
            int y = labelArea.y;
            area.addPoint(x, y);
            x = iconArea.x - 2;
            area.addPoint(x, y);
            y = iconArea.y - 2;
            area.addPoint(x, y);
            x = iconArea.x + iconArea.width;
            area.addPoint(x, y);
            y = iconArea.y + iconArea.height;
            area.addPoint(x, y);
            x = iconArea.x - 2;
            area.addPoint(x, y);
            y = labelArea.y + labelArea.height;
            area.addPoint(x, y);
            x = labelArea.x - 2;
            area.addPoint(x, y);
        } else if (labelArea.y < iconArea.y) {
            int x = labelArea.x - 2;
            int y = labelArea.y;
            area.addPoint(x, y);
            area.addPoint(x, y += labelArea.height);
            x = iconArea.x - 2;
            area.addPoint(x, y);
            y = iconArea.y + iconArea.height;
            area.addPoint(x, y);
            x = iconArea.x + iconArea.width;
            area.addPoint(x, y);
            y = labelArea.y + labelArea.height;
            area.addPoint(x, y);
            x = labelArea.x + labelArea.width;
            area.addPoint(x, y);
            y = labelArea.y;
            area.addPoint(x, y);
        } else {
            int x = labelArea.x - 2;
            int y = labelArea.y;
            area.addPoint(x, y);
            area.addPoint(x, y += labelArea.height);
            x = labelArea.x + labelArea.width;
            area.addPoint(x, y);
            y = labelArea.y;
            area.addPoint(x, y);
            x = iconArea.x + iconArea.width;
            area.addPoint(x, y);
            y = iconArea.y - 2;
            area.addPoint(x, y);
            x = iconArea.x - 2;
            area.addPoint(x, y);
            y = labelArea.y;
            area.addPoint(x, y);
        }
        return area;
    }

    private static void appendAreaTags(NonSyncStringBuffer buf, String form, CCTopologyRenderer renderer, CCI18N modelI18N, CCI18N servletI18N, CCTopologyModelInterface.Edge edge, Rectangle clip, boolean isNav4, boolean isIE, String tabIndex) {
        String tooltip;
        if (!edge.isInFilter()) {
            return;
        }
        CCTopologyModelInterface.ActionSet actionSet = renderer.getModel().getActionSet();
        String action = null;
        String badgeAction = null;
        int menuId = 0;
        int badgeMenuId = 0;
        int actionId = edge.getAction();
        if (actionSet instanceof CCDefaultActionSet && actionId == Integer.MIN_VALUE) {
            action = "ccedg";
        } else if (actionId == -2147483647) {
            action = GROUP_EDGE_CLICKED;
        } else if (actionSet != null && actionId != 0) {
            action = actionSet.getAction(actionId);
            if (actionSet.getMenu(actionId) != null) {
                menuId = actionId;
            }
        }
        int badgeActionId = edge.getBadgeAction();
        String badgeTooltipSuffix = null;
        if (actionSet instanceof CCDefaultActionSet && badgeActionId == Integer.MIN_VALUE) {
            badgeAction = "ccedgb";
        } else if (badgeActionId == -2147483646) {
            badgeAction = GROUP_EDGE_BADGE_CLICKED;
            badgeTooltipSuffix = CCTopologyServlet.localize(modelI18N, servletI18N, GROUP_EDGE_BADGE_TOOLTIP);
        } else if (actionSet != null && badgeActionId != 0) {
            badgeAction = actionSet.getAction(badgeActionId);
            if (actionSet.getMenu(badgeActionId) != null) {
                badgeMenuId = badgeActionId;
            }
        }
        String edgeId = edge.getId();
        if (edgeId.indexOf(GROUP_EDGE_ID_SEPARATOR) != -1) {
            edgeId = edgeId + GROUP_EDGE_ID_SEPARATOR + edge.getBadge();
        }
        if ((tooltip = edge.getTooltip()) != null) {
            tooltip = HtmlUtil.escape((String)tooltip);
        }
        boolean mainAreaNeeded = tooltip != null || action != null;
        int badge = edge.getBadge();
        if (badge != 0) {
            String badgeTooltip = edge.getBadgeTooltip();
            if (badgeTooltipSuffix != null) {
                badgeTooltip = badgeTooltip != null ? badgeTooltip + ", " + badgeTooltipSuffix : badgeTooltipSuffix;
            }
            if (badgeTooltip != null) {
                badgeTooltip = HtmlUtil.escape((String)badgeTooltip);
            }
            if (badgeTooltip != null || badgeAction != null) {
                CCTopologyServlet.appendAreaTags(buf, form, renderer.getBadgeArea(edge, clip), badgeTooltip, edgeId, badgeAction, badgeMenuId, isNav4, isIE, tabIndex);
            }
        }
        if (mainAreaNeeded) {
            CCTopologyServlet.appendAreaTags(buf, form, renderer.getEdgeArea(edge, clip), tooltip, edgeId, action, menuId, isNav4, isIE, tabIndex);
        }
    }

    public static String localize(CCI18N modelI18N, CCI18N servletI18N, String key) {
        if (key == null) {
            return null;
        }
        String value = key;
        if (modelI18N != null) {
            value = modelI18N.getMessage(key);
        }
        if (servletI18N != null && key.equals(value)) {
            value = servletI18N.getMessage(key);
        }
        return value;
    }

    private static void appendAreaTags(NonSyncStringBuffer buf, String form, Rectangle[] areas, String tooltip, String id, String action, int menuId, boolean isNav4, boolean isIE, String tabIndex) {
        if (areas != null) {
            for (int b = 0; b < areas.length; ++b) {
                CCTopologyServlet.appendAreaTags(buf, form, areas[b], tooltip, id, action, menuId, isNav4, isIE, tabIndex);
            }
        }
    }

    private static void appendAreaTags(NonSyncStringBuffer buf, String form, Rectangle area, String tooltip, String id, String action, int menuId, boolean isNav4, boolean isIE, String tabIndex) {
        if (area != null) {
            NonSyncStringBuffer coordsBuf = new NonSyncStringBuffer();
            coordsBuf.append((int)area.getMinX()).append(',').append((int)area.getMinY()).append(',').append((int)area.getMaxX()).append(',').append((int)area.getMaxY());
            CCTopologyServlet.appendAreaTags(buf, form, "rect", coordsBuf.toString(), tooltip, id, action, menuId, isNav4, isIE, tabIndex);
        }
    }

    private static void appendAreaTags(NonSyncStringBuffer buf, String form, Polygon area, String tooltip, String id, String action, int menuId, boolean isNav4, boolean isIE, String tabIndex) {
        if (area != null) {
            NonSyncStringBuffer coordsBuf = new NonSyncStringBuffer();
            for (int p = 0; p < area.npoints; ++p) {
                if (p > 0) {
                    coordsBuf.append(',');
                }
                coordsBuf.append(area.xpoints[p]).append(',').append(area.ypoints[p]);
            }
            CCTopologyServlet.appendAreaTags(buf, form, "poly", coordsBuf.toString(), tooltip, id, action, menuId, isNav4, isIE, tabIndex);
        }
    }

    private static void appendAreaTags(NonSyncStringBuffer buf, String form, String shape, String coords, String tooltip, String id, String action, int menuId, boolean isNav4, boolean isIE, String tabIndex) {
        buf.append("\n  <area shape=\"").append(shape).append("\" coords=\"").append(coords).append('\"');
        if (tabIndex != null) {
            buf.append(" tabindex=\"").append(tabIndex).append('\"');
        }
        if (action != null || menuId != 0) {
            NonSyncStringBuffer actionBuf = new NonSyncStringBuffer();
            if (menuId != 0) {
                actionBuf.append("\"javascript: openTopoMenu(document.").append(form).append(",'").append(id).append("',").append(MENU_PREFIX).append(menuId).append(")\"");
            } else {
                actionBuf.append("\"javascript: topoClick(document.").append(form).append(",'").append(id).append("','").append(action).append("')\"");
            }
            buf.append(" href=").append(actionBuf.toString());
            actionBuf.setLength(0);
            actionBuf.append("\"javascript: return topoKeyPress(event,document.").append(form).append(",'").append(id).append("','").append(action).append("')\"");
            buf.append(" onKeyPress=").append(actionBuf.toString());
        }
        if (tooltip == null) {
            tooltip = "";
        }
        buf.append(" alt=\"").append(tooltip).append("\" title=\"").append(tooltip).append('\"');
        buf.append(" onmouseover=\"window.status='").append(CCTagBase.escapeJsQuotes(tooltip)).append("'; return true;\"").append(" onmouseout=\"window.status='';\"");
        buf.append(" />");
    }
}

