/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.breadcrumb;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.CommandField;
import com.iplanet.jato.view.View;
import com.sun.web.ui.common.CCBodyContentImpl;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCJspWriterImpl;
import com.sun.web.ui.model.CCBreadCrumbsModelInterface;
import com.sun.web.ui.taglib.common.CCTagBase;
import com.sun.web.ui.taglib.html.CCHrefTag;
import com.sun.web.ui.view.breadcrumb.CCBreadCrumbs;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCBreadCrumbsTag
extends CCTagBase {
    protected static final String ATTRIB_BELOWTABS = "belowTabs";
    protected static final String ATTRIB_GRAYBG = "useGrayBg";
    protected NonSyncStringBuffer buffer = null;
    protected static final String NODE_DELIMITER = "&nbsp;&nbsp;<span class=\"BcmSep\">&gt;</span>&nbsp;&nbsp;";

    public void reset() {
        super.reset();
        this.buffer = null;
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        super.getHTMLStringInternal(parent, pageContext, view);
        this.checkChildType(view, CCBreadCrumbs.class);
        CCBreadCrumbs field = (CCBreadCrumbs)view;
        this.setParent(parent);
        this.setPageContext(pageContext);
        this.buffer = new NonSyncStringBuffer(8192);
        CCBreadCrumbsModelInterface model = (CCBreadCrumbsModelInterface)field.getModel();
        String useGrayBg = model.isUseGrayBgSet() ? model.getUseGrayBg() : this.getUseGrayBg();
        this.buffer.append("<table cellpadding=\"0\" cellspacing=\"0\" ").append("width=\"100%\" border=\"0\"");
        if (new Boolean(useGrayBg).booleanValue()) {
            this.buffer.append(" class=\"").append("BcmGryTbl").append("\"").append("><tr>").append("<td><div class=\"").append("BcmGryDiv").append("\"").append(">");
        } else {
            this.buffer.append("><tr><td><div class=\"").append("BcmWhtDiv").append("\"").append(">");
        }
        int breadCrumbs = 0;
        try {
            model.beforeFirst();
            while (model.next()) {
                if (++breadCrumbs > 1) {
                    this.buffer.append(NODE_DELIMITER);
                }
                this.appendLink(model, this.buffer);
            }
            if (breadCrumbs > 0) {
                this.buffer.append(NODE_DELIMITER);
            }
        }
        catch (ModelControlException mce) {
            throw new JspException(mce.getMessage());
        }
        catch (NullPointerException npe) {
            CCDebug.trace1("Null pointer constructing breadcrumb");
            CCDebug.trace1(npe.getMessage());
            return "";
        }
        if (breadCrumbs == 0) {
            return "";
        }
        this.buffer.append("<span class=\"").append("BcmTxt").append("\"").append(">").append(HtmlUtil.escape((String)this.getMessage(model.getCurrentPageLabel()))).append("</span></div></td></tr>");
        this.buffer.append("</table>");
        return this.buffer.toString();
    }

    private void appendLink(CCBreadCrumbsModelInterface model, NonSyncStringBuffer buffer) throws JspException {
        String statusMsg;
        String target;
        View child = this.getParentContainerView().getChild((String)model.getValue("commandField"));
        this.checkChildType(child, CommandField.class);
        CommandField commandField = (CommandField)child;
        commandField.setValue(model.getValue("value"));
        String label = this.getMessage((String)model.getValue("label"));
        CCHrefTag ccHrefTag = new CCHrefTag();
        ccHrefTag.setBundleID(this.getBundleID());
        ccHrefTag.setStyleClass("BcmLnk");
        ccHrefTag.setTitle(label);
        ccHrefTag.setTabIndex(this.getTabIndex());
        String onClick = (String)model.getValue("onClick");
        if (onClick != null) {
            ccHrefTag.setOnClick(onClick);
        }
        if ((target = (String)model.getValue("target")) != null) {
            try {
                ccHrefTag.setTarget(target);
                onClick = onClick == null ? "javascript: return true;" : onClick + "; return true;";
                ccHrefTag.setOnClick(onClick);
            }
            catch (ClassCastException cce) {
                CCDebug.trace1("Target can't be set on non-HREF!");
            }
        }
        this.setHrefStatus(ccHrefTag, HtmlUtil.escapeQuotes((String)this.getMessage((statusMsg = (String)model.getValue("status")) != null ? statusMsg : "")));
        try {
            CCBodyContentImpl bodyContent = new CCBodyContentImpl(new CCJspWriterImpl(null, 100, false));
            bodyContent.print(HtmlUtil.escape((String)label));
            ccHrefTag.setBodyContent(bodyContent);
        }
        catch (IOException e) {
            CCDebug.trace1(e.getMessage());
        }
        buffer.append(ccHrefTag.getHTMLString(this.getParent(), this.pageContext, (View)commandField));
    }

    protected void setHrefStatus(CCHrefTag ccHrefTag, String status) throws JspException {
        if (ccHrefTag == null) {
            CCDebug.trace1("CCHrefTag parameter is null.");
            return;
        }
        if (status == null) {
            CCDebug.trace1("status parameter is null.");
            return;
        }
        NonSyncStringBuffer statusBuffer = new NonSyncStringBuffer(8192);
        statusBuffer.append("window.status='").append(CCBreadCrumbsTag.escapeJsQuotes(status)).append("'; return true");
        ccHrefTag.setOnMouseOver(statusBuffer.toString());
        ccHrefTag.setOnFocus(statusBuffer.toString());
        ccHrefTag.setOnMouseOut("window.status=''; return true");
        ccHrefTag.setOnBlur("window.status=''; return true");
    }

    public String getBelowTabs() {
        return (String)this.getValue(ATTRIB_BELOWTABS);
    }

    public void setBelowTabs(String value) {
        this.setValue(ATTRIB_BELOWTABS, value);
    }

    public String getUseGrayBg() {
        return (String)this.getValue(ATTRIB_GRAYBG);
    }

    public void setUseGrayBg(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_GRAYBG, value);
    }
}

