/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.common;

import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.taglib.JspWrapperException;
import com.iplanet.jato.taglib.TagBase;
import com.iplanet.jato.taglib.html.FormTag;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.CommandField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBeanBase;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.JspBeginChildDisplayEvent;
import com.iplanet.jato.view.event.JspEndChildDisplayEvent;
import com.sun.web.ui.common.CCClientSniffer;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.common.CCJavascript;
import com.sun.web.ui.common.CCManageChild;
import com.sun.web.ui.taglib.html.CCFormTag;
import com.sun.web.ui.taglib.html.CCHiddenTag;
import com.sun.web.ui.taglib.html.CCHrefTag;
import com.sun.web.ui.view.html.CCHref;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

public abstract class CCTagBase
extends TagBase {
    protected static final String ATTRIB_BUNDLEID = "bundleID";
    protected static final String ATTRIB_FIRE_DISPLAY_EVENTS = "fireDisplayEvents";
    protected static final String ATTRIB_TABINDEX = "tabIndex";
    protected static final int K = 1024;
    protected static final int DEFAULT_BUFFER_SIZE = 8192;
    private CCI18N i18n = null;
    private CCI18N tagI18n = null;
    private CCClientSniffer cs = null;
    private String formName = null;
    protected String encoding = "UTF-8";
    public static final String POPUP_WINDOW = "com_sun_web_ui_popup";

    public CCTagBase() {
        CCDebug.initTrace();
    }

    public int doStartTag() throws JspException {
        this.reset();
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.fireBeginDisplayEvent()) {
                ContainerView parentContainer = this.getParentContainerView();
                String name = this.getName();
                View child = parentContainer != null ? parentContainer.getChild(name) : null;
                this.writeOutput(this.fireEndDisplayEvent(this.getHTMLStringInternal(this.getParent(), this.pageContext, child)));
            }
        }
        catch (CompleteRequestException e) {
            this.getRequestContext().getRequest().setAttribute(ViewBeanBase.DISPLAY_EVENT_COMPLETED_REQUEST_ATTRIBUTE_NAME, (Object)e);
            return 5;
        }
        return 6;
    }

    protected boolean fireBeginDisplayEvent() throws JspException {
        String name = this.getName();
        if (name != null && name.trim().length() > 0) {
            return super.fireBeginDisplayEvent();
        }
        return true;
    }

    protected String fireEndDisplayEvent(String html) throws JspException {
        String name = this.getName();
        if (name != null && name.trim().length() > 0) {
            return super.fireEndDisplayEvent(html);
        }
        return html;
    }

    protected boolean fireBeginDisplayEvent(ContainerView view, CCTagBase tag) throws JspException {
        boolean result = true;
        if (this.shouldFireDisplayEvents()) {
            try {
                result = view.beginChildDisplay((ChildDisplayEvent)new JspBeginChildDisplayEvent((Tag)tag, this.pageContext, tag.getName()));
            }
            catch (ModelControlException e) {
                throw new JspWrapperException("Exception during beginDisplay() event for child \"" + tag.getName() + "\"", (Throwable)e);
            }
        }
        return result;
    }

    protected String fireEndDisplayEvent(ContainerView view, CCTagBase tag, String html) throws JspException {
        if (this.shouldFireDisplayEvents()) {
            try {
                html = view.endChildDisplay((ChildContentDisplayEvent)new JspEndChildDisplayEvent((Tag)tag, this.pageContext, tag.getName(), html));
            }
            catch (ModelControlException e) {
                throw new JspWrapperException("Exception during endDisplay() event for child \"" + tag.getName() + "\"", (Throwable)e);
            }
        }
        return html;
    }

    public String getHTMLString(Tag parent, PageContext pageContext, View view) throws JspException {
        this.reset();
        return this.getHTMLStringInternal(parent, pageContext, view);
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        return null;
    }

    public void reset() {
        super.reset();
        this.i18n = null;
        this.tagI18n = null;
        this.cs = null;
        this.formName = null;
    }

    protected CCClientSniffer getClientSniffer() {
        if (this.cs == null) {
            this.cs = new CCClientSniffer(this.getRequestContext().getRequest());
        }
        return this.cs;
    }

    protected boolean isWin() {
        return this.getClientSniffer().isWin();
    }

    protected boolean isSun() {
        return this.getClientSniffer().isSun();
    }

    protected boolean isGecko() {
        return this.getClientSniffer().isGecko();
    }

    protected boolean isNav() {
        return this.getClientSniffer().isNav();
    }

    protected boolean isNav4() {
        return this.getClientSniffer().isNav4();
    }

    protected boolean isNav4up() {
        return this.getClientSniffer().isNav4up();
    }

    protected boolean isNav6() {
        return this.getClientSniffer().isNav6();
    }

    protected boolean isNav6up() {
        return this.getClientSniffer().isNav6up();
    }

    protected boolean isNav7() {
        return this.getClientSniffer().isNav7();
    }

    protected boolean isNav7up() {
        return this.getClientSniffer().isNav7up();
    }

    protected boolean isIe() {
        return this.getClientSniffer().isIe();
    }

    protected boolean isIe5() {
        return this.getClientSniffer().isIe5();
    }

    protected boolean isIe5up() {
        return this.getClientSniffer().isIe5up();
    }

    protected boolean isIe6up() {
        return this.getClientSniffer().isIe6up();
    }

    protected CCI18N getI18N() {
        if (this.i18n == null) {
            this.i18n = new CCI18N(this.pageContext.getRequest(), this.getBundleID());
        }
        return this.i18n;
    }

    protected String getMessage(String key) {
        return this.getI18N().getMessage(key);
    }

    protected String getMessage(String key, Object[] args) {
        return this.getI18N().getMessage(key, args);
    }

    protected CCI18N getTagI18N() {
        if (this.tagI18n == null) {
            this.tagI18n = new CCI18N(this.pageContext.getRequest(), this.pageContext.getResponse(), "com.sun.web.ui.resources.Resources", "com.sun.web.ui", null);
        }
        return this.tagI18n;
    }

    protected Locale getTagLocale() {
        return CCI18N.getTagsLocale(this.pageContext.getRequest());
    }

    protected String getTagMessage(String key) {
        return this.getTagI18N().getMessage(key);
    }

    protected String getTagMessage(String key, Object[] args) {
        return this.getTagI18N().getMessage(key, args);
    }

    public static String escapeJsQuotes(String rawString) {
        return rawString.replaceAll("'", "\\\\'");
    }

    protected static void appendAttribute(NonSyncStringBuffer buffer, String name, String value) {
        CCTagBase.appendAttribute(buffer, name, value, true);
    }

    protected static void appendAttribute(NonSyncStringBuffer buffer, String name, String value, boolean escape) {
        if (value == null) {
            return;
        }
        try {
            buffer.append(" ").append(name).append("=\"").append(escape ? HtmlUtil.escapeQuotes((String)value) : value).append("\"");
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
    }

    protected static void appendHiddenFieldHTMLString(NonSyncStringBuffer buffer, String name, String value) {
        try {
            buffer.append("<input");
            CCTagBase.appendAttribute(buffer, "type", "hidden");
            CCTagBase.appendAttribute(buffer, "name", name);
            CCTagBase.appendAttribute(buffer, "value", value != null ? value : "");
            buffer.append(" />");
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
    }

    protected boolean includeBrowserVersionJS() throws JspException {
        return this.includeJavascriptFile(CCJavascript.BROWSER_VERSION_JS);
    }

    protected boolean includeJavascriptFile(String src) throws IllegalArgumentException, JspException {
        if (this.pageContext.getAttribute(src) != null) {
            return false;
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer("<script");
        CCTagBase.appendAttribute(buffer, "type", "text/javascript");
        CCTagBase.appendAttribute(buffer, "src", src);
        buffer.append("></script>\n");
        this.writeOutput(buffer.toString());
        this.pageContext.setAttribute(src, (Object)"1", 1);
        return true;
    }

    protected String getActionURLJavascript(ContainerView view, String name) throws JspException {
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this.getFormName() == null) {
            CCDebug.trace1("Could not obtain form name");
            return null;
        }
        CCHref child = new CCHref(view, name, null);
        CCHrefTag ccHrefTag = new CCHrefTag();
        this.syncParams((TagSupport)ccHrefTag);
        ccHrefTag.setSubmitFormData("true");
        String url = ccHrefTag.getURLString(this.getParent(), this.pageContext, (CommandField)child);
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        buffer.append("javascript:var f=document.").append(this.getFormName()).append(";if (f != null) {f.action='").append(url).append("';f.submit();}");
        return buffer.toString();
    }

    protected String getFormName() {
        if (this.formName == null) {
            FormTag ftag = (FormTag)CCTagBase.findAncestorWithClass((Tag)this, (Class)FormTag.class);
            if (ftag != null) {
                this.formName = ftag.getName();
            } else {
                CCFormTag ccFtag = (CCFormTag)CCTagBase.findAncestorWithClass((Tag)this, (Class)CCFormTag.class);
                if (ccFtag != null) {
                    this.formName = ccFtag.getName();
                }
            }
        }
        return this.formName;
    }

    protected String getHiddenFieldHTMLString(View view, String name, Object value) throws JspException {
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        View child = null;
        if (view instanceof ContainerView) {
            child = ((ContainerView)view).getChild(name);
        } else if (view instanceof CCManageChild) {
            child = ((CCManageChild)view).getChild(name);
        } else {
            CCDebug.trace1("view must be ContainerView or CCManageChild");
            return null;
        }
        this.checkChildType(child, DisplayField.class);
        ((DisplayField)child).setValue(value);
        CCHiddenTag hiddenTag = new CCHiddenTag();
        return hiddenTag.getHTMLString(this.getParent(), this.pageContext, child);
    }

    protected static String getImageHTMLString(String src, int height, int width) {
        return CCTagBase.getImageHTMLString(src, new Integer(height).toString(), new Integer(width).toString());
    }

    protected static String getImageHTMLString(String src, String height, String width) {
        return CCTagBase.getImageHTMLString(src, height, width, null);
    }

    protected static String getImageHTMLString(String src, String height, String width, String extraHtml) {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(1024);
        buffer.append("<img");
        CCTagBase.appendAttribute(buffer, "src", src);
        CCTagBase.appendAttribute(buffer, "alt", "");
        CCTagBase.appendAttribute(buffer, "border", "0");
        CCTagBase.appendAttribute(buffer, "height", height);
        CCTagBase.appendAttribute(buffer, "width", width);
        if (extraHtml != null) {
            buffer.append(" ").append(extraHtml);
        }
        buffer.append(" />");
        return buffer.toString();
    }

    protected String getOpenWindowJavascript(String url, String name, int height, int width, String features) {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(1024);
        try {
            if (url.length() > 0 && !url.startsWith("javascript")) {
                NonSyncStringBuffer urlBuffer = new NonSyncStringBuffer(1024);
                if (url.indexOf("?") == -1) {
                    urlBuffer.append("?");
                } else {
                    urlBuffer.append("&amp;");
                }
                urlBuffer.append(URLEncoder.encode(POPUP_WINDOW, this.encoding)).append("=").append(URLEncoder.encode("true", this.encoding));
                int index = url.indexOf("#");
                if (index == -1) {
                    url = url.concat(urlBuffer.toString());
                } else {
                    NonSyncStringBuffer tmpBuffer = new NonSyncStringBuffer(1024);
                    tmpBuffer.append(url.substring(0, index - 1));
                    tmpBuffer.append(urlBuffer.toString());
                    tmpBuffer.append(url.substring(index));
                    url = tmpBuffer.toString();
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            CCDebug.trace3(this.encoding + " encoding is not supported.");
        }
        buffer.append("javascript:var win = window.open('").append(url).append("','").append(name).append("','").append("height=").append(height).append(",width=").append(width).append(",top='+((screen.height-(screen.height/1.618))-(").append(height).append("/2))+',left='+((screen.width-").append(width).append(")/2)+'");
        if (features != null) {
            buffer.append(",").append(features);
        }
        buffer.append("')");
        if (this.getClientSniffer().getUserAgentMajor() >= 4) {
            buffer.append(";win.focus()");
        }
        return buffer.toString();
    }

    protected void syncParams(TagSupport tag) throws JspException {
        tag.setPageContext(this.pageContext);
        tag.setParent(this.getParent());
        Iterator i = this.getValueMap().keySet().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            tag.setValue(s, this.getValue(s));
        }
    }

    public String getBundleID() {
        return (String)this.getValue(ATTRIB_BUNDLEID);
    }

    public void setBundleID(String value) {
        this.setValue(ATTRIB_BUNDLEID, value);
    }

    public String getFireDisplayEvents() {
        return (String)this.getValue(ATTRIB_FIRE_DISPLAY_EVENTS);
    }

    public void setFireDisplayEvents(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_FIRE_DISPLAY_EVENTS, value);
    }

    public String getTabIndex() {
        return (String)this.getValue(ATTRIB_TABINDEX);
    }

    public void setTabIndex(String value) {
        this.setValue(ATTRIB_TABINDEX, value);
    }
}

