/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.common;

import com.iplanet.jato.util.HtmlUtil;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.taglib.common.CCDisplayFieldTagBase;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class CCTextFieldTagBase
extends CCDisplayFieldTagBase {
    protected static final String ATTRIB_FORMATMASK = "formatMask";
    protected static final String ATTRIB_FORMATTYPE = "formatType";
    public static final String FORMAT_TYPE_ALPHANUMERIC = "alpanumeric";
    public static final String FORMAT_TYPE_CURRENCY = "currency";
    public static final String FORMAT_TYPE_DATE = "date";
    public static final String FORMAT_TYPE_DECIMAL = "decimal";

    public CCTextFieldTagBase() {
        CCDebug.initTrace();
    }

    protected String formatValue(Object value) {
        if (value == null) {
            return null;
        }
        String formatMask = this.getFormatMask();
        if (formatMask == null) {
            return value.toString();
        }
        int formatType = 1;
        String formatTypeString = this.getFormatType();
        if (formatTypeString.equals(FORMAT_TYPE_DATE)) {
            SimpleDateFormat sdf = this.getTagLocale() != null ? new SimpleDateFormat(formatMask, this.getTagLocale()) : new SimpleDateFormat(formatMask);
            String result = null;
            if (value instanceof Date) {
                result = sdf.format((Date)value);
            } else {
                String dateString = value.toString();
                try {
                    result = sdf.format(sdf.parse(dateString));
                }
                catch (ParseException e) {
                    CCDebug.trace1("Cannot format as Date: " + dateString);
                    result = dateString;
                }
            }
            return result;
        }
        if (formatTypeString.equals(FORMAT_TYPE_ALPHANUMERIC)) {
            formatType = 1;
        } else if (formatTypeString.equals(FORMAT_TYPE_DECIMAL)) {
            formatType = 4;
        } else if (formatTypeString.equals(FORMAT_TYPE_CURRENCY)) {
            formatType = 3;
        }
        return HtmlUtil.format((Object)value, (int)formatType, (String)formatMask);
    }

    public String getFormatMask() {
        return (String)this.getValue(ATTRIB_FORMATMASK);
    }

    public void setFormatMask(String value) {
        this.setValue(ATTRIB_FORMATMASK, value);
    }

    public String getFormatType() {
        return (String)this.getValue(ATTRIB_FORMATTYPE);
    }

    public void setFormatType(String value) {
        if (!(value == null || value.equals(FORMAT_TYPE_ALPHANUMERIC) || value.equals(FORMAT_TYPE_CURRENCY) || value.equals(FORMAT_TYPE_DATE) || value.equals(FORMAT_TYPE_DECIMAL))) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_FORMATTYPE, value);
    }
}

