/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.html;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.sun.web.ui.common.CCAccessible;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.taglib.html.CCStaticTextFieldTag;
import com.sun.web.ui.view.html.CCLabel;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCLabelTag
extends CCStaticTextFieldTag {
    protected static final String ATTRIB_ELEMENT_NAME = "elementName";
    protected static final String ATTRIB_SHOW_ERROR = "showError";
    protected static final String ATTRIB_SHOW_REQUIRED = "showRequired";
    protected static final String ATTRIB_STYLE_LEVEL = "styleLevel";
    private CCLabel field = null;

    public void reset() {
        super.reset();
        this.field = null;
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        this.checkChildType(view, CCLabel.class);
        this.field = (CCLabel)view;
        String value = super.getHTMLStringInternal(parent, pageContext, (View)this.field);
        this.setAttributes();
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        this.appendRequiredFieldIndicator(buffer);
        this.appendErrorFieldIndicator(buffer);
        buffer.append("<span");
        if (this.isTrue(this.getShowError())) {
            CCLabelTag.appendAttribute(buffer, "class", "ConErrLblTxt");
        } else {
            CCLabelTag.appendAttribute(buffer, "class", this.getStyleClass());
        }
        buffer.append(">");
        if (this.getElementId() != null) {
            buffer.append("<label");
            CCLabelTag.appendAttribute(buffer, "for", this.getElementId());
            buffer.append(">");
        }
        if (value != null) {
            buffer.append(value);
        }
        if (this.getElementId() != null) {
            buffer.append("</label>");
        }
        buffer.append("</span>");
        return buffer.toString();
    }

    public String getStyleClass() {
        String className = super.getStyleClass();
        if (className == null) {
            className = this.getStyleLevel().equals("1") ? "LblLev1Txt" : (this.getStyleLevel().equals("3") ? "LblLev3Txt" : "LblLev2Txt");
        }
        return className;
    }

    protected void setAttributes() throws JspException {
        super.setAttributes();
        if (this.field instanceof CCLabel) {
            View view;
            CCLabel child = this.field;
            if (child.getElementId() != null) {
                this.setElementId(child.getElementId());
            }
            if (child.getElementName() != null) {
                this.setElementName(child.getElementName());
            }
            if (child.getStyleLevel() != null) {
                this.setStyleLevel(child.getStyleLevel());
            }
            if (child.getShowError() != null) {
                this.setShowError(child.getShowError().toString());
            }
            if (child.getShowRequired() != null) {
                this.setShowRequired(child.getShowRequired().toString());
            }
            if (this.getElementName() != null && (view = ((ContainerView)this.field.getParent()).getChild(this.getElementName())) != null && view instanceof CCAccessible) {
                if (this.getElementId() == null) {
                    this.setElementId(view.getQualifiedName());
                }
                ((CCAccessible)view).setElementId(this.getElementId());
            }
        }
    }

    private void appendRequiredFieldIndicator(NonSyncStringBuffer buffer) {
        String showRequired = this.getShowRequired();
        if (showRequired != null && this.isTrue(showRequired)) {
            buffer.append("<img src=\"" + CCImage.REQUIRED + "\" alt=\"").append(this.getTagMessage("label.required")).append("\" title=\"").append(this.getTagMessage("label.required")).append("\" width=\"7\" height=\"14\" />&nbsp;");
        }
    }

    private void appendErrorFieldIndicator(NonSyncStringBuffer buffer) {
        String showError = this.getShowError();
        if (showError != null && this.isTrue(showError)) {
            buffer.append("<img src=\"" + CCImage.ALERT_ERROR_SMALL + "\" alt=\"").append(this.getTagMessage("label.error")).append("\" width=\"11\" height=\"14\" />&nbsp;");
        }
    }

    public String getElementName() {
        return (String)this.getValue(ATTRIB_ELEMENT_NAME);
    }

    public void setElementName(String value) {
        this.setValue(ATTRIB_ELEMENT_NAME, value);
    }

    public String getShowError() {
        return (String)this.getValue(ATTRIB_SHOW_ERROR);
    }

    public void setShowError(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_SHOW_ERROR, value);
    }

    public String getShowRequired() {
        return (String)this.getValue(ATTRIB_SHOW_REQUIRED);
    }

    public void setShowRequired(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_SHOW_REQUIRED, value);
    }

    public String getStyleLevel() {
        return this.getValue(ATTRIB_STYLE_LEVEL) != null ? (String)this.getValue(ATTRIB_STYLE_LEVEL) : "2";
    }

    public void setStyleLevel(String value) {
        if (!(value == null || value.equals("1") || value.equals("2") || value.equals("3"))) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_STYLE_LEVEL, value);
    }
}

