/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.tree;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCStateData;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCTreeModel;
import com.sun.web.ui.model.CCTreeModelInterface;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCImageField;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.tree.CCTreeEventHandlerInterface;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;

public class CCDynamicTree
extends RequestHandlingViewBase
implements CCStateData {
    public static final String CHILD_TURNER_HREF = "TurnerHref";
    public static final String CHILD_NODE_HREF = "NodeHref";
    public static final String CHILD_NODE_LABEL = "NodeText";
    public static final String CHILD_IMAGE = "ChildImage";
    public static final String CHILD_HIDDEN_URL = "newurl";
    protected boolean forwardEvents = false;
    private final String QUALIFIED_NAME = this.getQualifiedName();
    private final String STATE_DATA = this.QUALIFIED_NAME + ".statedata";
    private static final String SELECTED_NODE = "SelectedNode";
    private static final String OPEN_CONTAINERS = "OpenContainers";
    protected CCTreeModelInterface model = null;

    public CCDynamicTree(ContainerView parent, String name, CCTreeModelInterface model) {
        super((View)parent, name);
        this.setModel(model);
        this.registerChildren();
    }

    public CCDynamicTree(CCTreeEventHandlerInterface parent, String name, CCTreeModelInterface model) {
        this((ContainerView)parent, name, model);
        this.forwardEvents = true;
    }

    public void registerChildren() {
        this.registerChild(CHILD_TURNER_HREF, CCHref.class);
        this.registerChild(CHILD_NODE_HREF, CCHref.class);
        this.registerChild(CHILD_NODE_LABEL, CCStaticTextField.class);
        this.registerChild(CHILD_IMAGE, CCImageField.class);
        this.registerChild(CHILD_HIDDEN_URL, CCHiddenField.class);
    }

    protected View createChild(String name) {
        if (name.equals(CHILD_NODE_HREF) || name.equals(CHILD_TURNER_HREF)) {
            CCHref child = new CCHref((ContainerView)this, name, "");
            return child;
        }
        if (name.equals(CHILD_TURNER_HREF)) {
            CCHref child = new CCHref((ContainerView)this, name, "");
            return child;
        }
        if (name.equals(CHILD_NODE_LABEL)) {
            CCStaticTextField child = new CCStaticTextField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_IMAGE)) {
            CCImageField child = new CCImageField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_HIDDEN_URL)) {
            CCHiddenField child = new CCHiddenField((ContainerView)this, CHILD_HIDDEN_URL, "");
            return child;
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.restoreStateData();
    }

    public CCTreeModelInterface getModel() {
        if (this.model == null) {
            this.model = new CCTreeModel();
        }
        return this.model;
    }

    public void setModel(CCTreeModelInterface model) throws IllegalArgumentException {
        if (model == null) {
            throw new IllegalArgumentException("Invalid parameter.");
        }
        this.model = model;
    }

    public void handleTurnerHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        this.restoreStateData();
        String value = (String)this.getDisplayFieldValue(CHILD_TURNER_HREF);
        Integer nodeId = new Integer(value);
        CCNavNodeInterface node = this.getModel().getNodeById(nodeId);
        try {
            node.setExpanded(!node.getExpanded());
        }
        catch (NullPointerException npe) {
            CCDebug.trace1("Couldn't find node with id " + nodeId);
        }
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)((HashMap)this.getStateData()));
        if (this.forwardEvents) {
            ((CCTreeEventHandlerInterface)this.getParent()).turnerClicked(event, nodeId, this.QUALIFIED_NAME);
        } else {
            this.getParentViewBean().forwardTo(this.getRequestContext());
        }
    }

    public void handleNodeHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        this.restoreStateData();
        String value = (String)this.getDisplayFieldValue(CHILD_NODE_HREF);
        Integer nodeId = new Integer(value);
        this.getModel().setSelectedNode(nodeId);
        this.setDisplayFieldValue(CHILD_HIDDEN_URL, this.getModel().getNodeById(nodeId).getValue());
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)((HashMap)this.getStateData()));
        if (this.forwardEvents) {
            ((CCTreeEventHandlerInterface)this.getParent()).nodeClicked(event, nodeId, this.QUALIFIED_NAME);
        } else {
            this.getParentViewBean().forwardTo(this.getRequestContext());
        }
    }

    public Map getStateData() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CCNavNodeInterface node = this.getModel().getSelectedNode();
        if (node != null) {
            map.put(SELECTED_NODE, new Integer(node.getId()).toString());
        } else {
            map.put(SELECTED_NODE, null);
        }
        map.put(OPEN_CONTAINERS, this.getModel().getOpenContainers());
        return map;
    }

    public void resetStateData() {
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, null);
    }

    public void setStateData() {
        this.restoreStateData();
    }

    public void restoreStateData() {
        ViewBean vb = this.getParentViewBean();
        boolean mapUpdated = false;
        String selectedNode = null;
        List openContainers = null;
        HashMap<String, Object> map = (HashMap<String, Object>)vb.getPageSessionAttribute(this.STATE_DATA);
        if (map != null) {
            selectedNode = (String)map.get(SELECTED_NODE);
            openContainers = (ArrayList)map.get(OPEN_CONTAINERS);
        } else {
            map = new HashMap<String, Object>();
        }
        if (selectedNode != null) {
            this.getModel().setSelectedNode(Integer.parseInt(selectedNode));
        } else if (this.getModel().getSelectedNode() != null) {
            map.put(SELECTED_NODE, new Integer(this.getModel().getSelectedNode().getId()).toString());
            mapUpdated = true;
        }
        if (openContainers != null) {
            int size = openContainers.size();
            for (int i = 0; i < size; ++i) {
                int nodeId = (Integer)openContainers.get(i);
                CCNavNodeInterface n = this.getModel().getNodeById(nodeId);
                if (n == null) continue;
                n.setExpanded(true);
            }
        } else {
            openContainers = this.getModel().getOpenContainers();
            if (openContainers.size() > 0) {
                map.put(OPEN_CONTAINERS, openContainers);
                mapUpdated = true;
            }
        }
        if (mapUpdated) {
            this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)((HashMap)this.getStateData()));
        }
    }

    public void resetDisplayRoot(CCNavNodeInterface newDisplayRoot) {
    }

    public void setStateData(Map m) {
        this.resetStateData();
        if (m == null) {
            return;
        }
        Integer selectedInt = null;
        try {
            selectedInt = new Integer((String)m.get(SELECTED_NODE));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (selectedInt != null) {
            this.getModel().setSelectedNode(selectedInt);
        } else {
            this.getModel().setSelectedNode(null);
        }
        ArrayList openNodes = (ArrayList)m.get(OPEN_CONTAINERS);
        if (openNodes != null) {
            int size = openNodes.size();
            for (int i = 0; i < size; ++i) {
                Integer id = (Integer)openNodes.get(i);
                CCNavNodeInterface node = this.getModel().getNodeById(id);
                if (node != null) {
                    node.setExpanded(true);
                    continue;
                }
                CCDebug.trace1("Open node from state map with id of " + id + " was not found.");
            }
        }
    }

    public boolean yokeTo(int nodeId) {
        return this.yokeTo(nodeId, false);
    }

    public boolean yokeTo(int nodeId, boolean openUrl) {
        this.restoreStateData();
        CCNavNodeInterface node = this.getModel().getNodeById(nodeId);
        if (node == null) {
            return false;
        }
        if (openUrl) {
            this.setDisplayFieldValue(CHILD_HIDDEN_URL, node.getValue());
        }
        this.getModel().setSelectedNode(node);
        HashMap<String, List> map = new HashMap<String, List>();
        List openContainers = this.getModel().getOpenContainers();
        for (CCNavNodeInterface parent = node.getParent(); parent != null; parent = parent.getParent()) {
            parent.setExpanded(true);
            if (openContainers.contains(new Integer(parent.getId()))) continue;
            openContainers.add(new Integer(parent.getId()));
        }
        map.put(OPEN_CONTAINERS, openContainers);
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)((HashMap)this.getStateData()));
        return true;
    }

    public boolean yokeTo(CCNavNodeInterface node) {
        if (node == null) {
            return false;
        }
        return this.yokeTo(node.getId());
    }

    public boolean yokeTo(CCNavNodeInterface node, boolean openUrl) {
        if (node == null) {
            return false;
        }
        return this.yokeTo(node.getId(), openUrl);
    }

    public String endChildDisplay(ChildContentDisplayEvent event) throws ModelControlException {
        System.out.println(event.getChildName());
        return event.getContent();
    }
}

