/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.server.notification;

import com.sun.enterprise.admin.jmx.remote.notification.ListenerInfo;
import com.sun.enterprise.admin.jmx.remote.server.notification.NotificationConnection;
import com.sun.enterprise.admin.jmx.remote.server.notification.NotificationListenerProxy;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerNotificationManager
implements Runnable {
    private HashMap connections = null;
    private HashMap listenerMap = null;
    private boolean exiting = false;
    private Thread keepAliveThr = null;
    private MBeanServerConnection mbsc = null;
    private int bufsiz = 50;
    private static final Logger logger = Logger.getLogger("com.sun.logging.enterprise.system.admin.jmx.connector");

    public ServerNotificationManager(MBeanServerConnection mbsc) {
        this.mbsc = mbsc;
        this.connections = new HashMap();
        this.listenerMap = new HashMap();
        this.keepAliveThr = new Thread(this);
        this.keepAliveThr.start();
    }

    public void setBufSiz(ServletConfig cfg) {
        String bsiz = cfg.getInitParameter("com.sun.jmx.remote.http.notification.bufsize");
        if (bsiz == null || bsiz.trim().length() == 0) {
            bsiz = System.getProperty("com.sun.web.jmx.connector.notification.bufsiz");
        }
        try {
            this.bufsiz = Integer.parseInt(bsiz);
        }
        catch (NumberFormatException nume) {
            this.bufsiz = 50;
        }
        if (this.bufsiz <= 10) {
            this.bufsiz = 50;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(String id, boolean unregisterNotifications) {
        NotificationConnection conn = (NotificationConnection)this.connections.get(id);
        if (conn != null) {
            if (unregisterNotifications) {
                this.unregisterNotifications(id);
            }
            this.connections.remove(id);
            conn.close();
            NotificationConnection notificationConnection = conn;
            synchronized (notificationConnection) {
                conn.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterNotifications(String id) {
        HashMap hashMap = this.listenerMap;
        synchronized (hashMap) {
            for (ObjectName mbean : this.listenerMap.keySet()) {
                ArrayList list = (ArrayList)this.listenerMap.get(mbean);
                int len = list.size();
                for (int i = 0; i < len; ++i) {
                    ListenerInfo info = (ListenerInfo)list.get(i);
                    if (info.proxy == null || ((NotificationListenerProxy)info.proxy).getId() != id) continue;
                    list.remove(i);
                    try {
                        this.mbsc.removeNotificationListener(mbean, (NotificationListener)info.proxy);
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.listenerMap.put(mbean, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNotifications(HttpServletRequest req, HttpServletResponse res) {
        String id = req.getParameter("id");
        String cmd = req.getParameter("cmd");
        res.setStatus(200);
        res.setHeader("Content-Type", "application/octet-stream");
        res.setHeader("Connection", "Keep-Alive");
        if (cmd != null && cmd.trim().equals("close")) {
            HashMap hashMap = this.connections;
            synchronized (hashMap) {
                this.closeConnection(id, true);
            }
            return;
        }
        NotificationConnection connection = null;
        try {
            ServletOutputStream out = res.getOutputStream();
            HashMap hashMap = this.connections;
            synchronized (hashMap) {
                connection = (NotificationConnection)this.connections.get(id);
                if (connection == null) {
                    connection = new NotificationConnection((OutputStream)out, this.bufsiz);
                    this.connections.put(id, connection);
                } else {
                    connection.reinit((OutputStream)out);
                }
            }
            out.flush();
        }
        catch (IOException ioex) {
            try {
                res.sendError(503, "Unable to send notifications, since OutputStream could not be opened");
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
        NotificationConnection notificationConnection = connection;
        synchronized (notificationConnection) {
            while (!connection.hasIOExceptionOccurred()) {
                try {
                    connection.wait();
                    break;
                }
                catch (InterruptedException intre) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.exiting = true;
        while (true) {
            try {
                this.keepAliveThr.join();
            }
            catch (InterruptedException intr) {
                continue;
            }
            break;
        }
        Object conn = null;
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            HashMap conns = (HashMap)this.connections.clone();
            for (String id : conns.keySet()) {
                this.closeConnection(id, false);
            }
        }
    }

    public boolean isExiting() {
        return this.exiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.isExiting()) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException intrEx) {
                // empty catch block
            }
            if (this.isExiting()) break;
            Iterator itr = this.getConnectionsIterator();
            NotificationConnection conn = null;
            HashMap hashMap = this.connections;
            synchronized (hashMap) {
                while (itr.hasNext() && !this.isExiting()) {
                    String id = (String)itr.next();
                    conn = (NotificationConnection)this.connections.get(id);
                    conn.fireWaitNotif();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator getConnectionsIterator() {
        Iterator itr = null;
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            itr = this.connections.keySet().iterator();
        }
        return itr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNotification(NotificationListenerProxy proxy) {
        String id = proxy.getId();
        if (id == null || id.trim().length() == 0) {
            return;
        }
        NotificationConnection conn = null;
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            conn = (NotificationConnection)this.connections.get(id);
        }
        if (conn == null) {
            return;
        }
        conn.fireNotification(proxy.getNotificationWrapper());
    }

    private synchronized void addListenerInfo(ObjectName mbean, ListenerInfo info) {
        ArrayList<ListenerInfo> list = (ArrayList<ListenerInfo>)this.listenerMap.get(mbean);
        if (list == null) {
            list = new ArrayList<ListenerInfo>();
        }
        list.add(info);
        this.listenerMap.put(mbean, list);
    }

    public String addObjNameNotificationListener(ObjectName mbean, NotificationFilter filter, Object handback, String id) {
        ListenerInfo info = new ListenerInfo();
        info.filter = filter;
        info.handback = handback;
        info.id = id;
        this.addListenerInfo(mbean, info);
        return info.id;
    }

    public String addNotificationListener(ObjectName mbean, String id, Object proxy) {
        ListenerInfo info = new ListenerInfo();
        info.id = id;
        info.proxy = proxy;
        this.addListenerInfo(mbean, info);
        return info.id;
    }

    private synchronized Object removeListenerInfo(ObjectName mbean, String id, boolean getProxy) {
        ArrayList list = (ArrayList)this.listenerMap.get(mbean);
        Iterator itr = null;
        if (list == null) {
            return null;
        }
        for (ListenerInfo info : list) {
            if (!info.id.equals(id)) continue;
            list.remove(list.indexOf(info));
            Object retObj = null;
            retObj = getProxy ? info.proxy : info;
            return retObj;
        }
        return null;
    }

    public ListenerInfo removeObjNameNotificationListener(ObjectName mbean, String id) {
        return (ListenerInfo)this.removeListenerInfo(mbean, id, false);
    }

    public Object removeNotificationListener(ObjectName mbean, String id) {
        return this.removeListenerInfo(mbean, id, true);
    }
}

