/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.server.rmi;

import com.sun.enterprise.admin.jmx.remote.IStringManager;
import com.sun.enterprise.admin.jmx.remote.StringManagerFactory;
import com.sun.enterprise.admin.jmx.remote.server.rmi.JmxServiceUrlFactory;
import com.sun.enterprise.admin.jmx.remote.server.rmi.RemoteJmxProtocol;
import com.sun.enterprise.admin.jmx.remote.server.rmi.RmiStubRegistryHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class JmxConnectorServerDriver {
    private static IStringManager sm = StringManagerFactory.getServerStringManager(JmxConnectorServerDriver.class);
    private final Map env = new HashMap();
    private JMXServiceURL url;
    private JMXServiceURL jconsoleurl;
    private int port;
    private RemoteJmxProtocol protocol = RemoteJmxProtocol.RMIJRMP;
    private boolean secureRegistry = false;
    private boolean ssl = false;
    private RMIServerSocketFactory rmissf;
    private RMIClientSocketFactory rmicsf;
    private boolean auth = false;
    private JMXAuthenticator authenticator = null;
    private Logger logger;
    private MBeanServer mbs;

    public JmxConnectorServerDriver() {
        this.port = JmxConnectorServerDriver.getFreePort();
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public void setProtocol(RemoteJmxProtocol protocol) {
        this.protocol = protocol;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setRmiServerSocketFactory(RMIServerSocketFactory f) {
        if (this.ssl && f == null) {
            throw new IllegalArgumentException("Internal: null server socket factory passed with ssl ON");
        }
        this.rmissf = f;
    }

    public void setRmiClientSocketFactory(RMIClientSocketFactory f) {
        if (this.ssl && f == null) {
            throw new IllegalArgumentException("Internal: null client socket factory passed with ssl ON");
        }
        this.rmicsf = f;
    }

    public void setAuthentication(boolean auth) {
        this.auth = auth;
    }

    public void setLogger(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("Internal: null logger");
        }
        this.logger = logger;
    }

    public void setAuthenticator(JMXAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setRmiRegistrySecureFlag(boolean secure) {
        this.secureRegistry = secure;
    }

    public void setMBeanServer(MBeanServer mbs) {
        if (mbs == null) {
            throw new IllegalArgumentException("null mbs");
        }
        this.mbs = mbs;
    }

    public JMXConnectorServer startConnectorServer() throws IOException {
        this.prepare();
        this.formJmxServiceUrl();
        this.createEnvironment();
        JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(this.url, this.env, this.mbs);
        cs.start();
        this.logStartup(cs);
        return cs;
    }

    public JMXConnectorServer startJconsoleConnectorServer() throws IOException {
        SslRMIClientSocketFactory cf = new SslRMIClientSocketFactory();
        HashMap<String, SslRMIClientSocketFactory> jconsoleenv = new HashMap<String, SslRMIClientSocketFactory>(this.env);
        if (this.ssl) {
            jconsoleenv.put("jmx.remote.rmi.client.socket.factory", cf);
        }
        JMXConnectorServer jconsolecs = JMXConnectorServerFactory.newJMXConnectorServer(this.jconsoleurl, jconsoleenv, this.mbs);
        jconsolecs.start();
        this.logJconsoleStartup(jconsolecs);
        return jconsolecs;
    }

    public void stopConnectorServer(JMXConnectorServer cs) throws IOException {
        String cad = cs.getAddress().toString();
        if (cs.isActive()) {
            this.logger.log(Level.FINE, "rjmx.lc.stopping", cad);
            cs.stop();
        } else {
            String msg = "JMX Connector Server: " + cad + " is not active";
            this.logger.fine(msg);
        }
    }

    private void logStartup(JMXConnectorServer cs) {
        this.logger.log(Level.FINE, "rjmx.lc.address", cs.getAddress().toString());
        this.logger.log(Level.FINE, "rjmx.lc.status", "" + cs.isActive());
    }

    private void logJconsoleStartup(JMXConnectorServer cs) {
        this.logger.log(Level.INFO, "rjmx.std.address", cs.getAddress().toString());
        this.logger.log(Level.INFO, "rjmx.std.status", "" + cs.isActive());
    }

    private void formJmxServiceUrl() {
        if (this.protocol == RemoteJmxProtocol.RMIJRMP) {
            this.url = JmxServiceUrlFactory.forRmiWithJndiInAppserver(JmxServiceUrlFactory.localhost(), this.port);
            this.jconsoleurl = JmxServiceUrlFactory.forJconsoleOverRmiWithJndiInAppserver(JmxServiceUrlFactory.localhost(), this.port);
        }
    }

    private void prepare() {
        if (this.protocol == RemoteJmxProtocol.RMIJRMP) {
            new RmiStubRegistryHandler(this.port, this.secureRegistry, this.logger);
        }
    }

    private void createEnvironment() {
        this.env.clear();
        this.handleSsl();
        this.handleAuth();
    }

    private void handleSsl() {
        if (this.protocol == RemoteJmxProtocol.RMIJRMP) {
            this.env.put("jmx.remote.rmi.server.socket.factory", this.rmissf);
        }
        if (this.ssl) {
            this.env.put("jmx.remote.rmi.client.socket.factory", this.rmicsf);
        }
    }

    private void handleAuth() {
        if ((this.protocol == RemoteJmxProtocol.RMIJRMP || this.protocol == RemoteJmxProtocol.RMIIIOP) && this.auth) {
            if (this.authenticator == null) {
                String msg = "Internal: The authentication is on, but the authenticator is null";
                throw new IllegalArgumentException("msg");
            }
            this.env.put("jmx.remote.authenticator", this.authenticator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFreePort() {
        int freePort = 0;
        boolean portFound = false;
        ServerSocket serverSocket = null;
        Class<JmxConnectorServerDriver> clazz = JmxConnectorServerDriver.class;
        synchronized (JmxConnectorServerDriver.class) {
            try {
                serverSocket = new ServerSocket(0);
                freePort = serverSocket.getLocalPort();
                portFound = true;
            }
            catch (Exception e) {
            }
            finally {
                if (!portFound) {
                    freePort = 0;
                }
                try {
                    if (serverSocket != null) {
                        serverSocket.close();
                        if (!serverSocket.isClosed()) {
                            throw new Exception("local exception ...");
                        }
                    }
                }
                catch (Exception e) {
                    freePort = 0;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return freePort;
        }
    }
}

