/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi;

import com.sun.enterprise.admin.monitor.registry.spi.StatsDescriptionHelper;
import com.sun.enterprise.admin.monitor.stats.AverageRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableBoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableTimeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.StatisticImpl;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.Statistic;

final class StatisticWorkaround {
    private static final StatsDescriptionHelper helper = new StatsDescriptionHelper();
    private static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    StatisticWorkaround() {
    }

    static final Statistic[] populateDescriptions(Statistic[] from) {
        if (from == null) {
            throw new IllegalArgumentException("null arg");
        }
        int length = from.length;
        Statistic[] to = new Statistic[length];
        for (int i = 0; i < length; ++i) {
            Statistic as = from[i];
            String name = as.getName();
            String desc = helper.getDescription(name);
            if ("No Description was available".equals(desc)) {
                to[i] = from[i];
                continue;
            }
            StatisticWorkaround.attemptSettingDescription(as, desc);
            to[i] = as;
        }
        return to;
    }

    private static void attemptSettingDescription(Statistic s, String nd) {
        if (s instanceof StatisticImpl) {
            ((StatisticImpl)s).setDescription(nd);
            logger.finest("New Description was set: " + nd);
        } else if (s instanceof AverageRangeStatisticImpl) {
            ((AverageRangeStatisticImpl)s).setDescription(nd);
            logger.finest("New Description was set: " + nd);
        } else if (s instanceof MutableBoundedRangeStatisticImpl) {
            ((MutableBoundedRangeStatisticImpl)s).setDescription(nd);
            logger.finest("New Description was set: " + nd);
        } else if (s instanceof MutableCountStatisticImpl) {
            ((MutableCountStatisticImpl)s).setDescription(nd);
            logger.finest("New Description was set: " + nd);
        } else if (s instanceof MutableTimeStatisticImpl) {
            ((MutableTimeStatisticImpl)s).setDescription(nd);
            logger.finest("New Description was set: " + nd);
        }
    }
}

