/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.HashMap;

public class RepositoryConfig
extends HashMap {
    public static final String K_INSTALL_ROOT = "install.root";
    public static final String K_CONFIG_ROOT = "config.root";
    private String _repositoryName;
    private String _repositoryRoot;
    private String _instanceName;
    private String _configurationName;

    public RepositoryConfig(String repositoryName, String repositoryRoot, String instanceName, String configName) {
        this._instanceName = instanceName;
        this._repositoryName = repositoryName;
        this._repositoryRoot = repositoryRoot;
        this._configurationName = configName;
        this.put(K_INSTALL_ROOT, this.getFilePath("com.sun.aas.installRoot"));
        this.put(K_CONFIG_ROOT, this.getFilePath("com.sun.aas.configRoot"));
    }

    public RepositoryConfig(String repositoryName, String repositoryRoot, String instanceName) {
        this(repositoryName, repositoryRoot, instanceName, null);
    }

    public RepositoryConfig(String repositoryName, String repositoryRoot) {
        this(repositoryName, repositoryRoot, null);
    }

    public RepositoryConfig() {
        File instanceRoot = new File(System.getProperty("com.sun.aas.instanceRoot"));
        File repositoryDir = instanceRoot.getParentFile();
        this._instanceName = instanceRoot.getName();
        this._repositoryName = repositoryDir.getName();
        this._repositoryRoot = FileUtils.makeForwardSlashes(repositoryDir.getParentFile().getAbsolutePath());
        this._configurationName = null;
        this.put(K_INSTALL_ROOT, this.getFilePath("com.sun.aas.installRoot"));
        this.put(K_CONFIG_ROOT, this.getFilePath("com.sun.aas.configRoot"));
    }

    public String toString() {
        return "repositoryRoot " + this._repositoryRoot + " repositoryName " + this._repositoryName + " instanceName " + this._instanceName + " configurationName " + this._configurationName;
    }

    protected String getFilePath(String propertyName) {
        File f = new File(System.getProperty(propertyName));
        return FileUtils.makeForwardSlashes(f.getAbsolutePath());
    }

    public void setConfigurationName(String configurationName) {
        this._configurationName = configurationName;
    }

    public String getConfigurationName() {
        return this._configurationName;
    }

    public String getDisplayName() {
        return this.getRepositoryName();
    }

    public void setInstanceName(String instanceName) {
        this._instanceName = instanceName;
    }

    public String getInstanceName() {
        return this._instanceName;
    }

    public String getRepositoryName() {
        return this._repositoryName;
    }

    protected void setRepositoryRoot(String repositoryRoot) {
        this._repositoryRoot = repositoryRoot;
    }

    public String getRepositoryRoot() {
        return this._repositoryRoot;
    }

    public String getInstallRoot() {
        return (String)this.get(K_INSTALL_ROOT);
    }

    public String getConfigRoot() {
        return (String)this.get(K_CONFIG_ROOT);
    }
}

