/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.lifecycle;

import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.wsmgmt.WebServiceMgrBackEnd;
import com.sun.enterprise.admin.wsmgmt.filter.impl.AggregateStatsFilter;
import com.sun.enterprise.admin.wsmgmt.filter.spi.FilterRegistry;
import com.sun.enterprise.admin.wsmgmt.lifecycle.WSMonitoringLevelListener;
import com.sun.enterprise.admin.wsmgmt.stats.impl.WebServiceEndpointStatsImpl;
import com.sun.enterprise.admin.wsmgmt.stats.impl.WebServiceEndpointStatsProviderImpl;
import com.sun.enterprise.admin.wsmgmt.stats.spi.StatsProviderManager;
import com.sun.enterprise.server.ApplicationServer;

class EndpointRegistration {
    private static MonitoringRegistry registry = ApplicationServer.getServerContext().getMonitoringRegistry();
    private String ctxRoot = null;
    String name = null;
    String moduleName = null;
    boolean isStandAlone = false;
    String vs = null;
    String j2eeAppName = null;
    boolean isEjbModule = false;
    String endpoint = null;

    public EndpointRegistration(String n, String modName, String cRoot, boolean isSA, String v, String appName, boolean isEjb) {
        this.name = n;
        this.moduleName = modName;
        this.ctxRoot = cRoot;
        if (this.ctxRoot != null && this.ctxRoot.length() > 0 && this.ctxRoot.charAt(0) != '/') {
            this.ctxRoot = "/" + this.ctxRoot;
        }
        if ("".equals(this.ctxRoot)) {
            this.ctxRoot = "/";
        }
        this.isStandAlone = isSA;
        this.vs = v;
        this.j2eeAppName = appName;
        this.isEjbModule = isEjb;
        this.endpoint = WebServiceMgrBackEnd.getManager().getFullyQualifiedName(this.j2eeAppName, this.moduleName, this.name);
    }

    public void enableLOW() throws MonitoringRegistrationException {
        AggregateStatsFilter f = new AggregateStatsFilter();
        FilterRegistry.getInstance().registerFilter("PRE_PROCESS_REQUEST", this.endpoint, f);
        FilterRegistry.getInstance().registerFilter("POST_PROCESS_RESPONSE", this.endpoint, f);
        WebServiceEndpointStatsProviderImpl prov = new WebServiceEndpointStatsProviderImpl();
        StatsProviderManager.getInstance().registerEndpointStatsProvider(this.endpoint, prov);
        WSMonitoringLevelListener listener = new WSMonitoringLevelListener(this.name, this.moduleName, this.ctxRoot, this.isStandAlone, this.vs, this.j2eeAppName, this.isEjbModule);
        WebServiceEndpointStatsImpl stats = new WebServiceEndpointStatsImpl(prov);
        String appName = null;
        appName = this.isStandAlone ? null : this.j2eeAppName;
        if (this.isEjbModule) {
            registry.registerWSAggregateStatsForEjb(stats, this.name, this.moduleName, appName, listener);
        } else {
            registry.registerWSAggregateStatsForWeb(stats, this.name, this.moduleName, this.ctxRoot, appName, this.vs, listener);
        }
    }

    public void disableLOW() throws MonitoringRegistrationException {
        FilterRegistry.getInstance().unregisterFilterByName("PRE_PROCESS_REQUEST", this.endpoint, "AggregateStatsFilter");
        FilterRegistry.getInstance().unregisterFilterByName("POST_PROCESS_RESPONSE", this.endpoint, "AggregateStatsFilter");
        if (this.isEjbModule) {
            registry.unregisterWSAggregateStatsForEjb(this.name, this.moduleName, this.j2eeAppName);
        } else {
            registry.unregisterWSAggregateStatsForWeb(this.name, this.moduleName, this.ctxRoot, this.j2eeAppName, this.vs);
        }
        StatsProviderManager.getInstance().unregisterEndpointStatsProvider(this.endpoint);
    }
}

