/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.msg;

import com.sun.appserv.management.ext.wsmgmt.MessageTrace;
import com.sun.enterprise.admin.wsmgmt.config.spi.WebServiceConfig;
import com.sun.enterprise.admin.wsmgmt.filter.spi.FilterRegistry;
import com.sun.enterprise.admin.wsmgmt.msg.MessageFilter;
import com.sun.enterprise.admin.wsmgmt.pool.impl.BoundedPool;
import com.sun.enterprise.admin.wsmgmt.pool.spi.Pool;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Collection;
import java.util.logging.Logger;

class EndpointHandler {
    private MessageFilter _filter = null;
    private Pool _pool = null;
    private String _endpointId = null;
    private String _applicationId = null;
    private static final String DELIM = "#";
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager _stringMgr = StringManager.getManager(EndpointHandler.class);

    EndpointHandler(WebServiceConfig wsc, String appId) {
        this._applicationId = appId;
        this._endpointId = wsc.getName();
        String mLevel = wsc.getMonitoringLevel();
        if ("HIGH".equals(mLevel)) {
            this._pool = new BoundedPool(wsc.getName(), wsc.getMaxHistorySize());
            this.registerFilter();
        }
    }

    EndpointHandler(String endpoint, int size, String appId) {
        this._applicationId = appId;
        this._endpointId = endpoint;
        this._pool = new BoundedPool(endpoint, size);
        this.registerFilter();
    }

    private void registerFilter() {
        this._filter = new MessageFilter(this._applicationId, this._endpointId, this);
        FilterRegistry fr = FilterRegistry.getInstance();
        String endpoint = this.getFQEndpointName();
        fr.registerFilter("PROCESS_REQUEST", endpoint, this._filter);
        fr.registerFilter("PROCESS_RESPONSE", endpoint, this._filter);
        fr.registerFilter("POST_PROCESS_RESPONSE", endpoint, this._filter);
    }

    void setMessageHistorySize(int size) {
        if (this._pool != null) {
            this._pool.resize(size);
            _logger.fine("Set message history size to " + size + " for " + this.getEndpointName());
        }
    }

    void destroy() {
        if (this._pool != null) {
            this._pool.clear();
            this._pool = null;
        }
        if (this._filter != null) {
            FilterRegistry fr = FilterRegistry.getInstance();
            String endpoint = this.getFQEndpointName();
            fr.unregisterFilter("PROCESS_REQUEST", endpoint, this._filter);
            fr.unregisterFilter("PROCESS_RESPONSE", endpoint, this._filter);
            fr.unregisterFilter("POST_PROCESS_RESPONSE", endpoint, this._filter);
            this._filter = null;
        }
        _logger.finer("Message trace handler destroyed for " + this.getEndpointName());
    }

    Collection getMessages() {
        return this._pool.values();
    }

    void addMessage(MessageTrace msgTrace) {
        this._pool.put(msgTrace.getMessageID(), msgTrace);
    }

    String getEndpointName() {
        return this._endpointId;
    }

    String getFQEndpointName() {
        return this._applicationId + DELIM + this._endpointId;
    }
}

