/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.msg;

import com.sun.appserv.management.ext.wsmgmt.MessageTrace;
import com.sun.appserv.management.ext.wsmgmt.MessageTraceImpl;
import com.sun.enterprise.admin.wsmgmt.SOAPMessageContext;
import com.sun.enterprise.admin.wsmgmt.filter.spi.FilterContext;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.webservice.monitoring.TransportInfo;
import com.sun.enterprise.webservice.monitoring.TransportType;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.coyote.tomcat5.CoyoteRequestFacade;

class MessageTraceFactory {
    private Map _messages = new HashMap();
    private static MessageTraceFactory _instance = null;
    private Pattern _msgBodyPattern = Pattern.compile("<env:Body>.*</env:Body>");
    private static final String HTTP_REQUEST = "com.sun.xml.rpc.server.http.HttpServletRequest";
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager _stringMgr = StringManager.getManager(MessageTraceFactory.class);

    static MessageTraceFactory getInstance() {
        if (_instance == null) {
            _instance = new MessageTraceFactory();
        }
        return _instance;
    }

    private MessageTraceFactory() {
    }

    void processRequest(FilterContext ctx, String appId) {
        String messageId = ctx.getMessageId();
        MessageTraceImpl trace = new MessageTraceImpl(messageId, "com.sun.appserv.management.ext.wsmgmt.MessageTrace");
        trace.setTimeStamp(System.currentTimeMillis());
        trace.setEndpointName(ctx.getFullyQualifiedName());
        trace.setApplicationID(appId);
        trace.setCallFlowEnabled(ctx.isCallFlowEnabled());
        this.setRequestInfo(ctx.getMessageContext(), trace);
        this.setTransportType(ctx, trace);
        this.setClientHost(ctx.getMessageContext(), trace);
        this._messages.put(messageId, trace);
    }

    private void setClientHost(SOAPMessageContext smc, MessageTraceImpl trace) {
        if (smc != null) {
            Iterator iter = smc.getPropertyNames();
            if (iter == null) {
                return;
            }
            CoyoteRequestFacade httpReq = (CoyoteRequestFacade)smc.getProperty(HTTP_REQUEST);
            String clientHost = null;
            if (httpReq != null) {
                clientHost = httpReq.getRemoteAddr();
                trace.setClientHost(clientHost);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRequestInfo(SOAPMessageContext ctx, MessageTraceImpl trace) {
        ByteArrayOutputStream baos = null;
        try {
            trace.setHTTPRequestHeaders(ctx.getHTTPRequestHeaders());
            baos = this.getMsgAsBytes(ctx);
            trace.setRequestSize(baos.size());
            String soapMsg = baos.toString();
            trace.setRequestContent(soapMsg);
        }
        catch (Exception e) {
            String msg = _stringMgr.getString("MessageTraceFactory_NoMessageTrace", (Object)e.getMessage());
            _logger.log(Level.INFO, msg);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Web Service message stream could not be closed : " + e.getMessage());
            }
        }
    }

    private void setTransportType(FilterContext ctx, MessageTraceImpl trace) {
        TransportInfo ti = ctx.getTransportInfo();
        if (ti != null) {
            TransportType type = ti.getTransportType();
            trace.setTransportType(type.name());
        }
    }

    void processResponse(FilterContext ctx) {
        String messageId = ctx.getMessageId();
        MessageTraceImpl trace = (MessageTraceImpl)this._messages.get(messageId);
        SOAPMessageContext mctx = ctx.getMessageContext();
        this.setResponseInfo(mctx, trace);
        this.setCallerPrincipal(trace);
        this.setFaultInfo(mctx, trace);
    }

    MessageTrace postProcessResponse(FilterContext ctx) {
        String messageId = ctx.getMessageId();
        MessageTraceImpl trace = (MessageTraceImpl)this._messages.remove(messageId);
        this.setResponseTime(trace, ctx.getExecutionTime());
        return trace;
    }

    private void setFaultInfo(SOAPMessageContext smc, MessageTraceImpl trace) {
        if (smc != null) {
            SOAPMessage sm = smc.getMessage();
            try {
                SOAPFault fault;
                SOAPBody sb;
                if (sm != null && (sb = sm.getSOAPBody()) != null && (fault = sb.getFault()) != null) {
                    trace.setFaultCode(fault.getFaultCode());
                    trace.setFaultString(fault.getFaultString());
                    trace.setFaultActor(fault.getFaultString());
                }
            }
            catch (SOAPException se) {
                String msg = "Error while reading SOAP fault information";
                _logger.log(Level.FINE, msg, se);
            }
        }
    }

    private void setCallerPrincipal(MessageTraceImpl trace) {
        Principal p;
        SecurityContext sc = SecurityContext.getCurrent();
        if (sc != null && (p = sc.getCallerPrincipal()) != null) {
            trace.setPrincipalName(p.getName());
            _logger.fine("[MTF] Caller Principal: " + p.getName());
        }
    }

    private void setResponseTime(MessageTraceImpl trace, long t) {
        trace.setResponseTime(t);
    }

    private ByteArrayOutputStream getMsgAsBytes(SOAPMessageContext smc) {
        ByteArrayOutputStream baos = null;
        if (smc != null) {
            baos = new ByteArrayOutputStream();
            try {
                smc.getMessage().writeTo((OutputStream)baos);
            }
            catch (Exception e) {
                String msg = "Error while retrieving SOAP message";
                _logger.log(Level.FINE, msg, e);
            }
        }
        return baos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResponseInfo(SOAPMessageContext ctx, MessageTraceImpl trace) {
        ByteArrayOutputStream baos = null;
        try {
            baos = this.getMsgAsBytes(ctx);
            if (baos == null) {
                return;
            }
            trace.setResponseSize(baos.size());
            String soapMsg = baos.toString();
            trace.setResponseContent(soapMsg);
            trace.setHTTPResponseHeaders(ctx.getHTTPResponseHeaders());
        }
        catch (Exception e) {
            String msg = _stringMgr.getString("MessageTraceFactory_NoMessageTrace", (Object)e.getMessage());
            _logger.log(Level.INFO, msg);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Web Service message stream could not be closed : " + e.getMessage());
            }
        }
    }
}

