/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.msg;

import com.sun.appserv.management.ext.wsmgmt.MessageTrace;
import com.sun.enterprise.admin.wsmgmt.config.spi.ConfigFactory;
import com.sun.enterprise.admin.wsmgmt.config.spi.ConfigProvider;
import com.sun.enterprise.admin.wsmgmt.msg.ApplicationMediator;
import com.sun.enterprise.admin.wsmgmt.msg.MessageTraceException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageTraceMgr {
    private Map _applications = new Hashtable();
    private static MessageTraceMgr _instance = null;
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager _stringMgr = StringManager.getManager(MessageTraceMgr.class);

    public static MessageTraceMgr getInstance() {
        if (_instance == null) {
            _instance = new MessageTraceMgr();
        }
        return _instance;
    }

    private MessageTraceMgr() {
    }

    public void init() {
        try {
            ConfigFactory cf = ConfigFactory.getConfigFactory();
            ConfigProvider cp = cf.getConfigProvider();
            List list = cp.getManagedWebserviceApplicationIds();
            for (String appId : list) {
                try {
                    ApplicationMediator am = new ApplicationMediator(appId);
                    this._applications.put(appId, am);
                }
                catch (MessageTraceException me) {
                    String msg = "Initialization error for application: " + appId;
                    _logger.log(Level.FINE, msg, me);
                }
            }
        }
        catch (Exception e) {
            String msg = "Configuration initialization error.";
            _logger.log(Level.FINE, msg, e);
        }
    }

    public void disable(String appId, String endpoint) throws MessageTraceException {
        ApplicationMediator am = (ApplicationMediator)this._applications.get(appId);
        if (am != null) {
            am.disable(endpoint);
            if (am.isEmpty()) {
                this._applications.remove(appId);
            }
        } else {
            String msg = _stringMgr.getString("MessageTraceMgr_InvalidAppEx", (Object)appId, (Object)endpoint);
            throw new MessageTraceException(msg);
        }
    }

    public void enable(String appId, String endpoint, int size) throws MessageTraceException {
        ApplicationMediator am = (ApplicationMediator)this._applications.get(appId);
        if (am != null) {
            am.enable(endpoint, size);
        } else {
            am = new ApplicationMediator(appId);
            am.enable(endpoint, size);
            this._applications.put(appId, am);
        }
    }

    public void setMessageHistorySize(String appId, String endpoint, int size) throws MessageTraceException {
        ApplicationMediator am = (ApplicationMediator)this._applications.get(appId);
        if (am == null) {
            String msg = _stringMgr.getString("MessageTraceMgr_InvalidAppEx", (Object)appId, (Object)endpoint);
            throw new MessageTraceException(msg);
        }
        am.setMessageHistorySize(endpoint, size);
    }

    public void stop() {
        Collection mediators = this._applications.values();
        for (ApplicationMediator am : mediators) {
            am.destroy();
        }
        this._applications.clear();
    }

    public MessageTrace[] getMessages() {
        ArrayList c = new ArrayList();
        Collection mediators = this._applications.values();
        for (ApplicationMediator am : mediators) {
            c.addAll(am.getMessages());
        }
        MessageTrace[] trace = new MessageTrace[c.size()];
        return c.toArray(trace);
    }

    public MessageTrace[] getMessages(String appId, String endpoint) {
        Collection c = null;
        ApplicationMediator am = (ApplicationMediator)this._applications.get(appId);
        if (am != null) {
            c = am.getMessages(endpoint);
        }
        MessageTrace[] trace = null;
        if (c != null) {
            trace = new MessageTrace[c.size()];
            return c.toArray(trace);
        }
        return null;
    }
}

