/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.transform;

import com.sun.enterprise.admin.wsmgmt.SOAPMessageContext;
import com.sun.enterprise.admin.wsmgmt.config.spi.TransformationRule;
import com.sun.enterprise.admin.wsmgmt.filter.spi.FilterContext;
import com.sun.enterprise.admin.wsmgmt.transform.FilterData;
import com.sun.enterprise.admin.wsmgmt.transform.TransformException;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class FilterChain {
    LinkedList filterList = new LinkedList();
    XMLReader _reader = null;
    SAXTransformerFactory _stf = null;
    Transformer _transformer = null;
    static final int STRING_WRITER_INIT_SIZE = 4028;
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager _stringMgr = StringManager.getManager(FilterChain.class);

    public FilterChain() throws TransformException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser parser = spf.newSAXParser();
            this._reader = parser.getXMLReader();
            this._stf = (SAXTransformerFactory)TransformerFactory.newInstance();
            this._transformer = this._stf.newTransformer();
        }
        catch (Exception e) {
            throw new TransformException(e);
        }
    }

    public synchronized void addFilter(TransformationRule[] tRules, boolean reverse) throws TransformException {
        if (tRules == null || tRules.length == 0) {
            return;
        }
        if (!reverse) {
            for (int idx = 0; idx < tRules.length; ++idx) {
                this.addFilter(idx, tRules[idx]);
            }
        } else {
            int index = 0;
            for (int idx = tRules.length - 1; idx > -1; --idx) {
                this.addFilter(index, tRules[idx]);
                ++index;
            }
        }
    }

    public synchronized void addFilter(int index, TransformationRule tRule) throws TransformException {
        try {
            if (tRule == null) {
                return;
            }
            String name = tRule.getName();
            File stylesheet = new File(tRule.getRuleFileLocation());
            if (!stylesheet.isAbsolute()) {
                String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
                stylesheet = new File(instanceRoot + File.separator + tRule.getRuleFileLocation());
            }
            XMLFilter filter = this._stf.newXMLFilter(new StreamSource(stylesheet));
            this.addToList(index, name, filter);
        }
        catch (Exception e) {
            String msg = _stringMgr.getString("rule_not_compiled", (Object)tRule.getRuleFileLocation(), (Object)tRule.getName());
            _logger.log(Level.WARNING, msg);
            throw new TransformException(e);
        }
    }

    public synchronized void removeFilter(int index) {
        this.removeFromList(index);
    }

    private void addToList(int index, String name, XMLFilter filter) {
        FilterData parent = null;
        if (index == 0) {
            parent = null;
            filter.setParent(this._reader);
        } else {
            FilterData child;
            parent = (FilterData)this.filterList.get(index - 1);
            filter.setParent(parent.getFilter());
            if (this.filterList.size() - 1 > index && (child = (FilterData)this.filterList.get(index)) != null) {
                child.getFilter().setParent(filter);
            }
        }
        this.filterList.add(index, new FilterData(name, filter));
    }

    private void removeFromList(int index) {
        FilterData current = (FilterData)this.filterList.get(index);
        if (current == null) {
            return;
        }
        FilterData parent = null;
        parent = index == 0 ? null : (FilterData)this.filterList.get(index - 1);
        FilterData child = null;
        if (index + 1 < this.filterList.size()) {
            child = (FilterData)this.filterList.get(index + 1);
        }
        if (child != null) {
            if (parent == null) {
                child.getFilter().setParent(this._reader);
            } else {
                child.getFilter().setParent(parent.getFilter());
            }
        }
    }

    public synchronized void process(FilterContext context) throws TransformException {
        if (this.filterList.size() == 0 || context == null) {
            return;
        }
        try {
            SOAPMessageContext smc = context.getMessageContext();
            SOAPMessage sm = smc.getMessage();
            SOAPPart sp = sm.getSOAPPart();
            Source s = sp.getContent();
            InputSource inputSrc = SAXSource.sourceToInputSource(s);
            SAXSource transformSource = new SAXSource(((FilterData)this.filterList.getLast()).getFilter(), inputSrc);
            StringWriter sw = new StringWriter(4028);
            StreamResult r = new StreamResult(sw);
            this._transformer.transform(transformSource, r);
            sw.flush();
            sw.close();
            StringBufferInputStream in = new StringBufferInputStream(sw.toString());
            MessageFactory mFactory = MessageFactory.newInstance();
            SOAPMessage resMsg = mFactory.createMessage(null, (InputStream)in);
            smc.setMessage(resMsg);
        }
        catch (Exception e) {
            _logger.fine("XSLT transformation failed for " + context.getFullyQualifiedName());
            throw new TransformException(e);
        }
    }
}

