/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldClustersMBean;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClusterConfigFactory
extends ConfigFactory {
    private final OldClustersMBean mOldClustersMBean = this.getOldConfigProxies().getOldClustersMBean();
    private static final String REFERENCED_CONFIG_NAME = "ReferencedConfigName";

    public ClusterConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs, Properties props) {
        Map<String, String> m = JMXUtil.attributeListToStringMap(translatedAttrs);
        String config = m.get("config-ref");
        String name = m.get("name");
        return this.mOldClustersMBean.createCluster(name, config, props);
    }

    @Override
    protected Map<String, String> getParamNameOverrides() {
        return MapUtil.newMap(REFERENCED_CONFIG_NAME, "config-ref");
    }

    private void checkConfigExists(String configName) {
        Map<String, ConfigConfig> configs = this.getDomainConfig().getConfigConfigMap();
        if (!configs.keySet().contains(configName)) {
            throw new IllegalArgumentException("No ConfigConfig exists with the name: " + configName);
        }
    }

    private boolean clusterExists(String name) {
        return this.getDomainConfig().getClusterConfigMap().keySet().contains(name);
    }

    public ObjectName create(String name, String configName, Map<String, String> optional) {
        if (configName != null) {
            this.checkNonEmptyString(configName, "configName");
            this.checkConfigExists(configName);
            if (configName.equals("server-config") || configName.equals("default-config")) {
                throw new IllegalArgumentException(configName);
            }
        }
        if (this.clusterExists(name)) {
            throw new IllegalArgumentException("Cluster already exists: " + ClusterConfigFactory.quote(name));
        }
        String[] requiredParams = new String[]{REFERENCED_CONFIG_NAME, configName};
        Map<String, String> params = this.initParams(name, requiredParams, optional);
        return this.createNamedChild(name, params);
    }

    public ObjectName create(String name, Map<String, String> optional) {
        return this.create(name, null, optional);
    }

    @Override
    protected void internalRemove(ObjectName objectName) {
        String name = Util.getName(objectName);
        if (!this.clusterExists(name)) {
            throw new IllegalArgumentException("No such cluster: " + ClusterConfigFactory.quote(name));
        }
        this.mOldClustersMBean.deleteCluster(name);
    }
}

