/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.config.LoadBalancerConfig;
import com.sun.appserv.management.monitor.LoadBalancerApplicationMonitor;
import com.sun.appserv.management.monitor.LoadBalancerClusterMonitor;
import com.sun.appserv.management.monitor.LoadBalancerContextRootMonitor;
import com.sun.appserv.management.monitor.LoadBalancerMonitor;
import com.sun.appserv.management.monitor.LoadBalancerServerMonitor;
import com.sun.enterprise.management.config.AMXConfigImplBase;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.LBDeregistrationUtil;
import com.sun.enterprise.management.support.ObjectNames;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class ClusterRefConfigImpl
extends AMXConfigImplBase
implements ConfigFactoryCallback {
    ClusterRefDeregistrationHelper mHelper = null;

    public ClusterRefConfigImpl(Delegate delegate) {
        super(delegate);
    }

    protected void unregisterMisc() {
        try {
            this.mHelper = new ClusterRefDeregistrationHelper(this.getName(), this.getMBeanServer());
        }
        catch (Exception ex) {
            this.logWarning("ClusterRefConfig unregisterMisc failed. ClusterRefDeregistrationHelper creation failed");
        }
    }

    public void postDeregister() {
        super.postDeregister();
        try {
            HashMap<String, LoadBalancerConfig> relevantLoadBalancerConfigMap = new HashMap();
            if (this.getContainer() instanceof LBConfig) {
                String lbConfigName = ((LBConfig)this.getContainer()).getName();
                relevantLoadBalancerConfigMap = this.mHelper.fetchLoadBalancerConfigs((LBConfig)this.getContainer());
                this.mHelper.unregisterMonitors(relevantLoadBalancerConfigMap);
            }
            this.mHelper = null;
        }
        catch (Exception ex) {
            this.logWarning("ClusterRefConfig postDeregistration failed. Load Balancer Monitoring MBeans might be lying around");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClusterRefDeregistrationHelper {
        static final String J2EE_TYPE = "j2eeType";
        final ObjectNames objectNames = ObjectNames.getInstance("amx");
        String clusterName = null;
        MBeanServer mbs = null;

        public ClusterRefDeregistrationHelper(String clusterName, MBeanServer mbs) {
            this.mbs = mbs;
            this.clusterName = clusterName;
        }

        Map<String, LoadBalancerConfig> fetchLoadBalancerConfigs(LBConfig lbConfig) {
            String lbConfigName = lbConfig.getName();
            Map<String, LoadBalancerConfig> allLoadBalancerConfigMap = ClusterRefConfigImpl.this.getDomainRoot().getDomainConfig().getLoadBalancerConfigMap();
            HashMap<String, LoadBalancerConfig> relevantLoadBalancerConfigMap = new HashMap<String, LoadBalancerConfig>();
            for (String loadBalancerName : allLoadBalancerConfigMap.keySet()) {
                LoadBalancerConfig loadBalancerConfig = allLoadBalancerConfigMap.get(loadBalancerName);
                if (!loadBalancerConfig.getLbConfigName().equals(lbConfigName)) continue;
                relevantLoadBalancerConfigMap.put(loadBalancerName, loadBalancerConfig);
            }
            return relevantLoadBalancerConfigMap;
        }

        void unregisterMonitors(Map<String, LoadBalancerConfig> relevantLoadBalancerConfigMap) throws JMException {
            for (String loadBalancerName : relevantLoadBalancerConfigMap.keySet()) {
                LoadBalancerMonitor loadBalancerMonitor = LBDeregistrationUtil.getInstance(this.mbs).fetchLBMonitoringRoot(loadBalancerName);
                Map<String, LoadBalancerClusterMonitor> lbcmMap = loadBalancerMonitor.getLoadBalancerClusterMonitorMap();
                LoadBalancerClusterMonitor lbcm = lbcmMap.get(this.clusterName);
                Map<String, LoadBalancerServerMonitor> lbsmMap = lbcm.getLoadBalancerServerMonitorMap();
                for (LoadBalancerServerMonitor lbsm : lbsmMap.values()) {
                    Map<String, LoadBalancerApplicationMonitor> lbamMap = lbsm.getLoadBalancerApplicationMonitorMap();
                    for (LoadBalancerApplicationMonitor lbam : lbamMap.values()) {
                        Map<String, LoadBalancerContextRootMonitor> lbcrmMap = lbam.getLoadBalancerContextRootMonitorMap();
                        for (LoadBalancerContextRootMonitor lbcrm : lbcrmMap.values()) {
                            ObjectName lbcrmObjName = Util.getObjectName(lbcrm);
                            this.mbs.unregisterMBean(lbcrmObjName);
                        }
                        ObjectName lbamObjName = Util.getObjectName(lbam);
                        this.mbs.unregisterMBean(lbamObjName);
                    }
                    ObjectName loadBalancerServerMonitorObjName = Util.getObjectName(lbsm);
                    this.mbs.unregisterMBean(loadBalancerServerMonitorObjName);
                }
                ObjectName lbcmObjName = Util.getObjectName(lbcm);
                this.mbs.unregisterMBean(lbcmObjName);
            }
        }
    }
}

