/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.config.LoadBalancerConfig;
import com.sun.appserv.management.ext.lb.LoadBalancer;
import com.sun.appserv.management.monitor.LoadBalancerApplicationMonitor;
import com.sun.appserv.management.monitor.LoadBalancerClusterMonitor;
import com.sun.appserv.management.monitor.LoadBalancerContextRootMonitor;
import com.sun.appserv.management.monitor.LoadBalancerMonitor;
import com.sun.appserv.management.monitor.LoadBalancerServerMonitor;
import com.sun.enterprise.management.config.AMXConfigImplBase;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.LBDeregistrationUtil;
import com.sun.enterprise.management.support.ObjectNames;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class LoadBalancerConfigImpl
extends AMXConfigImplBase {
    LoadBalancerDeregistrationHelper mHelper = null;
    String lbConfigName = null;

    public LoadBalancerConfigImpl(Delegate delegate) {
        super(delegate);
    }

    protected void unregisterMisc() {
        try {
            LoadBalancerConfig lbc = ProxyFactory.getInstance(this.getMBeanServer()).getDomainRoot().getDomainConfig().getLoadBalancerConfigMap().get(this.getName());
            LBConfig lbConfig = this.getDomainRoot().getDomainConfig().getLBConfigMap().get(this.lbConfigName);
            this.mHelper = new LoadBalancerDeregistrationHelper(this.getName(), lbConfig, this.getMBeanServer());
        }
        catch (Exception ex) {
            this.logWarning("LoadBalancerConfig unregisterMisc failed. LoadBalancerDeregistrationHelper creation failed");
        }
    }

    public void postRegisterHook(Boolean registrationSucceeded) {
        super.postRegisterHook(registrationSucceeded);
        if (registrationSucceeded.booleanValue()) {
            LoadBalancerConfig lbc = ProxyFactory.getInstance(this.getMBeanServer()).getDomainRoot().getDomainConfig().getLoadBalancerConfigMap().get(this.getName());
            this.lbConfigName = lbc.getLbConfigName();
        }
    }

    public void postDeregister() {
        super.postDeregister();
        try {
            this.mHelper.unregisterMonitors();
            this.mHelper.unregisterRuntimeMBean();
            this.mHelper.removeLBConfigListener();
            this.mHelper = null;
        }
        catch (Exception ex) {
            this.logWarning("LoadBalancerConfig postDeregistration failed. Load Balancer Monitoring MBeans might be lying around");
        }
    }

    private class LoadBalancerDeregistrationHelper {
        static final String J2EE_TYPE = "j2eeType";
        final ObjectNames objectNames = ObjectNames.getInstance("amx");
        MBeanServer mbs = null;
        String loadBalancerName = null;
        LBConfig lbConfig = null;

        public LoadBalancerDeregistrationHelper(String loadBalancerName, LBConfig lbConfig, MBeanServer mbs) {
            this.mbs = mbs;
            this.loadBalancerName = loadBalancerName;
            this.lbConfig = lbConfig;
        }

        void removeLBConfigListener() throws JMException {
            LBDeregistrationUtil.getInstance(this.mbs).removeLBConfigListener(this.loadBalancerName, this.lbConfig);
        }

        void unregisterRuntimeMBean() throws JMException {
            LoadBalancer loadBalancer = ProxyFactory.getInstance(this.mbs).getDomainRoot().getLoadBalancerMap().get(this.loadBalancerName);
            ObjectName lbObjName = Util.getObjectName(loadBalancer);
            this.mbs.unregisterMBean(lbObjName);
        }

        void unregisterMonitors() throws JMException {
            if (!this.lbConfig.getMonitoringEnabled()) {
                return;
            }
            LoadBalancerMonitor lbm = LBDeregistrationUtil.getInstance(this.mbs).fetchLBMonitoringRoot(this.loadBalancerName);
            Map<String, LoadBalancerClusterMonitor> lbcmMap = lbm.getLoadBalancerClusterMonitorMap();
            for (LoadBalancerClusterMonitor lbcm : lbcmMap.values()) {
                Map<String, LoadBalancerServerMonitor> lbsmMap = lbcm.getLoadBalancerServerMonitorMap();
                for (LoadBalancerServerMonitor lbsm : lbsmMap.values()) {
                    Map<String, LoadBalancerApplicationMonitor> lbamMap = lbsm.getLoadBalancerApplicationMonitorMap();
                    for (LoadBalancerApplicationMonitor lbam : lbamMap.values()) {
                        Map<String, LoadBalancerContextRootMonitor> lbcrmMap = lbam.getLoadBalancerContextRootMonitorMap();
                        for (LoadBalancerContextRootMonitor lbcrm : lbcrmMap.values()) {
                            ObjectName lbcrmObjName = Util.getObjectName(lbcrm);
                            this.mbs.unregisterMBean(lbcrmObjName);
                        }
                        ObjectName lbamObjName = Util.getObjectName(lbam);
                        this.mbs.unregisterMBean(lbamObjName);
                    }
                    ObjectName loadBalancerServerMonitorObjName = Util.getObjectName(lbsm);
                    this.mbs.unregisterMBean(loadBalancerServerMonitorObjName);
                }
                ObjectName lbcmObjName = Util.getObjectName(lbcm);
                this.mbs.unregisterMBean(lbcmObjName);
            }
            ObjectName lbmObjName = Util.getObjectName(lbm);
            this.mbs.unregisterMBean(lbmObjName);
        }
    }
}

