/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.helper;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.DeployedItemRefConfigCR;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.deploy.DeploymentMgr;
import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.helper.DeployNotificationListener;
import com.sun.appserv.management.helper.Helper;
import com.sun.appserv.management.helper.Misc;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeployHelper
extends Helper {
    private DeployNotificationListener mListener;
    private final DeploymentMgr mDeploymentMgr;
    private boolean mDidAssociate;

    public DeployHelper(DeploymentMgr deploymentMgr) {
        super(deploymentMgr.getDomainRoot());
        this.mDeploymentMgr = deploymentMgr;
        this.mListener = null;
        this.mDidAssociate = false;
    }

    public DeployNotificationListener getDeployNotificationListener() {
        return this.mListener;
    }

    public static final String getDefaultAppName(String archiveName) {
        String result = archiveName;
        int idx = archiveName.lastIndexOf(".");
        if (idx > 1) {
            result = archiveName.substring(0, idx);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(File archive, Map<String, String> deployOptions) throws IOException {
        if (archive == null) {
            throw new IllegalArgumentException();
        }
        Object uploadID = Misc.uploadFile(this.getDomainRoot().getUploadDownloadMgr(), archive);
        Object deployID = this.mDeploymentMgr.initDeploy();
        this.mListener = new DeployNotificationListener(this.mDeploymentMgr, deployID);
        try {
            String archiveName = archive.getName();
            HashMap<String, String> actualOptions = new HashMap<String, String>();
            if (deployOptions != null) {
                actualOptions.putAll(deployOptions);
            }
            if (!actualOptions.containsKey("X-DeploymentMgr.Name")) {
                String appName = DeployHelper.getDefaultAppName(archiveName);
                actualOptions.put("X-DeploymentMgr.Name", appName);
            }
            this.mDeploymentMgr.startDeploy(deployID, uploadID, null, actualOptions);
        }
        finally {
            this.mListener.cleanup();
        }
    }

    public DeploymentStatus waitTillDone(long pollMillis) {
        if (pollMillis > 5000L) {
            throw new IllegalArgumentException();
        }
        while (!this.mListener.isCompleted()) {
            Util.sleep(pollMillis);
        }
        DeploymentStatus status = this.mListener.getDeploymentStatus();
        return status;
    }

    public static Set<DeployedItemRefConfigCR> getTargetProxies(DomainRoot domainRoot, String[] names) {
        DomainConfig domainConfig = domainRoot.getDomainConfig();
        HashSet<DeployedItemRefConfigCR> result = new HashSet<DeployedItemRefConfigCR>();
        Map<String, StandaloneServerConfig> serverConfigs = domainConfig.getStandaloneServerConfigMap();
        Map<String, ClusterConfig> clusterConfigs = domainConfig.getClusterConfigMap();
        for (String name : names) {
            if (serverConfigs.containsKey(name)) {
                result.add(serverConfigs.get(name));
                continue;
            }
            if (!clusterConfigs.containsKey(name)) continue;
            result.add(clusterConfigs.get(name));
        }
        return result;
    }

    public Set<DeployedItemRefConfig> createReferences(String[] targets, Map<String, String> refOptions) {
        if (targets == null || targets.length == 0) {
            throw new IllegalArgumentException();
        }
        if (this.mListener == null || !this.mListener.isCompleted()) {
            throw new IllegalStateException();
        }
        DeploymentStatus status = this.mListener.getDeploymentStatus();
        if (status == null || status.getStageStatus() == 0) {
            throw new IllegalStateException();
        }
        if (this.mDidAssociate) {
            throw new IllegalStateException();
        }
        Map<String, Serializable> additionalStatus = status.getAdditionalStatus();
        String moduleID = (String)((Object)additionalStatus.get("ModuleID"));
        HashSet<DeployedItemRefConfig> refs = new HashSet<DeployedItemRefConfig>();
        Set<DeployedItemRefConfigCR> proxies = DeployHelper.getTargetProxies(this.getDomainRoot(), targets);
        for (DeployedItemRefConfigCR cr : proxies) {
            DeployedItemRefConfig ref = cr.createDeployedItemRefConfig(moduleID, refOptions);
            refs.add(ref);
        }
        return refs;
    }

    public DeploymentStatus deploy(File archive, Map<String, String> deployOptions, String[] targets, Map<String, String> refOptions) throws IOException {
        this.deploy(archive, deployOptions);
        DeploymentStatus status = this.waitTillDone(50L);
        if (targets != null && targets.length != 0) {
            this.createReferences(targets, refOptions);
        }
        return status;
    }

    public DeploymentStatus deploy(File archive, String[] targets) throws IOException {
        return this.deploy(archive, null, targets, null);
    }
}

