/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.monitor;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.management.monitor.CallFlowMonitorImpl;
import com.sun.enterprise.management.monitor.MonitoringImplBase;
import com.sun.enterprise.management.support.BootUtil;
import com.sun.enterprise.management.support.ObjectNames;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerRootMonitorImpl
extends MonitoringImplBase {
    private static final Set<String> NOT_SUPERFLUOUS = GSetUtil.newUnmodifiableStringSet("getCallFlowMonitorObjectName", "getORBConnectionManagerMonitorObjectNameMap");
    final Set<String> FAUX_CONTAINEE_TYPES = GSetUtil.newUnmodifiableStringSet("X-EJBModuleMonitor", "X-WebModuleVirtualServerMonitor");

    public ServerRootMonitorImpl() {
        super("X-ServerRootMonitor");
    }

    public Map<String, ObjectName> getORBConnectionManagerMonitorObjectNameMap() {
        return this.getContaineeObjectNameMap("X-ConnectionManagerMonitor");
    }

    @Override
    protected final Set<String> getNotSuperfluousMethods() {
        return GSetUtil.newSet(super.getNotSuperfluousMethods(), NOT_SUPERFLUOUS);
    }

    @Override
    protected void registerMisc() {
        super.registerMisc();
        if (this.getLoader().isDAS()) {
            if (BootUtil.getInstance().getServerName().equals(this.getName())) {
                this.registerCallFlow();
            }
        } else {
            throw new RuntimeException("ServerRootMonitorImpl expected in DAS only");
        }
    }

    public final ObjectName getCallFlowMonitorObjectName() {
        return this.getContaineeObjectName("X-CallFlowMonitor");
    }

    @Override
    protected void unregisterMisc() {
        if (this.getLoader().isDAS()) {
            try {
                this.getMBeanServer().unregisterMBean(this.getCallFlowMonitorObjectName());
            }
            catch (JMException e) {
                this.logWarning("ServerRootMonitorImpl: exception unregistering CallFlowMonitor: " + e);
            }
        }
    }

    protected final void registerCallFlow() {
        ObjectNames objectNames = ObjectNames.getInstance(this.getJMXDomain());
        ObjectName childObjectName = objectNames.buildContaineeObjectName(this.getObjectName(), this.getFullType(), "X-CallFlowMonitor", this.getName());
        CallFlowMonitorImpl callFlow = new CallFlowMonitorImpl();
        try {
            this.debug((Object)("Loading CallFlowMonitor for DAS: " + childObjectName));
            this.getMBeanServer().registerMBean(callFlow, childObjectName);
        }
        catch (JMException e) {
            this.logWarning("ServerRootMonitor: Can't load CallFlow");
        }
    }

    @Override
    protected Set<String> getFauxChildTypes() {
        return this.FAUX_CONTAINEE_TYPES;
    }

    @Override
    public final Set<ObjectName> getContaineeObjectNameSet(String childJ2EEType) {
        Set<ObjectName> result = super.getContaineeObjectNameSet(childJ2EEType);
        if (this.getFauxChildTypes().contains(childJ2EEType)) {
            String nullAppMonitorProp = Util.makeProp("X-ApplicationMonitor", "null");
            Set<ObjectName> fauxContainees = this.getFauxContaineeObjectNameSet(childJ2EEType, nullAppMonitorProp);
            result.addAll(fauxContainees);
        }
        return result;
    }
}

