/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.monitor.LoadBalancerClusterMonitor;
import com.sun.appserv.management.monitor.LoadBalancerMonitor;
import com.sun.appserv.management.monitor.LoadBalancerServerMonitor;
import com.sun.enterprise.management.support.LBBaseMBeanRegistrationListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancerApplicationRefRegistrationListener
extends LBBaseMBeanRegistrationListener {
    public LoadBalancerApplicationRefRegistrationListener(MBeanServer mBeanServer) throws InstanceNotFoundException, IOException {
        super(mBeanServer);
    }

    @Override
    protected void mbeanRegistered(ObjectName objectName) {
        try {
            if ("X-DeployedItemRefConfig".equals(Util.getJ2EEType(objectName))) {
                DeployedItemRefConfig appRefConfig = ProxyFactory.getInstance(this.getConn()).getProxy(objectName, DeployedItemRefConfig.class);
                String appName = appRefConfig.getRef();
                Container parent = appRefConfig.getContainer();
                if (parent instanceof ServerConfig) {
                    Collection<LBConfig> affectedLBConfigArr = this.fetchLBConfigs(((ServerConfig)parent).getName(), false);
                    for (LBConfig lbConfig : affectedLBConfigArr) {
                        List<LoadBalancerMonitor> monitoringRoots = this.fetchLBMonitoringRoots(lbConfig);
                        List<LoadBalancerServerMonitor> serverMonitors = this.fetchLoadBalancerServerMonitors(monitoringRoots, ((ServerConfig)parent).getName(), false);
                        for (LoadBalancerServerMonitor lbsm : serverMonitors) {
                            this.registerLoadBalancerApplicationMonitorTree(lbsm, appName);
                        }
                    }
                } else if (parent instanceof ClusterConfig) {
                    Collection<LBConfig> affectedLBConfigArr = this.fetchLBConfigs(((ClusterConfig)parent).getName(), true);
                    for (LBConfig lbConfig : affectedLBConfigArr) {
                        List<LoadBalancerMonitor> monitoringRoots = this.fetchLBMonitoringRoots(lbConfig);
                        List<LoadBalancerServerMonitor> serverMonitors = this.fetchLoadBalancerServerMonitors(monitoringRoots, ((ClusterConfig)parent).getName(), true);
                        for (LoadBalancerServerMonitor lbsm : serverMonitors) {
                            this.registerLoadBalancerApplicationMonitorTree(lbsm, appName);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logWarning("LoadBalancerApplicationRefRegistrationListener mbeanRegistered failed. Exception = ", ex);
        }
    }

    private List<LoadBalancerServerMonitor> fetchLoadBalancerServerMonitors(List<LoadBalancerMonitor> monitoringRoots, String targetName, boolean isCluster) {
        ArrayList<LoadBalancerServerMonitor> serverMonitors = new ArrayList<LoadBalancerServerMonitor>();
        if (isCluster) {
            List<LoadBalancerClusterMonitor> clusterMonitors = this.fetchLoadBalancerClusterMonitors(monitoringRoots, targetName);
            for (LoadBalancerClusterMonitor lbcm : clusterMonitors) {
                Map<String, LoadBalancerServerMonitor> lbsmMap = lbcm.getLoadBalancerServerMonitorMap();
                serverMonitors.addAll(lbsmMap.values());
            }
        } else {
            for (LoadBalancerMonitor lbm : monitoringRoots) {
                Map<String, LoadBalancerClusterMonitor> lbcmMap = lbm.getLoadBalancerClusterMonitorMap();
                for (LoadBalancerClusterMonitor lbcm : lbcmMap.values()) {
                    Map<String, LoadBalancerServerMonitor> lbsmMap = lbcm.getLoadBalancerServerMonitorMap();
                    for (LoadBalancerServerMonitor lbsm : lbsmMap.values()) {
                        if (!lbsm.getName().equals(targetName)) continue;
                        serverMonitors.add(lbsm);
                    }
                }
            }
        }
        return serverMonitors;
    }
}

