/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.io.File;

public class OS {
    public static final String WINDOWS_BATCH_FILE_EXTENSION = ".bat";

    private OS() {
    }

    public static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public static boolean isUNIX() {
        return File.separatorChar == '/';
    }

    public static boolean isUnix() {
        return OS.isUNIX();
    }

    public static boolean isSun() {
        return OS.isName("sun");
    }

    public static boolean isSolaris10() {
        return OS.isSun() && OS.isVersion("5.10");
    }

    public static boolean isSunSparc() {
        return OS.isName("sun") && OS.isArch("sparc");
    }

    public static boolean isSunX86() {
        return OS.isName("sun") && OS.isArch("x86");
    }

    public static boolean isLinux() {
        return OS.isName("linux");
    }

    public static boolean isDarwin() {
        return OS.isName("Mac OS X");
    }

    public static boolean isWindowsForSure() {
        return OS.isName("windows") && OS.isWindows();
    }

    private static boolean isArch(String name) {
        String archname = System.getProperty("os.arch");
        if (archname == null || archname.length() <= 0) {
            return false;
        }
        return (archname = archname.toLowerCase()).indexOf(name = name.toLowerCase()) >= 0;
    }

    private static boolean isName(String name) {
        String osname = System.getProperty("os.name");
        if (osname == null || osname.length() <= 0) {
            return false;
        }
        return (osname = osname.toLowerCase()).indexOf(name = name.toLowerCase()) >= 0;
    }

    private static boolean isVersion(String version) {
        String osversion = System.getProperty("os.version");
        if (osversion == null || osversion.length() <= 0 || version == null || version.length() <= 0) {
            return false;
        }
        return osversion.equals(version);
    }

    public static void main(String[] args) {
        System.out.println("os.version = " + System.getProperty("os.version"));
        System.out.println("os.name = " + System.getProperty("os.name"));
        System.out.println("os.arch = " + System.getProperty("os.arch"));
        System.out.println("isUNIX() returned: " + OS.isUNIX());
        System.out.println("isWindows() returned: " + OS.isWindows());
        System.out.println("isWindowsForSure() returned: " + OS.isWindowsForSure());
        System.out.println("isSun() returned: " + OS.isSun());
        System.out.println("isLinux() returned: " + OS.isLinux());
        System.out.println("isSunX86() returned: " + OS.isSunX86());
        System.out.println("isSunSparc() returned: " + OS.isSunSparc());
        System.out.println("isDarwin() returned: " + OS.isDarwin());
        System.out.println("isSolaris10() returned: " + OS.isSolaris10());
    }
}

