/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/cmd/CmdReader.java,v 1.3 2005/12/25 03:45:31 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:31 $
 */
 
package com.sun.cli.jmx.cmd;


import com.sun.cli.util.stringifier.SmartStringifier;
import com.sun.cli.util.LineReader;
import com.sun.cli.util.TokenizerImpl;


public class CmdReader implements CmdOutput
{
		public
	CmdReader( )
	{
	}
	
			public void
	print( Object o )
	{
		System.out.print( o.toString() );
	}
	
		public void
	println( Object o )
	{
		System.out.println( o.toString() );
	}
	
		public void
	printError( Object o )
	{
		System.err.println( o.toString() );
	}
	
		public void
	printDebug( Object o )
	{
		println( o );
	}
	
	
		private static void
	p( Object o )
	{
		System.out.println( SmartStringifier.toString( o ) );
	}
	
	
	private final static String ADVISORY =
	"Type 'help' for help, 'quit' to quit.\n";
		
	private final static String USAGE = initUsage();
	
		private static String
	initUsage()
	{
		String	usage	= "*** Available commands ***\n\n";
		
		final CmdStrings.CmdHelp []	allHelp	= CmdStrings.getAllHelp();
		
		for( int i = 0; i < allHelp.length; ++i )
		{
			usage	= usage + allHelp[ i ] + "\n\n";
		}
		
		return( usage );
	}
	
	
		public String
	readLine( LineReader lineReader )
		throws Exception
	{
		String	line	= lineReader.readLine( "> ");
		
		if ( line != null )
		{
			line	= line.trim();
		}
		
		return( line );
	}
	
	private final static String	DELIM_CHARS		= " \t";
	private final static char	ESCAPE_CHAR		= '\\';
	private final static String	ESCAPABLE_CHARS	= DELIM_CHARS + ESCAPE_CHAR + "\"";
		static String []
	lineToTokens( String line )
	{
		final TokenizerImpl tk	= new TokenizerImpl( line, "" + DELIM_CHARS,
										ESCAPE_CHAR, ESCAPABLE_CHARS);
		
		return( tk.getTokens( ) );
	}
	
		public static int
	processLine( final String line, final CmdRunner cmdRunner )
	{
		int	errorCode	= 0;
		
		final String [] tokens	= lineToTokens( line );
		
		try
		{
			final String cmdName	= tokens[ 0 ];
			
			cmdRunner.execute( cmdName, tokens );
		}
		catch (Exception e )
		{
			errorCode	= -1;
		}
		
		return( errorCode );
	}
	
		public void
	processCmd( final String line, final CmdRunner cmdRunner )
	{
		final String [] tokens	= lineToTokens( line );
		
		try
		{
			final String cmdName	= tokens[ 0 ];
			
			cmdRunner.execute( cmdName, tokens );
		}
		catch (Exception e )
		{
		}
	}

		boolean
	isQuitLine( String line )
	{
		final boolean	isQuit	= 
			line == null  ||
			line.equalsIgnoreCase( "quit" ) ||
			line.equalsIgnoreCase( "q" ) ||
			line.equalsIgnoreCase( "exit" );
			line.equalsIgnoreCase( "exit" );
			
		return( isQuit );
	}
	
		public void
	goInteractive(
		final LineReader	lineReader,
		final CmdRunner		cmdRunner )
		throws Exception
	{
		p( ADVISORY );
		
		while ( true )
		{
			final String	line	= readLine( lineReader );
			
			if ( isQuitLine( line ) )
			{
				println( "Quitting..." );
				break;
			}
			
			if ( line.length() == 0 )
				continue;
			
			processLine( line, cmdRunner );
		}
		
	}
}

